/*
 * Decompiled with CFR 0.152.
 */
package shade.io.grpc.internal;

import com.pingcap.com.google.common.annotations.VisibleForTesting;
import com.pingcap.com.google.common.base.MoreObjects;
import com.pingcap.com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import shade.io.grpc.Attributes;
import shade.io.grpc.ChannelLogger;
import shade.io.grpc.ConnectivityState;
import shade.io.grpc.ConnectivityStateInfo;
import shade.io.grpc.EquivalentAddressGroup;
import shade.io.grpc.LoadBalancer;
import shade.io.grpc.LoadBalancerProvider;
import shade.io.grpc.LoadBalancerRegistry;
import shade.io.grpc.NameResolver;
import shade.io.grpc.Status;
import shade.io.grpc.internal.ServiceConfigUtil;

public final class AutoConfiguredLoadBalancerFactory {
    private final LoadBalancerRegistry registry;
    private final String defaultPolicy;

    public AutoConfiguredLoadBalancerFactory(String defaultPolicy) {
        this(LoadBalancerRegistry.getDefaultRegistry(), defaultPolicy);
    }

    @VisibleForTesting
    AutoConfiguredLoadBalancerFactory(LoadBalancerRegistry registry, String defaultPolicy) {
        this.registry = Preconditions.checkNotNull(registry, "registry");
        this.defaultPolicy = Preconditions.checkNotNull(defaultPolicy, "defaultPolicy");
    }

    public AutoConfiguredLoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new AutoConfiguredLoadBalancer(helper);
    }

    private LoadBalancerProvider getProviderOrThrow(String policy, String choiceReason) throws PolicyException {
        LoadBalancerProvider provider = this.registry.getProvider(policy);
        if (provider == null) {
            throw new PolicyException("Trying to load '" + policy + "' because " + choiceReason + ", but it's unavailable");
        }
        return provider;
    }

    @Nullable
    NameResolver.ConfigOrError parseLoadBalancerPolicy(Map<String, ?> serviceConfig, ChannelLogger channelLogger) {
        try {
            List<ServiceConfigUtil.LbConfig> loadBalancerConfigs = null;
            if (serviceConfig != null) {
                List<Map<String, ?>> rawLbConfigs = ServiceConfigUtil.getLoadBalancingConfigsFromServiceConfig(serviceConfig);
                loadBalancerConfigs = ServiceConfigUtil.unwrapLoadBalancingConfigList(rawLbConfigs);
            }
            if (loadBalancerConfigs != null && !loadBalancerConfigs.isEmpty()) {
                return ServiceConfigUtil.selectLbPolicyFromList(loadBalancerConfigs, this.registry);
            }
            return null;
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("can't parse load balancer configuration").withCause(e));
        }
    }

    private static final class FailingPicker
    extends LoadBalancer.SubchannelPicker {
        private final Status failure;

        FailingPicker(Status failure) {
            this.failure = failure;
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withError(this.failure);
        }
    }

    private static final class EmptyPicker
    extends LoadBalancer.SubchannelPicker {
        private EmptyPicker() {
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withNoResult();
        }

        public String toString() {
            return MoreObjects.toStringHelper(EmptyPicker.class).toString();
        }
    }

    @VisibleForTesting
    static final class PolicyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private PolicyException(String msg) {
            super(msg);
        }
    }

    @VisibleForTesting
    public final class AutoConfiguredLoadBalancer {
        private final LoadBalancer.Helper helper;
        private LoadBalancer delegate;
        private LoadBalancerProvider delegateProvider;

        AutoConfiguredLoadBalancer(LoadBalancer.Helper helper) {
            this.helper = helper;
            this.delegateProvider = AutoConfiguredLoadBalancerFactory.this.registry.getProvider(AutoConfiguredLoadBalancerFactory.this.defaultPolicy);
            if (this.delegateProvider == null) {
                throw new IllegalStateException("Could not find policy '" + AutoConfiguredLoadBalancerFactory.this.defaultPolicy + "'. Make sure its implementation is either registered to LoadBalancerRegistry or included in META-INF/services/io.grpc.LoadBalancerProvider from your jar files.");
            }
            this.delegate = this.delegateProvider.newLoadBalancer(helper);
        }

        public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            this.tryHandleResolvedAddresses(resolvedAddresses);
        }

        Status tryHandleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            Object lbConfig;
            List<EquivalentAddressGroup> servers = resolvedAddresses.getAddresses();
            Attributes attributes = resolvedAddresses.getAttributes();
            if (attributes.get(LoadBalancer.ATTR_LOAD_BALANCING_CONFIG) != null) {
                throw new IllegalArgumentException("Unexpected ATTR_LOAD_BALANCING_CONFIG from upstream: " + attributes.get(LoadBalancer.ATTR_LOAD_BALANCING_CONFIG));
            }
            ServiceConfigUtil.PolicySelection policySelection = (ServiceConfigUtil.PolicySelection)resolvedAddresses.getLoadBalancingPolicyConfig();
            if (policySelection == null) {
                LoadBalancerProvider defaultProvider;
                try {
                    defaultProvider = AutoConfiguredLoadBalancerFactory.this.getProviderOrThrow(AutoConfiguredLoadBalancerFactory.this.defaultPolicy, "using default policy");
                }
                catch (PolicyException e) {
                    Status s = Status.INTERNAL.withDescription(e.getMessage());
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new FailingPicker(s));
                    this.delegate.shutdown();
                    this.delegateProvider = null;
                    this.delegate = new NoopLoadBalancer();
                    return Status.OK;
                }
                policySelection = new ServiceConfigUtil.PolicySelection(defaultProvider, null, null);
            }
            if (this.delegateProvider == null || !policySelection.provider.getPolicyName().equals(this.delegateProvider.getPolicyName())) {
                this.helper.updateBalancingState(ConnectivityState.CONNECTING, new EmptyPicker());
                this.delegate.shutdown();
                this.delegateProvider = policySelection.provider;
                LoadBalancer old = this.delegate;
                this.delegate = this.delegateProvider.newLoadBalancer(this.helper);
                this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Load balancer changed from {0} to {1}", old.getClass().getSimpleName(), this.delegate.getClass().getSimpleName());
            }
            if ((lbConfig = policySelection.config) != null) {
                this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.DEBUG, "Load-balancing config: {0}", policySelection.config);
                attributes = attributes.toBuilder().set(LoadBalancer.ATTR_LOAD_BALANCING_CONFIG, policySelection.rawConfig).build();
            }
            LoadBalancer delegate = this.getDelegate();
            if (resolvedAddresses.getAddresses().isEmpty() && !delegate.canHandleEmptyAddressListFromNameResolution()) {
                return Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. addrs=" + servers + ", attrs=" + attributes);
            }
            delegate.handleResolvedAddresses(LoadBalancer.ResolvedAddresses.newBuilder().setAddresses(resolvedAddresses.getAddresses()).setAttributes(attributes).setLoadBalancingPolicyConfig(lbConfig).build());
            return Status.OK;
        }

        void handleNameResolutionError(Status error) {
            this.getDelegate().handleNameResolutionError(error);
        }

        @Deprecated
        void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            this.getDelegate().handleSubchannelState(subchannel, stateInfo);
        }

        void requestConnection() {
            this.getDelegate().requestConnection();
        }

        void shutdown() {
            this.delegate.shutdown();
            this.delegate = null;
        }

        @VisibleForTesting
        public LoadBalancer getDelegate() {
            return this.delegate;
        }

        @VisibleForTesting
        void setDelegate(LoadBalancer lb) {
            this.delegate = lb;
        }

        @VisibleForTesting
        LoadBalancerProvider getDelegateProvider() {
            return this.delegateProvider;
        }
    }

    private static final class NoopLoadBalancer
    extends LoadBalancer {
        private NoopLoadBalancer() {
        }

        @Override
        @Deprecated
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> s, Attributes a) {
        }

        @Override
        public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        }

        @Override
        public void handleNameResolutionError(Status error) {
        }

        @Override
        public void shutdown() {
        }
    }
}

