/*
 * Decompiled with CFR 0.152.
 */
package shade.io.netty.handler.ipfilter;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;
import shade.io.netty.channel.ChannelFuture;
import shade.io.netty.channel.ChannelFutureListener;
import shade.io.netty.channel.ChannelHandler;
import shade.io.netty.channel.ChannelHandlerContext;
import shade.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import shade.io.netty.util.internal.ConcurrentSet;

@ChannelHandler.Sharable
public class UniqueIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final Set<InetAddress> connected = new ConcurrentSet<InetAddress>();

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        final InetAddress remoteIp = remoteAddress.getAddress();
        if (!this.connected.add(remoteIp)) {
            return false;
        }
        ctx.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                UniqueIpFilter.this.connected.remove(remoteIp);
            }
        });
        return true;
    }
}

