/*
 * Copyright 2020 PingCAP, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.pingcap.tikv.exception;

public class AllocateRowIDOverflowException extends RuntimeException {
  public AllocateRowIDOverflowException(long current, long step, long shardRowBits) {
    super(
        String.format(
            "Overflow when allocating row id with current=%d, step=%d, shard bit=%d",
            current, step, shardRowBits));
  }
}
