/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.operation.ErrorHandler;
import com.pingcap.tikv.policy.RetryMaxMs;
import com.pingcap.tikv.streaming.StreamingResponse;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ChannelFactory;
import com.pingcap.tikv.util.ConcreteBackOffer;
import com.pingcap.tikv.util.HostMapping;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.io.grpc.ManagedChannel;
import shade.io.grpc.MethodDescriptor;
import shade.io.grpc.health.v1.HealthCheckRequest;
import shade.io.grpc.health.v1.HealthCheckResponse;
import shade.io.grpc.health.v1.HealthGrpc;
import shade.io.grpc.stub.AbstractStub;
import shade.io.grpc.stub.ClientCalls;
import shade.io.grpc.stub.StreamObserver;

public abstract class AbstractGRPCClient<BlockingStubT extends AbstractStub<BlockingStubT>, StubT extends AbstractStub<StubT>>
implements AutoCloseable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ChannelFactory channelFactory;
    protected TiConfiguration conf;
    protected BlockingStubT blockingStub;
    protected StubT asyncStub;
    protected long timeout;

    protected AbstractGRPCClient(TiConfiguration conf, ChannelFactory channelFactory) {
        this.conf = conf;
        this.timeout = conf.getTimeout();
        this.channelFactory = channelFactory;
    }

    protected AbstractGRPCClient(TiConfiguration conf, ChannelFactory channelFactory, BlockingStubT blockingStub, StubT asyncStub) {
        this.conf = conf;
        this.timeout = conf.getTimeout();
        this.channelFactory = channelFactory;
        this.blockingStub = blockingStub;
        this.asyncStub = asyncStub;
    }

    public TiConfiguration getConf() {
        return this.conf;
    }

    public <ReqT, RespT> RespT callWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, Supplier<ReqT> requestFactory, ErrorHandler<RespT> handler) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Calling %s...", method.getFullMethodName()));
        }
        RetryMaxMs.Builder<RespT> builder = new RetryMaxMs.Builder<RespT>(backOffer);
        Object resp = builder.create(handler).callWithRetry(() -> {
            BlockingStubT stub = this.getBlockingStub();
            return ClientCalls.blockingUnaryCall(((AbstractStub)stub).getChannel(), method, ((AbstractStub)stub).getCallOptions(), requestFactory.get());
        }, method.getFullMethodName());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("leaving %s...", method.getFullMethodName()));
        }
        return (RespT)resp;
    }

    protected <ReqT, RespT> void callAsyncWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, Supplier<ReqT> requestFactory, StreamObserver<RespT> responseObserver, ErrorHandler<RespT> handler) {
        this.logger.debug(String.format("Calling %s...", method.getFullMethodName()));
        RetryMaxMs.Builder<RespT> builder = new RetryMaxMs.Builder<RespT>(backOffer);
        builder.create(handler).callWithRetry(() -> {
            StubT stub = this.getAsyncStub();
            ClientCalls.asyncUnaryCall(((AbstractStub)stub).getChannel().newCall(method, ((AbstractStub)stub).getCallOptions()), requestFactory.get(), responseObserver);
            return null;
        }, method.getFullMethodName());
        this.logger.debug(String.format("leaving %s...", method.getFullMethodName()));
    }

    <ReqT, RespT> StreamObserver<ReqT> callBidiStreamingWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, StreamObserver<RespT> responseObserver, ErrorHandler<StreamObserver<ReqT>> handler) {
        this.logger.debug(String.format("Calling %s...", method.getFullMethodName()));
        RetryMaxMs.Builder<StreamObserver<ReqT>> builder = new RetryMaxMs.Builder<StreamObserver<ReqT>>(backOffer);
        StreamObserver observer = builder.create(handler).callWithRetry(() -> {
            StubT stub = this.getAsyncStub();
            return ClientCalls.asyncBidiStreamingCall(((AbstractStub)stub).getChannel().newCall(method, ((AbstractStub)stub).getCallOptions()), responseObserver);
        }, method.getFullMethodName());
        this.logger.debug(String.format("leaving %s...", method.getFullMethodName()));
        return observer;
    }

    public <ReqT, RespT> StreamingResponse callServerStreamingWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, Supplier<ReqT> requestFactory, ErrorHandler<StreamingResponse> handler) {
        this.logger.debug(String.format("Calling %s...", method.getFullMethodName()));
        RetryMaxMs.Builder<StreamingResponse> builder = new RetryMaxMs.Builder<StreamingResponse>(backOffer);
        StreamingResponse response = builder.create(handler).callWithRetry(() -> {
            BlockingStubT stub = this.getBlockingStub();
            return new StreamingResponse(ClientCalls.blockingServerStreamingCall(((AbstractStub)stub).getChannel(), method, ((AbstractStub)stub).getCallOptions(), requestFactory.get()));
        }, method.getFullMethodName());
        this.logger.debug(String.format("leaving %s...", method.getFullMethodName()));
        return response;
    }

    protected abstract BlockingStubT getBlockingStub();

    protected abstract StubT getAsyncStub();

    public long getTimeout() {
        return this.timeout;
    }

    private boolean doCheckHealth(BackOffer backOffer, String addressStr, HostMapping hostMapping) {
        while (true) {
            try {
                ManagedChannel channel = this.channelFactory.getChannel(addressStr, hostMapping);
                HealthGrpc.HealthBlockingStub stub = (HealthGrpc.HealthBlockingStub)HealthGrpc.newBlockingStub(channel).withDeadlineAfter(this.getTimeout(), TimeUnit.MINUTES);
                HealthCheckRequest req = HealthCheckRequest.newBuilder().build();
                HealthCheckResponse resp = stub.check(req);
                return resp.getStatus() == HealthCheckResponse.ServingStatus.SERVING;
            }
            catch (Exception e) {
                this.logger.warn("check health failed.", (Throwable)e);
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoCheckHealth, e);
                continue;
            }
            break;
        }
    }

    protected boolean checkHealth(String addressStr, HostMapping hostMapping) {
        ConcreteBackOffer backOffer = ConcreteBackOffer.newCustomBackOff((int)(this.timeout * 2L));
        try {
            return this.doCheckHealth(backOffer, addressStr, hostMapping);
        }
        catch (Exception e) {
            return false;
        }
    }
}

