/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.com.google.common.annotations.Beta;
import com.pingcap.tikv.pd.PDUtils;
import com.pingcap.tikv.util.HostMapping;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHostMapping
implements HostMapping {
    private static final String NETWORK_MAPPING_PATH = "/client/url-mapping";
    private final Client etcdClient;
    private final String networkMappingName;
    private final ConcurrentMap<String, String> hostMapping;
    private final Logger logger = LoggerFactory.getLogger(DefaultHostMapping.class);

    public DefaultHostMapping(Client etcdClient, String networkMappingName) {
        this.etcdClient = etcdClient;
        this.networkMappingName = networkMappingName;
        this.hostMapping = new ConcurrentHashMap<String, String>();
    }

    private ByteSequence hostToNetworkMappingKey(String host) {
        String path = "/client/url-mapping/" + this.networkMappingName + "/" + host;
        return ByteSequence.from(path, StandardCharsets.UTF_8);
    }

    @Beta
    private String getMappedHostFromPD(String host) {
        ByteSequence hostKey = this.hostToNetworkMappingKey(host);
        for (int i = 0; i < 5; ++i) {
            CompletableFuture<GetResponse> future = this.etcdClient.getKVClient().get(hostKey);
            try {
                GetResponse resp = future.get();
                List<KeyValue> kvs = resp.getKvs();
                if (kvs.size() == 1) {
                    return kvs.get(0).getValue().toString(StandardCharsets.UTF_8);
                }
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                this.logger.info("failed to get mapped Host from PD: " + host, (Throwable)e);
                break;
            }
            catch (Exception ignore) {
                break;
            }
        }
        return host;
    }

    @Override
    public URI getMappedURI(URI uri) {
        if (this.networkMappingName.isEmpty()) {
            return uri;
        }
        return PDUtils.addrToUrl(this.hostMapping.computeIfAbsent(uri.getHost(), this::getMappedHostFromPD) + ":" + uri.getPort());
    }
}

