/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.TiKVException;
import com.pingcap.tikv.region.RegionStoreClient;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.Batch;
import com.pingcap.tikv.util.ClientUtils;
import com.pingcap.tikv.util.ConcreteBackOffer;
import com.pingcap.tikv.util.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;

public class KVClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(KVClient.class);
    private static final int MAX_BATCH_LIMIT = 1024;
    private static final int BATCH_GET_SIZE = 16384;
    private final RegionStoreClient.RegionStoreClientBuilder clientBuilder;
    private final TiConfiguration conf;
    private final ExecutorService batchGetThreadPool;

    public KVClient(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder clientBuilder, ExecutorService batchGetThreadPool) {
        Objects.requireNonNull(conf, "conf is null");
        Objects.requireNonNull(clientBuilder, "clientBuilder is null");
        this.conf = conf;
        this.clientBuilder = clientBuilder;
        this.batchGetThreadPool = batchGetThreadPool;
    }

    @Override
    public void close() {
    }

    public ByteString get(ByteString key, long version) throws GrpcException {
        ConcreteBackOffer backOffer = ConcreteBackOffer.newGetBackOff();
        while (true) {
            RegionStoreClient client = this.clientBuilder.build(key);
            try {
                return client.get(backOffer, key, version);
            }
            catch (TiKVException e) {
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                continue;
            }
            break;
        }
    }

    public List<Kvrpcpb.KvPair> batchGet(BackOffer backOffer, List<ByteString> keys, long version) throws GrpcException {
        return this.doSendBatchGet(backOffer, keys, version);
    }

    private List<Kvrpcpb.KvPair> doSendBatchGet(BackOffer backOffer, List<ByteString> keys, long version) {
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.batchGetThreadPool);
        List<Batch> batches = ClientUtils.getBatches(backOffer, keys, 16384, 1024, this.clientBuilder);
        LinkedList taskQueue = new LinkedList();
        ArrayList<Kvrpcpb.KvPair> result = new ArrayList<Kvrpcpb.KvPair>();
        taskQueue.offer(batches);
        while (!taskQueue.isEmpty()) {
            List task = (List)taskQueue.poll();
            for (Batch batch : task) {
                completionService.submit(() -> this.doSendBatchGetInBatchesWithRetry(batch.getBackOffer(), batch, version));
            }
            result.addAll(ClientUtils.getTasksWithOutput(completionService, taskQueue, task, 40000));
        }
        return result;
    }

    private Pair<List<Batch>, List<Kvrpcpb.KvPair>> doSendBatchGetInBatchesWithRetry(BackOffer backOffer, Batch batch, long version) {
        TiRegion currentRegion;
        TiRegion oldRegion = batch.getRegion();
        if (oldRegion.equals(currentRegion = this.clientBuilder.getRegionManager().getRegionByKey(batch.getRegion().getStartKey()))) {
            RegionStoreClient client = this.clientBuilder.build(batch.getRegion());
            try {
                List<Kvrpcpb.KvPair> partialResult = client.batchGet(backOffer, batch.getKeys(), version);
                return Pair.create(new ArrayList(), partialResult);
            }
            catch (TiKVException e) {
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                this.clientBuilder.getRegionManager().invalidateRegion(batch.getRegion());
                logger.debug("ReSplitting ranges for BatchGetRequest", (Throwable)e);
                return this.doRetryBatchGet(backOffer, batch);
            }
        }
        return this.doRetryBatchGet(backOffer, batch);
    }

    private Pair<List<Batch>, List<Kvrpcpb.KvPair>> doRetryBatchGet(BackOffer backOffer, Batch batch) {
        return Pair.create(this.doSendBatchGetWithRefetchRegion(backOffer, batch), new ArrayList());
    }

    private List<Batch> doSendBatchGetWithRefetchRegion(BackOffer backOffer, Batch batch) {
        return ClientUtils.getBatches(backOffer, batch.getKeys(), 16384, 1024, this.clientBuilder);
    }
}

