/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.tikv.Utils;
import com.pingcap.tikv.meta.Collation;
import com.pingcap.tikv.pd.PDUtils;
import com.pingcap.tikv.region.TiStoreType;
import com.pingcap.tikv.types.Converter;
import com.pingcap.tikv.util.HostMapping;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.tikv.kvproto.Kvrpcpb;

public class TiConfiguration
implements Serializable {
    private static final DateTimeZone DEF_TIMEZONE = Converter.getLocalTimezone();
    private static final int DEF_TIMEOUT = 10;
    private static final TimeUnit DEF_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private static final int DEF_SCAN_BATCH_SIZE = 10480;
    private static final boolean DEF_IGNORE_TRUNCATE = true;
    private static final boolean DEF_TRUNCATE_AS_WARNING = false;
    private static final int DEF_MAX_FRAME_SIZE = Integer.MAX_VALUE;
    private static final int DEF_INDEX_SCAN_BATCH_SIZE = 20000;
    private static final int DEF_REGION_SCAN_DOWNGRADE_THRESHOLD = 10000000;
    private static final int MAX_REQUEST_KEY_RANGE_SIZE = 20000;
    private static final int DEF_INDEX_SCAN_CONCURRENCY = 5;
    private static final int DEF_TABLE_SCAN_CONCURRENCY = 512;
    private static final int DEF_BATCH_GET_CONCURRENCY = 20;
    private static final int DEF_BATCH_PUT_CONCURRENCY = 20;
    private static final int DEF_BATCH_DELETE_CONCURRENCY = 20;
    private static final int DEF_BATCH_SCAN_CONCURRENCY = 5;
    private static final int DEF_DELETE_RANGE_CONCURRENCY = 20;
    private static final Kvrpcpb.CommandPri DEF_COMMAND_PRIORITY = Kvrpcpb.CommandPri.Low;
    private static final Kvrpcpb.IsolationLevel DEF_ISOLATION_LEVEL = Kvrpcpb.IsolationLevel.SI;
    private static final boolean DEF_SHOW_ROWID = false;
    private static final String DEF_DB_PREFIX = "";
    private static final boolean DEF_WRITE_ENABLE = true;
    private static final boolean DEF_WRITE_ALLOW_SPARK_SQL = false;
    private static final boolean DEF_WRITE_WITHOUT_LOCK_TABLE = false;
    private static final int DEF_TIKV_REGION_SPLIT_SIZE_IN_MB = 96;
    private static final int DEF_PARTITION_PER_SPLIT = 10;
    private static final int DEF_KV_CLIENT_CONCURRENCY = 10;
    private static final List<TiStoreType> DEF_ISOLATION_READ_ENGINES = ImmutableList.of(TiStoreType.TiKV, TiStoreType.TiFlash);
    private static final String DEF_TIKV_CONN_RECYCLE_TIME = "60s";
    private static final String DEF_TIKV_TLS_RELOAD_INTERVAL = "10s";
    private int timeout = 10;
    private TimeUnit timeoutUnit = DEF_TIMEOUT_UNIT;
    private boolean ignoreTruncate = true;
    private boolean truncateAsWarning = false;
    private int maxFrameSize = Integer.MAX_VALUE;
    private List<URI> pdAddrs = new ArrayList<URI>();
    private int indexScanBatchSize = 20000;
    private int downgradeThreshold = 10000000;
    private int indexScanConcurrency = 5;
    private int tableScanConcurrency = 512;
    private int batchGetConcurrency = 20;
    private int batchPutConcurrency = 20;
    private int batchDeleteConcurrency = 20;
    private int batchScanConcurrency = 5;
    private int deleteRangeConcurrency = 20;
    private Kvrpcpb.CommandPri commandPriority = DEF_COMMAND_PRIORITY;
    private Kvrpcpb.IsolationLevel isolationLevel = DEF_ISOLATION_LEVEL;
    private int maxRequestKeyRangeSize = 20000;
    private boolean showRowId = false;
    private String DBPrefix = "";
    private boolean writeAllowSparkSQL = false;
    private boolean writeEnable = true;
    private boolean writeWithoutLockTable = false;
    private int tikvRegionSplitSizeInMB = 96;
    private int partitionPerSplit = 10;
    private int kvClientConcurrency = 10;
    private List<TiStoreType> isolationReadEngines = DEF_ISOLATION_READ_ENGINES;
    private boolean tlsEnable = false;
    private String trustCertCollectionFile;
    private String keyCertChainFile;
    private String keyFile;
    private boolean jksEnable = false;
    private String jksKeyPath;
    private String jksKeyPassword;
    private String jksTrustPath;
    private String jksTrustPassword;
    private long connRecycleTime = TiConfiguration.getTimeAsSeconds("60s");
    private long certReloadInterval = TiConfiguration.getTimeAsSeconds("10s");
    private String networkMappingName = "";
    private HostMapping hostMapping;
    private Boolean newCollationEnabled;

    private static Long getTimeAsSeconds(String key) {
        return Utils.timeStringAsSec(key);
    }

    public static TiConfiguration createDefault(String pdAddrsStr) {
        Objects.requireNonNull(pdAddrsStr, "pdAddrsStr is null");
        TiConfiguration conf = new TiConfiguration();
        conf.pdAddrs = TiConfiguration.strToURI(pdAddrsStr);
        return conf;
    }

    private static List<URI> strToURI(String addressStr) {
        Objects.requireNonNull(addressStr);
        Object[] addrs = addressStr.split(",");
        Arrays.sort(addrs);
        return PDUtils.addrsToUrls((String[])addrs);
    }

    public static <E> String listToString(List<E> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i).toString());
            if (i == list.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public DateTimeZone getLocalTimeZone() {
        return DEF_TIMEZONE;
    }

    public String getPdAddrsString() {
        return TiConfiguration.listToString(this.pdAddrs);
    }

    public int getScanBatchSize() {
        return 10480;
    }

    public void setMaxRequestKeyRangeSize(int maxRequestKeyRangeSize) {
        if (maxRequestKeyRangeSize <= 0) {
            throw new IllegalArgumentException("Key range size cannot be less than 1");
        }
        this.maxRequestKeyRangeSize = maxRequestKeyRangeSize;
    }

    public TiConfiguration setConnRecycleTimeInSeconds(String connRecycleTime) {
        this.connRecycleTime = TiConfiguration.getTimeAsSeconds(connRecycleTime);
        return this;
    }

    public TiConfiguration setCertReloadIntervalInSeconds(String interval) {
        this.certReloadInterval = TiConfiguration.getTimeAsSeconds(interval);
        return this;
    }

    public void setNewCollationEnable(Boolean flag) {
        this.newCollationEnabled = flag;
        Collation.setNewCollationEnabled(flag);
    }

    public Optional<Boolean> getNewCollationEnable() {
        return Optional.ofNullable(this.newCollationEnabled);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public boolean isIgnoreTruncate() {
        return this.ignoreTruncate;
    }

    public boolean isTruncateAsWarning() {
        return this.truncateAsWarning;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public List<URI> getPdAddrs() {
        return this.pdAddrs;
    }

    public int getIndexScanBatchSize() {
        return this.indexScanBatchSize;
    }

    public int getDowngradeThreshold() {
        return this.downgradeThreshold;
    }

    public int getIndexScanConcurrency() {
        return this.indexScanConcurrency;
    }

    public int getTableScanConcurrency() {
        return this.tableScanConcurrency;
    }

    public int getBatchGetConcurrency() {
        return this.batchGetConcurrency;
    }

    public int getBatchPutConcurrency() {
        return this.batchPutConcurrency;
    }

    public int getBatchDeleteConcurrency() {
        return this.batchDeleteConcurrency;
    }

    public int getBatchScanConcurrency() {
        return this.batchScanConcurrency;
    }

    public int getDeleteRangeConcurrency() {
        return this.deleteRangeConcurrency;
    }

    public Kvrpcpb.CommandPri getCommandPriority() {
        return this.commandPriority;
    }

    public Kvrpcpb.IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public int getMaxRequestKeyRangeSize() {
        return this.maxRequestKeyRangeSize;
    }

    public boolean isShowRowId() {
        return this.showRowId;
    }

    public String getDBPrefix() {
        return this.DBPrefix;
    }

    public boolean isWriteAllowSparkSQL() {
        return this.writeAllowSparkSQL;
    }

    public boolean isWriteEnable() {
        return this.writeEnable;
    }

    public boolean isWriteWithoutLockTable() {
        return this.writeWithoutLockTable;
    }

    public int getTikvRegionSplitSizeInMB() {
        return this.tikvRegionSplitSizeInMB;
    }

    public int getPartitionPerSplit() {
        return this.partitionPerSplit;
    }

    public int getKvClientConcurrency() {
        return this.kvClientConcurrency;
    }

    public List<TiStoreType> getIsolationReadEngines() {
        return this.isolationReadEngines;
    }

    public boolean isTlsEnable() {
        return this.tlsEnable;
    }

    public String getTrustCertCollectionFile() {
        return this.trustCertCollectionFile;
    }

    public String getKeyCertChainFile() {
        return this.keyCertChainFile;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public boolean isJksEnable() {
        return this.jksEnable;
    }

    public String getJksKeyPath() {
        return this.jksKeyPath;
    }

    public String getJksKeyPassword() {
        return this.jksKeyPassword;
    }

    public String getJksTrustPath() {
        return this.jksTrustPath;
    }

    public String getJksTrustPassword() {
        return this.jksTrustPassword;
    }

    public long getConnRecycleTime() {
        return this.connRecycleTime;
    }

    public long getCertReloadInterval() {
        return this.certReloadInterval;
    }

    public String getNetworkMappingName() {
        return this.networkMappingName;
    }

    public HostMapping getHostMapping() {
        return this.hostMapping;
    }

    public Boolean getNewCollationEnabled() {
        return this.newCollationEnabled;
    }

    public TiConfiguration setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public TiConfiguration setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    public TiConfiguration setIgnoreTruncate(boolean ignoreTruncate) {
        this.ignoreTruncate = ignoreTruncate;
        return this;
    }

    public TiConfiguration setTruncateAsWarning(boolean truncateAsWarning) {
        this.truncateAsWarning = truncateAsWarning;
        return this;
    }

    public TiConfiguration setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public TiConfiguration setPdAddrs(List<URI> pdAddrs) {
        this.pdAddrs = pdAddrs;
        return this;
    }

    public TiConfiguration setIndexScanBatchSize(int indexScanBatchSize) {
        this.indexScanBatchSize = indexScanBatchSize;
        return this;
    }

    public TiConfiguration setDowngradeThreshold(int downgradeThreshold) {
        this.downgradeThreshold = downgradeThreshold;
        return this;
    }

    public TiConfiguration setIndexScanConcurrency(int indexScanConcurrency) {
        this.indexScanConcurrency = indexScanConcurrency;
        return this;
    }

    public TiConfiguration setTableScanConcurrency(int tableScanConcurrency) {
        this.tableScanConcurrency = tableScanConcurrency;
        return this;
    }

    public TiConfiguration setBatchGetConcurrency(int batchGetConcurrency) {
        this.batchGetConcurrency = batchGetConcurrency;
        return this;
    }

    public TiConfiguration setBatchPutConcurrency(int batchPutConcurrency) {
        this.batchPutConcurrency = batchPutConcurrency;
        return this;
    }

    public TiConfiguration setBatchDeleteConcurrency(int batchDeleteConcurrency) {
        this.batchDeleteConcurrency = batchDeleteConcurrency;
        return this;
    }

    public TiConfiguration setBatchScanConcurrency(int batchScanConcurrency) {
        this.batchScanConcurrency = batchScanConcurrency;
        return this;
    }

    public TiConfiguration setDeleteRangeConcurrency(int deleteRangeConcurrency) {
        this.deleteRangeConcurrency = deleteRangeConcurrency;
        return this;
    }

    public TiConfiguration setCommandPriority(Kvrpcpb.CommandPri commandPriority) {
        this.commandPriority = commandPriority;
        return this;
    }

    public TiConfiguration setIsolationLevel(Kvrpcpb.IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public TiConfiguration setShowRowId(boolean showRowId) {
        this.showRowId = showRowId;
        return this;
    }

    public TiConfiguration setDBPrefix(String DBPrefix) {
        this.DBPrefix = DBPrefix;
        return this;
    }

    public TiConfiguration setWriteAllowSparkSQL(boolean writeAllowSparkSQL) {
        this.writeAllowSparkSQL = writeAllowSparkSQL;
        return this;
    }

    public TiConfiguration setWriteEnable(boolean writeEnable) {
        this.writeEnable = writeEnable;
        return this;
    }

    public TiConfiguration setWriteWithoutLockTable(boolean writeWithoutLockTable) {
        this.writeWithoutLockTable = writeWithoutLockTable;
        return this;
    }

    public TiConfiguration setTikvRegionSplitSizeInMB(int tikvRegionSplitSizeInMB) {
        this.tikvRegionSplitSizeInMB = tikvRegionSplitSizeInMB;
        return this;
    }

    public TiConfiguration setPartitionPerSplit(int partitionPerSplit) {
        this.partitionPerSplit = partitionPerSplit;
        return this;
    }

    public TiConfiguration setKvClientConcurrency(int kvClientConcurrency) {
        this.kvClientConcurrency = kvClientConcurrency;
        return this;
    }

    public TiConfiguration setIsolationReadEngines(List<TiStoreType> isolationReadEngines) {
        this.isolationReadEngines = isolationReadEngines;
        return this;
    }

    public TiConfiguration setTlsEnable(boolean tlsEnable) {
        this.tlsEnable = tlsEnable;
        return this;
    }

    public TiConfiguration setTrustCertCollectionFile(String trustCertCollectionFile) {
        this.trustCertCollectionFile = trustCertCollectionFile;
        return this;
    }

    public TiConfiguration setKeyCertChainFile(String keyCertChainFile) {
        this.keyCertChainFile = keyCertChainFile;
        return this;
    }

    public TiConfiguration setKeyFile(String keyFile) {
        this.keyFile = keyFile;
        return this;
    }

    public TiConfiguration setJksEnable(boolean jksEnable) {
        this.jksEnable = jksEnable;
        return this;
    }

    public TiConfiguration setJksKeyPath(String jksKeyPath) {
        this.jksKeyPath = jksKeyPath;
        return this;
    }

    public TiConfiguration setJksKeyPassword(String jksKeyPassword) {
        this.jksKeyPassword = jksKeyPassword;
        return this;
    }

    public TiConfiguration setJksTrustPath(String jksTrustPath) {
        this.jksTrustPath = jksTrustPath;
        return this;
    }

    public TiConfiguration setJksTrustPassword(String jksTrustPassword) {
        this.jksTrustPassword = jksTrustPassword;
        return this;
    }

    public TiConfiguration setConnRecycleTime(long connRecycleTime) {
        this.connRecycleTime = connRecycleTime;
        return this;
    }

    public TiConfiguration setCertReloadInterval(long certReloadInterval) {
        this.certReloadInterval = certReloadInterval;
        return this;
    }

    public TiConfiguration setNetworkMappingName(String networkMappingName) {
        this.networkMappingName = networkMappingName;
        return this;
    }

    public TiConfiguration setHostMapping(HostMapping hostMapping) {
        this.hostMapping = hostMapping;
        return this;
    }

    public TiConfiguration setNewCollationEnabled(Boolean newCollationEnabled) {
        this.newCollationEnabled = newCollationEnabled;
        return this;
    }
}

