/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.codec;

import com.pingcap.com.google.common.base.Preconditions;
import com.pingcap.tikv.ExtendedDateTime;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.codec.MyDecimal;
import com.pingcap.tikv.exception.CodecException;
import com.pingcap.tikv.exception.ConvertOverflowException;
import com.pingcap.tikv.exception.InvalidCodecFormatException;
import com.pingcap.tikv.exception.TypeException;
import com.pingcap.tikv.types.BytesType;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.DecimalType;
import com.pingcap.tikv.types.IntegerType;
import com.pingcap.tikv.types.JsonType;
import com.pingcap.tikv.types.RealType;
import com.pingcap.tikv.types.TimeType;
import gnu.trove.list.array.TIntArrayList;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalInstantException;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class Codec {
    public static final int NULL_FLAG = 0;
    public static final int BYTES_FLAG = 1;
    public static final int COMPACT_BYTES_FLAG = 2;
    public static final int INT_FLAG = 3;
    public static final int UINT_FLAG = 4;
    public static final int FLOATING_FLAG = 5;
    public static final int DECIMAL_FLAG = 6;
    public static final int DURATION_FLAG = 7;
    public static final int VARINT_FLAG = 8;
    public static final int UVARINT_FLAG = 9;
    public static final int JSON_FLAG = 10;
    public static final int MAX_FLAG = 250;
    public static final long SIGN_MASK = Long.MIN_VALUE;

    public static boolean isNullFlag(int flag) {
        return flag == 0;
    }

    public static Object decodeOne(byte[] colData) {
        DataType tp;
        if (colData.length <= 1) {
            throw new CodecException("invalid encoded column data, length <=1");
        }
        byte flag = colData[0];
        switch (flag) {
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                tp = IntegerType.BIGINT;
                break;
            }
            case 5: {
                tp = RealType.DOUBLE;
                break;
            }
            case 1: 
            case 2: {
                tp = BytesType.TEXT;
                break;
            }
            case 6: {
                tp = DecimalType.DECIMAL;
                break;
            }
            case 7: {
                tp = TimeType.TIME;
                break;
            }
            case 10: {
                tp = JsonType.JSON;
                break;
            }
            default: {
                throw new CodecException("Unknown type");
            }
        }
        return tp.decode(new CodecDataInput(colData));
    }

    public static class SetCodec {
        private static final long[] SET_INDEX_VALUE = SetCodec.initSetIndexVal();
        private static final long[] SET_INDEX_INVERT_VALUE = SetCodec.initSetIndexInvertVal();

        private static long[] initSetIndexInvertVal() {
            long[] tmpArr = new long[64];
            for (int i = 0; i < 64; ++i) {
                tmpArr[i] = SET_INDEX_VALUE[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return tmpArr;
        }

        private static long[] initSetIndexVal() {
            long[] tmpArr = new long[64];
            for (int i = 0; i < 64; ++i) {
                tmpArr[i] = 1L << i;
            }
            return tmpArr;
        }

        public static String readSetFromLong(long number, List<String> elems) {
            ArrayList<String> items = new ArrayList<String>();
            int length = elems.size();
            for (int i = 0; i < length; ++i) {
                long checker = number & SET_INDEX_VALUE[i];
                if (checker == 0L) continue;
                items.add(elems.get(i));
                number &= SET_INDEX_INVERT_VALUE[i];
            }
            if (number != 0L) {
                throw new TypeException(String.format("invalid number %d for Set %s", number, elems));
            }
            return String.join((CharSequence)",", items);
        }
    }

    public static class EnumCodec {
        public static boolean equals(String a, String b) {
            return a.trim().equalsIgnoreCase(b.trim());
        }

        public static Integer parseEnumName(String name, List<String> elems) throws ConvertOverflowException {
            int result;
            for (int i = 0; i < elems.size(); ++i) {
                if (!EnumCodec.equals(elems.get(i), name)) continue;
                return i + 1;
            }
            try {
                result = Integer.parseInt(name);
            }
            catch (Exception e) {
                throw ConvertOverflowException.newEnumException(name);
            }
            return EnumCodec.parseEnumValue(result, elems);
        }

        public static Integer parseEnumValue(Integer number, List<String> elems) throws ConvertOverflowException {
            if (number == 0) {
                throw ConvertOverflowException.newLowerBoundException(number, 0);
            }
            if (number > elems.size()) {
                throw ConvertOverflowException.newUpperBoundException(number, elems.size());
            }
            return number;
        }

        public static String readEnumFromIndex(int idx, List<String> elems) {
            if (idx < 0 || idx >= elems.size()) {
                throw new TypeException("Index is out of range");
            }
            return elems.get(idx);
        }
    }

    public static class DateCodec {
        static long toPackedLong(Date date, DateTimeZone tz) {
            return DateCodec.toPackedLong(date.getTime(), tz);
        }

        static long toPackedLong(long utcMillsTs, DateTimeZone tz) {
            LocalDate date = new LocalDate(utcMillsTs, tz);
            return DateCodec.toPackedLong(date);
        }

        static long toPackedLong(LocalDate date) {
            return DateCodec.toPackedLong(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
        }

        static long toPackedLong(int year, int month, int day) {
            long ymd = (long)year * 13L + (long)month << 5 | (long)day;
            return ymd << 41;
        }

        public static LocalDate fromPackedLong(long packed) {
            if (packed == 0L) {
                return null;
            }
            long ymd = packed >> 41;
            int day = (int)(ymd & 0x1FL);
            long ym = ymd >> 5;
            int month = (int)(ym % 13L);
            int year = (int)(ym / 13L);
            return new LocalDate(year, month, day, null);
        }

        public static void writeDateFully(CodecDataOutput cdo, Date date, DateTimeZone tz) {
            long val = DateCodec.toPackedLong(date, tz);
            IntegerCodec.writeULongFully(cdo, val, true);
        }

        public static void writeDateProto(CodecDataOutput cdo, Date date, DateTimeZone tz) {
            long val = DateCodec.toPackedLong(date, tz);
            IntegerCodec.writeULong(cdo, val);
        }

        public static LocalDate readFromUVarInt(CodecDataInput cdi) {
            return DateCodec.fromPackedLong(IntegerCodec.readUVarLong(cdi));
        }

        public static LocalDate readFromUInt(CodecDataInput cdi) {
            return DateCodec.fromPackedLong(IntegerCodec.readULong(cdi));
        }
    }

    public static class DateTimeCodec {
        public static long toPackedLong(ExtendedDateTime extendedDateTime, DateTimeZone tz) {
            DateTime dateTime = extendedDateTime.getDateTime();
            LocalDateTime localDateTime = dateTime.withZone(tz).toLocalDateTime();
            return DateTimeCodec.toPackedLong(localDateTime.getYear(), localDateTime.getMonthOfYear(), localDateTime.getDayOfMonth(), localDateTime.getHourOfDay(), localDateTime.getMinuteOfHour(), localDateTime.getSecondOfMinute(), extendedDateTime.getMicrosOfSeconds());
        }

        static long toPackedLong(int year, int month, int day, int hour, int minute, int second, int micro) {
            long ymd = (long)year * 13L + (long)month << 5 | (long)day;
            long hms = (long)hour << 12 | (long)minute << 6 | (long)second;
            return (ymd << 17 | hms) << 24 | (long)micro;
        }

        public static ExtendedDateTime fromPackedLong(long packed, DateTimeZone tz) {
            if (packed == 0L) {
                return null;
            }
            long ymdhms = packed >> 24;
            long ymd = ymdhms >> 17;
            int day = (int)(ymd & 0x1FL);
            long ym = ymd >> 5;
            int month = (int)(ym % 13L);
            int year = (int)(ym / 13L);
            int hms = (int)(ymdhms & 0x1FFFFL);
            int second = hms & 0x3F;
            int minute = hms >> 6 & 0x3F;
            int hour = hms >> 12;
            int microsec = (int)(packed % 0x1000000L);
            return DateTimeCodec.createExtendedDateTime(tz, year, month, day, hour, minute, second, microsec);
        }

        public static ExtendedDateTime createExtendedDateTime(DateTimeZone tz, int year, int month, int day, int hour, int minute, int second, int microsec) {
            try {
                DateTime dateTime = new DateTime(year, month, day, hour, minute, second, microsec / 1000, tz);
                return new ExtendedDateTime(dateTime, microsec % 1000);
            }
            catch (IllegalInstantException e) {
                LocalDateTime localDateTime = new LocalDateTime(year, month, day, hour, minute, second, microsec / 1000);
                DateTime dt = localDateTime.toLocalDate().toDateTimeAtStartOfDay(tz);
                long millis = dt.getMillis() + (long)localDateTime.toLocalTime().getMillisOfDay();
                DateTime dateTime = new DateTime(millis, tz);
                return new ExtendedDateTime(dateTime, microsec % 1000);
            }
        }

        public static void writeDateTimeFully(CodecDataOutput cdo, ExtendedDateTime extendeddateTime, DateTimeZone tz) {
            long val = DateTimeCodec.toPackedLong(extendeddateTime, tz);
            IntegerCodec.writeULongFully(cdo, val, true);
        }

        public static void writeDateTimeProto(CodecDataOutput cdo, ExtendedDateTime extendedDateTime, DateTimeZone tz) {
            long val = DateTimeCodec.toPackedLong(extendedDateTime, tz);
            IntegerCodec.writeULong(cdo, val);
        }

        public static ExtendedDateTime readFromUVarInt(CodecDataInput cdi, DateTimeZone tz) {
            return DateTimeCodec.fromPackedLong(IntegerCodec.readUVarLong(cdi), tz);
        }

        public static ExtendedDateTime readFromUInt(CodecDataInput cdi, DateTimeZone tz) {
            return DateTimeCodec.fromPackedLong(IntegerCodec.readULong(cdi), tz);
        }
    }

    public static class DecimalCodec {
        public static BigDecimal readDecimal(CodecDataInput cdi) {
            if (cdi.available() < 3) {
                throw new IllegalArgumentException("insufficient bytes to read value");
            }
            TIntArrayList data = new TIntArrayList(64);
            int precision = cdi.readUnsignedByte();
            int frac = cdi.readUnsignedByte();
            int length = precision + frac;
            int curPos = cdi.size() - cdi.available();
            for (int i = 0; i < length && !cdi.eof(); ++i) {
                data.add(cdi.readUnsignedByte());
            }
            MyDecimal dec = new MyDecimal();
            int binSize = dec.fromBin(precision, frac, data.toArray());
            cdi.mark(curPos + binSize);
            cdi.reset();
            return dec.toBigDecimal();
        }

        public static void writeDecimal(CodecDataOutput cdo, MyDecimal dec, int precision, int fraction) {
            int[] data = dec.toBin(precision, fraction);
            cdo.writeByte(precision);
            cdo.writeByte(fraction);
            for (int aData : data) {
                cdo.writeByte(aData & 0xFF);
            }
        }

        public static void writeDecimal(CodecDataOutput cdo, BigDecimal val) {
            MyDecimal dec = new MyDecimal();
            dec.fromString(val.toPlainString());
            int[] data = dec.toBin(dec.precision(), dec.frac());
            cdo.writeByte(dec.precision());
            cdo.writeByte(dec.frac());
            for (int aData : data) {
                cdo.writeByte(aData & 0xFF);
            }
        }

        public static void writeDecimalFully(CodecDataOutput cdo, MyDecimal val, int precision, int fraction) {
            cdo.writeByte(6);
            DecimalCodec.writeDecimal(cdo, val, precision, fraction);
        }
    }

    public static class RealCodec {
        public static double readDouble(CodecDataInput cdi) {
            long u = IntegerCodec.readULong(cdi);
            u = u < 0L ? (u &= Long.MAX_VALUE) : (u ^= 0xFFFFFFFFFFFFFFFFL);
            return Double.longBitsToDouble(u);
        }

        private static long encodeDoubleToCmpLong(double val) {
            long u = Double.doubleToRawLongBits(val);
            u = val >= 0.0 ? (u |= Long.MIN_VALUE) : (u ^= 0xFFFFFFFFFFFFFFFFL);
            return u;
        }

        public static void writeDoubleFully(CodecDataOutput cdo, double val) {
            cdo.writeByte(5);
            RealCodec.writeDouble(cdo, val);
        }

        public static void writeDouble(CodecDataOutput cdo, double val) {
            IntegerCodec.writeULong(cdo, RealCodec.encodeDoubleToCmpLong(val));
        }
    }

    public static class BytesCodec {
        private static final int GRP_SIZE = 8;
        private static final byte[] PADS = new byte[8];
        private static final int MARKER = 255;
        private static final byte PAD = 0;

        public static void writeBytesRaw(CodecDataOutput cdo, byte[] data) {
            cdo.write(data);
        }

        public static void writeBytesFully(CodecDataOutput cdo, byte[] data) {
            cdo.write(1);
            BytesCodec.writeBytes(cdo, data);
        }

        public static void writeBytes(CodecDataOutput cdo, byte[] data) {
            for (int i = 0; i <= data.length; i += 8) {
                int remain = data.length - i;
                int padCount = 0;
                if (remain >= 8) {
                    cdo.write(data, i, 8);
                } else {
                    padCount = 8 - remain;
                    cdo.write(data, i, data.length - i);
                    cdo.write(PADS, 0, padCount);
                }
                cdo.write((byte)(255 - padCount));
            }
        }

        public static void writeCompactBytesFully(CodecDataOutput cdo, byte[] data) {
            cdo.write(2);
            BytesCodec.writeCompactBytes(cdo, data);
        }

        static void writeCompactBytes(CodecDataOutput cdo, byte[] data) {
            int length = data.length;
            IntegerCodec.writeVarLong(cdo, length);
            cdo.write(data);
        }

        public static byte[] readBytes(CodecDataInput cdi) {
            return BytesCodec.readBytes(cdi, false);
        }

        public static byte[] readCompactBytes(CodecDataInput cdi) {
            int size = (int)IntegerCodec.readVarLong(cdi);
            return BytesCodec.readCompactBytes(cdi, size);
        }

        private static byte[] readCompactBytes(CodecDataInput cdi, int size) {
            byte[] data = new byte[size];
            for (int i = 0; i < size; ++i) {
                data[i] = cdi.readByte();
            }
            return data;
        }

        private static byte[] readBytes(CodecDataInput cdi, boolean reverse) {
            byte[] group;
            int padCount;
            CodecDataOutput cdo = new CodecDataOutput();
            do {
                byte[] groupBytes = new byte[9];
                cdi.readFully(groupBytes, 0, 9);
                group = Arrays.copyOfRange(groupBytes, 0, 8);
                int marker = Byte.toUnsignedInt(groupBytes[8]);
                padCount = reverse ? marker : 255 - marker;
                Preconditions.checkArgument(padCount <= 8);
                int realGroupSize = 8 - padCount;
                cdo.write(group, 0, realGroupSize);
            } while (padCount == 0);
            byte padByte = 0;
            if (reverse) {
                padByte = -1;
            }
            for (int i = realGroupSize; i < group.length; ++i) {
                byte b = group[i];
                Preconditions.checkArgument(padByte == b);
            }
            byte[] bytes = cdo.toBytes();
            if (reverse) {
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = ~bytes[i];
                }
            }
            return bytes;
        }
    }

    public static class IntegerCodec {
        private static long flipSignBit(long v) {
            return v ^ Long.MIN_VALUE;
        }

        public static void writeLongFully(CodecDataOutput cdo, long lVal, boolean comparable) {
            if (comparable) {
                cdo.writeByte(3);
                IntegerCodec.writeLong(cdo, lVal);
            } else {
                cdo.writeByte(8);
                IntegerCodec.writeVarLong(cdo, lVal);
            }
        }

        public static void writeULongFully(CodecDataOutput cdo, long lVal, boolean comparable) {
            if (comparable) {
                cdo.writeByte(4);
                IntegerCodec.writeULong(cdo, lVal);
            } else {
                cdo.writeByte(9);
                IntegerCodec.writeUVarLong(cdo, lVal);
            }
        }

        public static void writeDuration(CodecDataOutput cdo, long value) {
            cdo.writeByte(7);
            IntegerCodec.writeLong(cdo, value);
        }

        public static void writeLong(CodecDataOutput cdo, long lVal) {
            cdo.writeLong(IntegerCodec.flipSignBit(lVal));
        }

        public static void writeULong(CodecDataOutput cdo, long lVal) {
            cdo.writeLong(lVal);
        }

        static void writeVarLong(CodecDataOutput cdo, long value) {
            long ux = value << 1;
            if (value < 0L) {
                ux ^= 0xFFFFFFFFFFFFFFFFL;
            }
            IntegerCodec.writeUVarLong(cdo, ux);
        }

        static void writeUVarLong(CodecDataOutput cdo, long value) {
            while (Long.compareUnsigned(value, 128L) >= 0) {
                cdo.writeByte((byte)value | 0x80);
                value >>>= 7;
            }
            cdo.writeByte((byte)value);
        }

        public static long readLong(CodecDataInput cdi) {
            return IntegerCodec.flipSignBit(cdi.readLong());
        }

        public static long readULong(CodecDataInput cdi) {
            return cdi.readLong();
        }

        public static long readVarLong(CodecDataInput cdi) {
            long ux = IntegerCodec.readUVarLong(cdi);
            long x = ux >>> 1;
            if ((ux & 1L) != 0L) {
                x ^= 0xFFFFFFFFFFFFFFFFL;
            }
            return x;
        }

        public static long readUVarLong(CodecDataInput cdi) {
            long x = 0L;
            int s = 0;
            int i = 0;
            while (!cdi.eof()) {
                long b = cdi.readUnsignedByte();
                if (Long.compareUnsigned(b, 128L) < 0) {
                    if (i > 9 || i == 9 && b > 1L) {
                        throw new InvalidCodecFormatException("readUVarLong overflow");
                    }
                    return x | b << s;
                }
                x |= (b & 0x7FL) << s;
                s += 7;
                ++i;
            }
            throw new InvalidCodecFormatException("readUVarLong encountered unfinished data");
        }
    }
}

