/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.codec;

import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.key.Handle;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.row.ObjectRowImpl;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.IntegerType;
import java.util.HashMap;
import java.util.List;

public class TableCodecV1 {
    protected static byte[] encodeRow(List<TiColumnInfo> columnInfos, Object[] values, boolean isPkHandle) {
        CodecDataOutput cdo = new CodecDataOutput();
        for (int i = 0; i < columnInfos.size(); ++i) {
            TiColumnInfo col = columnInfos.get(i);
            if (col.isPrimaryKey() && isPkHandle) continue;
            Codec.IntegerCodec.writeLongFully(cdo, col.getId(), false);
            col.getType().encode(cdo, DataType.EncodeType.VALUE, values[i]);
        }
        if (cdo.toBytes().length == 0) {
            return new byte[]{0};
        }
        return cdo.toBytes();
    }

    protected static Row decodeRow(byte[] value, Handle handle, TiTableInfo tableInfo) {
        if (handle == null && tableInfo.isPkHandle()) {
            throw new IllegalArgumentException("when pk is handle, handle cannot be null");
        }
        int colSize = tableInfo.getColumns().size();
        HashMap<Long, TiColumnInfo> idToColumn = new HashMap<Long, TiColumnInfo>(colSize);
        for (TiColumnInfo col : tableInfo.getColumns()) {
            idToColumn.put(col.getId(), col);
        }
        HashMap<Long, Object> decodedDataMap = new HashMap<Long, Object>(colSize);
        CodecDataInput cdi = new CodecDataInput(value);
        Object[] res = new Object[colSize];
        while (!cdi.eof()) {
            long colID = (Long)IntegerType.BIGINT.decode(cdi);
            Object colValue = ((TiColumnInfo)idToColumn.get(colID)).getType().decodeForBatchWrite(cdi);
            decodedDataMap.put(colID, colValue);
        }
        for (int i = 0; i < colSize; ++i) {
            TiColumnInfo col = tableInfo.getColumn(i);
            res[i] = col.isPrimaryKey() && tableInfo.isPkHandle() ? handle : decodedDataMap.get(col.getId());
        }
        return ObjectRowImpl.create(res);
    }
}

