/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.com.google.common.primitives.UnsignedLong;
import com.pingcap.tikv.exception.TiExpressionException;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.Visitor;
import com.pingcap.tikv.types.BytesType;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.DateTimeType;
import com.pingcap.tikv.types.DateType;
import com.pingcap.tikv.types.DecimalType;
import com.pingcap.tikv.types.IntegerType;
import com.pingcap.tikv.types.RealType;
import com.pingcap.tikv.types.StringType;
import com.pingcap.tikv.types.TimestampType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

public class Constant
extends Expression {
    private final Object value;
    private final BigDecimal UNSIGNED_LONG_MAX = new BigDecimal(UnsignedLong.fromLongBits(-1L).toString());

    public Constant(Object value, DataType type) {
        this.value = value;
        this.dataType = type == null && value != null ? Constant.getDefaultType(value) : type;
        this.resolved = true;
    }

    public static Constant create(Object value, DataType type) {
        return new Constant(value, type);
    }

    @Deprecated
    public static Constant create(Object value) {
        return new Constant(value, null);
    }

    protected static boolean isIntegerType(Object value) {
        return value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte;
    }

    private static DataType getDefaultType(Object value) {
        if (value == null) {
            throw new TiExpressionException("NULL constant has no type");
        }
        if (Constant.isIntegerType(value)) {
            return IntegerType.BIGINT;
        }
        if (value instanceof String) {
            return StringType.VARCHAR;
        }
        if (value instanceof Float) {
            return RealType.FLOAT;
        }
        if (value instanceof Double) {
            return RealType.DOUBLE;
        }
        if (value instanceof BigDecimal) {
            int prec = ((BigDecimal)value).precision();
            int frac = ((BigDecimal)value).scale();
            return new DecimalType(prec, frac);
        }
        if (value instanceof DateTime) {
            return DateTimeType.DATETIME;
        }
        if (value instanceof Date) {
            return DateType.DATE;
        }
        if (value instanceof Timestamp) {
            return TimestampType.TIMESTAMP;
        }
        if (value instanceof byte[]) {
            return BytesType.TEXT;
        }
        throw new TiExpressionException("Constant type not supported:" + value.getClass().getSimpleName());
    }

    public void setType(DataType type) {
        this.dataType = type;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof String) {
            return String.format("\"%s\"", this.value);
        }
        return this.value.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof Constant) {
            return Objects.equals(this.value, ((Constant)other).value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public boolean isOverflowed() {
        if (this.dataType instanceof IntegerType && ((IntegerType)this.dataType).isUnsignedLong()) {
            return ((BigDecimal)this.value).subtract(this.UNSIGNED_LONG_MAX).signum() > 0 || ((BigDecimal)this.value).signum() < 0;
        }
        return false;
    }
}

