/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.tikv.expression.Constant;
import com.pingcap.tikv.expression.FuncCallExpr;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.DateTimeType;
import com.pingcap.tikv.types.DateType;
import com.pingcap.tikv.types.IntegerType;
import com.pingcap.tikv.types.StringType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.joda.time.DateTime;

public class FuncCallExprEval {
    private static final Map<FuncCallExpr.Type, Function<Constant, Constant>> evalMap = new HashMap<FuncCallExpr.Type, Function<Constant, Constant>>();

    static Function<Constant, Constant> getEvalFn(FuncCallExpr.Type tp) {
        if (evalMap.containsKey((Object)tp)) {
            return evalMap.get((Object)tp);
        }
        return null;
    }

    static {
        evalMap.put(FuncCallExpr.Type.YEAR, literal -> {
            DataType type = literal.getDataType();
            if (type instanceof StringType) {
                DateTime date = DateTime.parse((String)literal.getValue());
                return Constant.create(date.getYear(), IntegerType.INT);
            }
            if (type instanceof DateType) {
                DateTime date = new DateTime(literal.getValue());
                return Constant.create(date.getYear(), IntegerType.INT);
            }
            if (type instanceof DateTimeType) {
                DateTime date = (DateTime)literal.getValue();
                return Constant.create(date.getYear(), IntegerType.INT);
            }
            throw new UnsupportedOperationException(String.format("cannot apply year on %s", type.getName()));
        });
    }
}

