/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.com.google.common.collect.ImmutableSet;
import com.pingcap.com.google.common.collect.RangeSet;
import com.pingcap.com.google.common.collect.TreeRangeSet;
import com.pingcap.tikv.expression.ComparisonBinaryExpression;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.LogicalBinaryExpression;
import com.pingcap.tikv.expression.PartitionPruner;
import com.pingcap.tikv.expression.visitor.DefaultVisitor;
import com.pingcap.tikv.expression.visitor.PrunedPartitionBuilder;
import com.pingcap.tikv.meta.TiPartitionDef;
import com.pingcap.tikv.meta.TiPartitionInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.parser.TiParser;
import com.pingcap.tikv.predicates.PredicateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RangeColumnPartitionPruner
extends DefaultVisitor<Set<Integer>, LogicalBinaryExpression> {
    private final int partsSize;
    private final TiPartitionInfo partInfo;
    private final Map<String, List<Expression>> partExprsPerColumnRef = new HashMap<String, List<Expression>>();

    RangeColumnPartitionPruner(TiTableInfo tableInfo) {
        this.partInfo = tableInfo.getPartitionInfo();
        TiParser parser = new TiParser(tableInfo);
        for (int i = 0; i < this.partInfo.getColumns().size(); ++i) {
            ArrayList<Expression> partExprs = new ArrayList<Expression>();
            String colRefName = this.partInfo.getColumns().get(i);
            PartitionPruner.generateRangeExprs(this.partInfo, partExprs, parser, colRefName, i);
            this.partExprsPerColumnRef.put(colRefName, partExprs);
        }
        this.partsSize = tableInfo.getPartitionInfo().getDefs().size();
    }

    @Override
    protected Set<Integer> visit(LogicalBinaryExpression node, LogicalBinaryExpression parent) {
        Expression left = node.getLeft();
        Expression right = node.getRight();
        Set<Integer> partsIsCoveredByLeft = left.accept(this, node);
        Set<Integer> partsIsCoveredByRight = right.accept(this, node);
        switch (node.getCompType()) {
            case OR: {
                partsIsCoveredByLeft.addAll(partsIsCoveredByRight);
                return partsIsCoveredByLeft;
            }
            case AND: {
                HashSet<Integer> partsIsCoveredByBoth = new HashSet<Integer>();
                for (int i = 0; i < this.partsSize; ++i) {
                    if (!partsIsCoveredByLeft.contains(i) || !partsIsCoveredByRight.contains(i)) continue;
                    partsIsCoveredByBoth.add(i);
                }
                return partsIsCoveredByBoth;
            }
        }
        throw new UnsupportedOperationException("cannot access here");
    }

    @Override
    protected Set<Integer> visit(ComparisonBinaryExpression node, LogicalBinaryExpression parent) {
        ComparisonBinaryExpression.NormalizedPredicate predicate = node.normalize();
        if (predicate == null) {
            throw new UnsupportedOperationException(String.format("ComparisonBinaryExpression %s cannot be normalized", node));
        }
        String colRefName = predicate.getColumnRef().getName();
        List<Expression> partExprs = this.partExprsPerColumnRef.get(colRefName);
        HashSet<Integer> partDefs = new HashSet<Integer>();
        if (partExprs == null) {
            for (int i = 0; i < this.partsSize; ++i) {
                partDefs.add(i);
            }
            return partDefs;
        }
        for (int i = 0; i < this.partsSize; ++i) {
            PrunedPartitionBuilder rangeBuilder = new PrunedPartitionBuilder(ImmutableSet.of(predicate.getColumnRef()));
            RangeSet partExprRange = rangeBuilder.buildRange(partExprs.get(i));
            RangeSet filterRange = rangeBuilder.buildRange(node);
            TreeRangeSet copy = TreeRangeSet.create(partExprRange);
            copy.removeAll(filterRange.complement());
            if (copy.isEmpty()) continue;
            partDefs.add(i);
        }
        return partDefs;
    }

    public List<TiPartitionDef> prune(List<Expression> filters) {
        Expression cnfExpr = PredicateUtils.mergeCNFExpressions(filters = PartitionPruner.extractLogicalOrComparisonExpr(filters));
        if (cnfExpr == null) {
            return this.partInfo.getDefs();
        }
        Set<Integer> partsIdx = cnfExpr.accept(this, null);
        ArrayList<TiPartitionDef> pDefs = new ArrayList<TiPartitionDef>();
        for (int i = 0; i < this.partsSize; ++i) {
            if (!partsIdx.contains(i)) continue;
            pDefs.add(this.partInfo.getDefs().get(i));
        }
        return pDefs;
    }
}

