/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression.visitor;

import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.ComparisonBinaryExpression;
import com.pingcap.tikv.expression.Constant;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.FuncCallExpr;
import com.pingcap.tikv.expression.LogicalBinaryExpression;
import com.pingcap.tikv.expression.visitor.DefaultVisitor;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.partition.PartitionedTable;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.types.DateType;
import com.pingcap.tikv.types.IntegerType;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;

public class RangePartitionLocator
extends DefaultVisitor<Boolean, PartitionedTable.PartitionLocatorContext> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean visit(ComparisonBinaryExpression node, PartitionedTable.PartitionLocatorContext context) {
        Object data;
        Row row = context.getRow();
        TiTableInfo tableInfo = context.getTableInfo();
        Expression left = node.getLeft();
        if (left instanceof ColumnRef) {
            ColumnRef columnRef = (ColumnRef)left;
            columnRef.resolve(tableInfo);
            data = row.get(columnRef.getColumnOffset(), columnRef.getDataType());
        } else {
            if (!(left instanceof FuncCallExpr)) throw new UnsupportedOperationException(String.format("Unsupported expr in range partition %s", left));
            FuncCallExpr partitionFuncExpr = (FuncCallExpr)left;
            if (partitionFuncExpr.getFuncTp() != FuncCallExpr.Type.YEAR) throw new UnsupportedOperationException("Partition write only support YEAR() function");
            Expression expression = left.getChildren().get(0);
            ColumnRef columnRef = (ColumnRef)expression;
            columnRef.resolve(tableInfo);
            data = partitionFuncExpr.eval(Constant.create(row.get(columnRef.getColumnOffset(), DateType.DATE))).getValue();
        }
        if (!(node.getRight() instanceof Constant)) {
            throw new UnsupportedOperationException(String.format("Unsupported right node in partition range expressions %s", node));
        }
        Constant constant = (Constant)node.getRight();
        String boundString = constant.getValue().toString();
        if ((data instanceof String || data instanceof Date || data instanceof Timestamp) && boundString.startsWith("'") && boundString.endsWith("'")) {
            boundString = boundString.substring(1, boundString.length() - 1);
        }
        ComparisonBinaryExpression.Operator comparisonType = node.getComparisonType();
        return this.evaluateComparison(data, boundString, comparisonType);
    }

    Boolean evaluateComparison(Object data, String boundString, ComparisonBinaryExpression.Operator comparisonType) {
        if (data instanceof Number) {
            long dataLongValue = ((Number)data).longValue();
            long bound = Long.parseLong(boundString);
            switch (comparisonType) {
                case GREATER_EQUAL: {
                    return dataLongValue >= bound;
                }
                case LESS_THAN: {
                    return dataLongValue < bound;
                }
            }
            throw new UnsupportedOperationException("Unsupported comparison type: " + (Object)((Object)comparisonType));
        }
        if (data instanceof String) {
            String dataStringValue = (String)data;
            switch (comparisonType) {
                case GREATER_EQUAL: {
                    return dataStringValue.compareTo(boundString) >= 0;
                }
                case LESS_THAN: {
                    return dataStringValue.compareTo(boundString) < 0;
                }
            }
            throw new UnsupportedOperationException("Unsupported comparison type: " + (Object)((Object)comparisonType));
        }
        if (data instanceof byte[]) {
            String dataStringValue = new String((byte[])data, StandardCharsets.UTF_8);
            switch (comparisonType) {
                case GREATER_EQUAL: {
                    return dataStringValue.compareTo(boundString) >= 0;
                }
                case LESS_THAN: {
                    return dataStringValue.compareTo(boundString) < 0;
                }
            }
            throw new UnsupportedOperationException("Unsupported comparison type: " + (Object)((Object)comparisonType));
        }
        if (data instanceof Date) {
            Date dataDateValue = (Date)data;
            Date boundDate = Date.valueOf(boundString);
            switch (comparisonType) {
                case GREATER_EQUAL: {
                    return dataDateValue.compareTo(boundDate) >= 0;
                }
                case LESS_THAN: {
                    return dataDateValue.compareTo(boundDate) < 0;
                }
            }
            throw new UnsupportedOperationException("Unsupported comparison type: " + (Object)((Object)comparisonType));
        }
        if (data instanceof Timestamp) {
            Timestamp dataTimeValue = (Timestamp)data;
            Timestamp boundDateTime = Timestamp.valueOf(boundString);
            switch (comparisonType) {
                case GREATER_EQUAL: {
                    return dataTimeValue.compareTo(boundDateTime) >= 0;
                }
                case LESS_THAN: {
                    return dataTimeValue.compareTo(boundDateTime) < 0;
                }
            }
            throw new UnsupportedOperationException("Unsupported comparison type: " + (Object)((Object)comparisonType));
        }
        throw new UnsupportedOperationException("Unsupported data type with partition column" + data.getClass());
    }

    @Override
    public Boolean visit(Constant node, PartitionedTable.PartitionLocatorContext context) {
        if (IntegerType.TINYINT.equals(node.getDataType())) {
            return (Integer)node.getValue() == 1;
        }
        throw new IllegalStateException(String.format("Unsupported constant, type: %s, value: %s\n", node.getDataType(), node.getValue()));
    }

    @Override
    public Boolean visit(LogicalBinaryExpression node, PartitionedTable.PartitionLocatorContext context) {
        Expression left = node.getLeft();
        Expression right = node.getRight();
        if (node.getCompType() == LogicalBinaryExpression.Type.AND) {
            return left.accept(this, context) != false && right.accept(this, context) != false;
        }
        throw new UnsupportedOperationException("Unsupported logical binary expression: " + node);
    }
}

