/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression.visitor;

import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.ExpressionBlocklist;
import com.pingcap.tikv.expression.visitor.DefaultVisitor;
import com.pingcap.tikv.expression.visitor.ProtoConverter;

public class SupportedExpressionValidator
extends DefaultVisitor<Boolean, ExpressionBlocklist> {
    private static final SupportedExpressionValidator validator = new SupportedExpressionValidator();

    public static boolean isSupportedExpression(Expression node, ExpressionBlocklist blocklist) {
        if (!node.accept(validator, blocklist).booleanValue()) {
            return false;
        }
        try {
            ProtoConverter protoConverter = new ProtoConverter(false);
            if (node.accept(protoConverter, null) == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected Boolean process(Expression node, ExpressionBlocklist blocklist) {
        if (blocklist != null && blocklist.isUnsupportedPushDownExpr(this.getClass())) {
            return false;
        }
        for (Expression expr : node.getChildren()) {
            if (expr.accept(this, blocklist).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

