/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.operation;

import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.event.CacheInvalidateEvent;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.KeyException;
import com.pingcap.tikv.operation.ErrorHandler;
import com.pingcap.tikv.region.RegionErrorReceiver;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.txn.AbstractLockResolverClient;
import com.pingcap.tikv.txn.Lock;
import com.pingcap.tikv.txn.ResolveLockResult;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Errorpb;
import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;
import shade.io.grpc.Status;
import shade.io.grpc.StatusRuntimeException;

public class KVErrorHandler<RespT>
implements ErrorHandler<RespT> {
    private static final Logger logger = LoggerFactory.getLogger(KVErrorHandler.class);
    private static final int NO_LEADER_STORE_ID = 0;
    private final Function<RespT, Errorpb.Error> getRegionError;
    private final Function<RespT, Kvrpcpb.KeyError> getKeyError;
    private final Function<CacheInvalidateEvent, Void> cacheInvalidateCallBack;
    private final Function<ResolveLockResult, Object> resolveLockResultCallback;
    private final RegionManager regionManager;
    private final RegionErrorReceiver recv;
    private final AbstractLockResolverClient lockResolverClient;
    private final long callerStartTS;
    private final boolean forWrite;

    public KVErrorHandler(RegionManager regionManager, RegionErrorReceiver recv, AbstractLockResolverClient lockResolverClient, Function<RespT, Errorpb.Error> getRegionError, Function<RespT, Kvrpcpb.KeyError> getKeyError, Function<ResolveLockResult, Object> resolveLockResultCallback, long callerStartTS, boolean forWrite) {
        this.recv = recv;
        this.lockResolverClient = lockResolverClient;
        this.regionManager = regionManager;
        this.getRegionError = getRegionError;
        this.getKeyError = getKeyError;
        this.cacheInvalidateCallBack = regionManager != null ? regionManager.getCacheInvalidateCallback() : null;
        this.resolveLockResultCallback = resolveLockResultCallback;
        this.callerStartTS = callerStartTS;
        this.forWrite = forWrite;
    }

    public KVErrorHandler(RegionManager regionManager, RegionErrorReceiver recv, Function<RespT, Errorpb.Error> getRegionError) {
        this.recv = recv;
        this.lockResolverClient = null;
        this.regionManager = regionManager;
        this.getRegionError = getRegionError;
        this.getKeyError = resp -> null;
        this.cacheInvalidateCallBack = regionManager != null ? regionManager.getCacheInvalidateCallback() : null;
        this.resolveLockResultCallback = resolveLock -> null;
        this.callerStartTS = 0L;
        this.forWrite = false;
    }

    private Errorpb.Error getRegionError(RespT resp) {
        if (this.getRegionError != null) {
            return this.getRegionError.apply(resp);
        }
        return null;
    }

    private void invalidateRegionStoreCache(TiRegion region) {
        this.regionManager.invalidateRegion(region);
        this.regionManager.invalidateStore(region.getLeader().getStoreId());
        this.notifyRegionStoreCacheInvalidate(region, CacheInvalidateEvent.CacheType.REGION_STORE);
    }

    private void notifyRegionStoreCacheInvalidate(TiRegion region, CacheInvalidateEvent.CacheType type) {
        if (this.cacheInvalidateCallBack != null) {
            this.cacheInvalidateCallBack.apply(new CacheInvalidateEvent(region, true, true, type));
            logger.info("Accumulating cache invalidation info to driver:regionId=" + region.getId() + ",storeId=" + region.getLeader().getStoreId() + ",type=" + type.name());
        } else {
            logger.warn("Failed to send notification back to driver since CacheInvalidateCallBack is null in executor node.");
        }
    }

    private void notifyRegionCacheInvalidate(TiRegion region) {
        if (this.cacheInvalidateCallBack != null) {
            this.cacheInvalidateCallBack.apply(new CacheInvalidateEvent(region, true, false, CacheInvalidateEvent.CacheType.REGION_STORE));
            logger.info("Accumulating cache invalidation info to driver:regionId=" + region.getId() + ",type=" + CacheInvalidateEvent.CacheType.REGION_STORE.name());
        } else {
            logger.warn("Failed to send notification back to driver since CacheInvalidateCallBack is null in executor node.");
        }
    }

    private void resolveLocks(BackOffer backOffer, List<Lock> locks) {
        if (this.lockResolverClient != null) {
            logger.warn("resolving " + locks.size() + " locks");
            this.resolveLock(backOffer, locks.get(0));
        }
    }

    private void resolveLock(BackOffer backOffer, Lock lock) {
        if (this.lockResolverClient != null) {
            logger.warn("resolving lock");
            ResolveLockResult resolveLockResult = this.lockResolverClient.resolveLocks(backOffer, this.callerStartTS, Collections.singletonList(lock), this.forWrite);
            this.resolveLockResultCallback.apply(resolveLockResult);
            long msBeforeExpired = resolveLockResult.getMsBeforeTxnExpired();
            if (msBeforeExpired > 0L) {
                backOffer.doBackOffWithMaxSleep(BackOffFunction.BackOffFuncType.BoTxnLockFast, msBeforeExpired, new KeyException(lock.toString()));
            }
        }
    }

    @Override
    public boolean handleResponseError(BackOffer backOffer, RespT resp) {
        if (resp == null) {
            String msg = String.format("Request Failed with unknown reason for region region [%s]", this.recv.getRegion());
            logger.warn(msg);
            return this.handleRequestError(backOffer, new GrpcException(msg));
        }
        Errorpb.Error error = this.getRegionError(resp);
        if (error != null) {
            if (error.hasNotLeader()) {
                BackOffFunction.BackOffFuncType backOffFuncType;
                boolean retry;
                long newStoreId = error.getNotLeader().getLeader().getStoreId();
                logger.warn(String.format("NotLeader Error with region id %d and store id %d, new store id %d", this.recv.getRegion().getId(), this.recv.getRegion().getLeader().getStoreId(), newStoreId));
                if (newStoreId != 0L) {
                    TiRegion newRegion = this.regionManager.updateLeader(this.recv.getRegion(), newStoreId);
                    boolean bl = retry = newRegion != null && this.recv.onNotLeader(this.regionManager.getStoreById(newStoreId), newRegion);
                    if (!retry) {
                        this.notifyRegionStoreCacheInvalidate(this.recv.getRegion(), CacheInvalidateEvent.CacheType.LEADER);
                    }
                    backOffFuncType = BackOffFunction.BackOffFuncType.BoUpdateLeader;
                } else {
                    logger.info(String.format("Received zero store id, from region %d try next time", this.recv.getRegion().getId()));
                    backOffFuncType = BackOffFunction.BackOffFuncType.BoRegionMiss;
                    retry = false;
                }
                if (!retry) {
                    this.regionManager.invalidateRegion(this.recv.getRegion());
                }
                backOffer.doBackOff(backOffFuncType, new GrpcException(error.toString()));
                return retry;
            }
            if (error.hasStoreNotMatch()) {
                long storeId = this.recv.getRegion().getLeader().getStoreId();
                long actualStoreId = error.getStoreNotMatch().getActualStoreId();
                logger.warn(String.format("Store Not Match happened with region id %d, store id %d, actual store id %d", this.recv.getRegion().getId(), storeId, actualStoreId));
                this.invalidateRegionStoreCache(this.recv.getRegion());
                this.recv.onStoreNotMatch(this.regionManager.getStoreById(storeId));
                return false;
            }
            if (error.hasEpochNotMatch()) {
                logger.warn(String.format("Stale Epoch encountered for region [%s]", this.recv.getRegion()));
                this.regionManager.onRegionStale(this.recv.getRegion());
                this.notifyRegionCacheInvalidate(this.recv.getRegion());
                return false;
            }
            if (error.hasServerIsBusy()) {
                logger.warn(String.format("Server is busy for region [%s], reason: %s", this.recv.getRegion(), error.getServerIsBusy().getReason()));
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoServerBusy, new StatusRuntimeException(Status.fromCode(Status.Code.UNAVAILABLE).withDescription(error.toString())));
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException(error.getMessage()));
                return true;
            }
            if (error.hasRegionNotFound()) {
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException(error.getMessage()));
                this.regionManager.onRegionStale(this.recv.getRegion());
                this.notifyRegionCacheInvalidate(this.recv.getRegion());
                return false;
            }
            if (error.hasStaleCommand()) {
                logger.warn(String.format("Stale command for region [%s]", this.recv.getRegion()));
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException(error.getMessage()));
                return true;
            }
            if (error.hasRaftEntryTooLarge()) {
                logger.warn(String.format("Raft too large for region [%s]", this.recv.getRegion()));
                throw new StatusRuntimeException(Status.fromCode(Status.Code.UNAVAILABLE).withDescription(error.toString()));
            }
            if (error.hasKeyNotInRegion()) {
                ByteString invalidKey = error.getKeyNotInRegion().getKey();
                logger.error(String.format("Key not in region [%s] for key [%s], this error should not happen here.", this.recv.getRegion(), KeyUtils.formatBytesUTF8(invalidKey)));
                throw new StatusRuntimeException(Status.UNKNOWN.withDescription(error.toString()));
            }
            logger.warn(String.format("Unknown error %s for region [%s]", error, this.recv.getRegion()));
            this.invalidateRegionStoreCache(this.recv.getRegion());
            if (error.getMessage().contains("Raft ProposalDropped") || error.getMessage().contains("is missing")) {
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException(error.getMessage()));
                return true;
            }
        }
        boolean retry = false;
        if (resp instanceof Kvrpcpb.ScanResponse) {
            List<Kvrpcpb.KvPair> kvPairs = ((Kvrpcpb.ScanResponse)resp).getPairsList();
            ArrayList<Lock> locks = new ArrayList<Lock>();
            for (Kvrpcpb.KvPair kvPair : kvPairs) {
                if (!kvPair.hasError()) continue;
                Lock lock = AbstractLockResolverClient.extractLockFromKeyErr(kvPair.getError());
                locks.add(lock);
            }
            if (!locks.isEmpty()) {
                try {
                    this.resolveLocks(backOffer, locks);
                    retry = true;
                }
                catch (KeyException e) {
                    logger.warn("Unable to handle KeyExceptions other than LockException", (Throwable)e);
                }
            }
        } else {
            Kvrpcpb.KeyError keyError = this.getKeyError.apply(resp);
            if (keyError != null) {
                try {
                    Lock lock = AbstractLockResolverClient.extractLockFromKeyErr(keyError);
                    this.resolveLock(backOffer, lock);
                    retry = true;
                }
                catch (KeyException e) {
                    logger.warn("Unable to handle KeyExceptions other than LockException", (Throwable)e);
                }
            }
        }
        return retry;
    }

    @Override
    public boolean handleRequestError(BackOffer backOffer, Exception e) {
        this.regionManager.onRequestFail(this.recv.getRegion());
        this.notifyRegionStoreCacheInvalidate(this.recv.getRegion(), CacheInvalidateEvent.CacheType.REQ_FAILED);
        backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoTiKVRPC, new GrpcException("send tikv request error: " + e.getMessage() + ", try next peer later", e));
        return false;
    }
}

