/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.operation;

import com.pingcap.tikv.PDClient;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.operation.ErrorHandler;
import com.pingcap.tikv.pd.PDError;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Pdpb;

public class PDErrorHandler<RespT>
implements ErrorHandler<RespT> {
    public static final Function<Pdpb.GetRegionResponse, PDError> getRegionResponseErrorExtractor = r -> r.getHeader().hasError() ? PDError.buildFromPdpbError(r.getHeader().getError()) : (r.getRegion().getId() == 0L ? PDError.RegionPeerNotElected.DEFAULT_INSTANCE : null);
    private static final Logger logger = LoggerFactory.getLogger(PDErrorHandler.class);
    private final Function<RespT, PDError> getError;
    private final PDClient client;

    public PDErrorHandler(Function<RespT, PDError> errorExtractor, PDClient client) {
        this.getError = errorExtractor;
        this.client = client;
    }

    @Override
    public boolean handleResponseError(BackOffer backOffer, RespT resp) {
        if (resp == null) {
            return false;
        }
        PDError error = this.getError.apply(resp);
        if (error != null) {
            switch (error.getErrorType()) {
                case PD_ERROR: {
                    backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoPDRPC, new GrpcException(error.toString()));
                    this.client.updateLeaderOrForwardFollower();
                    return true;
                }
                case REGION_PEER_NOT_ELECTED: {
                    logger.debug(error.getMessage());
                    backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoPDRPC, new GrpcException(error.toString()));
                    return true;
                }
            }
            throw new TiClientInternalException("Unknown error type encountered: " + error);
        }
        return false;
    }

    @Override
    public boolean handleRequestError(BackOffer backOffer, Exception e) {
        this.client.updateLeaderOrForwardFollower();
        backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoPDRPC, e);
        return true;
    }
}

