/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.operation.iterator;

import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.KeyException;
import com.pingcap.tikv.exception.TiKVException;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.operation.iterator.ScanIterator;
import com.pingcap.tikv.region.RegionStoreClient;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.ConcreteBackOffer;
import com.pingcap.tikv.util.Pair;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.Metapb;
import shade.com.google.protobuf.ByteString;

public class ConcreteScanIterator
extends ScanIterator {
    private final long version;
    private final Logger logger = LoggerFactory.getLogger(ConcreteScanIterator.class);

    public ConcreteScanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, ByteString endKey, long version) {
        super(conf, builder, startKey, endKey, Integer.MAX_VALUE);
        this.version = version;
    }

    @Override
    TiRegion loadCurrentRegionToCache() throws GrpcException {
        TiRegion region;
        Throwable throwable;
        RegionStoreClient client;
        ConcreteBackOffer backOffer = ConcreteBackOffer.newScannerNextMaxBackOff();
        while (true) {
            client = this.builder.build(this.startKey);
            throwable = null;
            region = client.getRegion();
            if (this.limit <= 0) {
                this.currentCache = null;
                break;
            }
            try {
                int scanSize = Math.min(this.limit, this.conf.getScanBatchSize());
                this.currentCache = client.scan(backOffer, this.startKey, scanSize, this.version);
                region = client.getRegion();
            }
            catch (TiKVException e) {
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                client.close();
                continue;
            }
            break;
        }
        try {
            TiRegion tiRegion = region;
            return tiRegion;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (client != null) {
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteString resolveCurrentLock(Kvrpcpb.KvPair current) {
        this.logger.warn(String.format("resolve current key error %s", current.getError().toString()));
        Pair<TiRegion, Metapb.Store> pair = this.builder.getRegionManager().getRegionStorePairByKey(current.getKey());
        TiRegion region = (TiRegion)pair.first;
        Metapb.Store store = (Metapb.Store)pair.second;
        ConcreteBackOffer backOffer = ConcreteBackOffer.newGetBackOff();
        try (RegionStoreClient client = this.builder.build(region, store);){
            ByteString byteString = client.get(backOffer, current.getKey(), this.version);
            return byteString;
        }
        catch (Exception e) {
            throw new KeyException(current.getError());
        }
    }

    private boolean isCacheDrained() {
        return this.currentCache == null || this.limit <= 0 || this.index >= this.currentCache.size() || this.index == -1;
    }

    private boolean notEndOfScan() {
        return this.limit > 0 && (!this.processingLastBatch || this.index < this.currentCache.size() && Key.toRawKey(((Kvrpcpb.KvPair)this.currentCache.get(this.index)).getKey()).compareTo(this.endKey) < 0);
    }

    @Override
    public boolean hasNext() {
        if (this.isCacheDrained() && this.cacheLoadFails()) {
            this.endOfScan = true;
            return false;
        }
        while (this.currentCache != null && this.currentCache.isEmpty()) {
            if (!this.isCacheDrained() || !this.cacheLoadFails()) continue;
            return false;
        }
        return this.notEndOfScan();
    }

    private Kvrpcpb.KvPair getCurrent() {
        --this.limit;
        Kvrpcpb.KvPair current = (Kvrpcpb.KvPair)this.currentCache.get(this.index++);
        Objects.requireNonNull(current, "current kv pair cannot be null");
        if (current.hasError()) {
            ByteString val = this.resolveCurrentLock(current);
            current = Kvrpcpb.KvPair.newBuilder().setKey(current.getKey()).setValue(val).build();
        }
        return current;
    }

    @Override
    public Kvrpcpb.KvPair next() {
        return this.getCurrent();
    }
}

