/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.operation.iterator;

import com.pingcap.tidb.tipb.Chunk;
import com.pingcap.tidb.tipb.DAGRequest;
import com.pingcap.tidb.tipb.EncodeType;
import com.pingcap.tikv.TiSession;
import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.columnar.BatchedTiChunkColumnVector;
import com.pingcap.tikv.columnar.TiChunk;
import com.pingcap.tikv.columnar.TiChunkColumnVector;
import com.pingcap.tikv.columnar.TiColumnVector;
import com.pingcap.tikv.columnar.TiRowColumnVector;
import com.pingcap.tikv.columnar.datatypes.CHType;
import com.pingcap.tikv.key.CommonHandle;
import com.pingcap.tikv.key.Handle;
import com.pingcap.tikv.key.IntHandle;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.operation.SchemaInfer;
import com.pingcap.tikv.operation.iterator.DAGIterator;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.row.RowReader;
import com.pingcap.tikv.row.RowReaderFactory;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.IntegerType;
import com.pingcap.tikv.util.CHTypeMapping;
import com.pingcap.tikv.util.RangeSplitter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class CoprocessorIterator<T>
implements Iterator<T> {
    protected final TiSession session;
    protected final List<RangeSplitter.RegionTask> regionTasks;
    protected final DAGRequest dagRequest;
    protected final DataType[] handleTypes;
    protected RowReader rowReader;
    protected CodecDataInput dataInput;
    protected boolean eof = false;
    protected int taskIndex;
    protected int chunkIndex;
    protected List<Chunk> chunkList;
    protected SchemaInfer schemaInfer;

    CoprocessorIterator(DAGRequest req, List<RangeSplitter.RegionTask> regionTasks, TiSession session, SchemaInfer infer) {
        this.dagRequest = req;
        this.session = session;
        this.regionTasks = regionTasks;
        this.schemaInfer = infer;
        this.handleTypes = infer.getTypes().toArray(new DataType[0]);
    }

    public static CoprocessorIterator<Row> getRowIterator(TiDAGRequest req, List<RangeSplitter.RegionTask> regionTasks, TiSession session) {
        TiDAGRequest dagRequest = req.copy();
        dagRequest.setEncodeType(EncodeType.TypeDefault);
        DAGRequest request = dagRequest.hasIndex() ? dagRequest.buildDAGGetIndexData() : dagRequest.buildDAGGetTableData();
        return new DAGIterator<Row>(request, regionTasks, session, SchemaInfer.create(dagRequest.getResultTypes()), dagRequest.getPushDownType(), dagRequest.getStoreType(), dagRequest.getStartTs().getVersion()){

            @Override
            public Row next() {
                return this.rowReader.readRow(this.schemaInfer.getTypes().toArray(new DataType[0]));
            }
        };
    }

    public static CoprocessorIterator<TiChunk> getTiChunkIterator(TiDAGRequest req, List<RangeSplitter.RegionTask> regionTasks, TiSession session, final int numOfRows) {
        TiDAGRequest dagRequest = req.copy();
        DAGRequest request = !dagRequest.isDoubleRead() && dagRequest.hasIndex() ? dagRequest.buildDAGGetIndexData() : dagRequest.buildDAGGetTableData();
        return new DAGIterator<TiChunk>(request, regionTasks, session, SchemaInfer.create(dagRequest.getResultTypes()), dagRequest.getPushDownType(), dagRequest.getStoreType(), dagRequest.getStartTs().getVersion()){

            @Override
            public TiChunk next() {
                DataType[] dataTypes = this.schemaInfer.getTypes().toArray(new DataType[0]);
                if (this.encodeType == EncodeType.TypeDefault) {
                    Row[] rows = new Row[numOfRows];
                    int count = 0;
                    for (int i = 0; i < rows.length && this.hasNext(); ++i) {
                        rows[i] = this.rowReader.readRow(dataTypes);
                        ++count;
                    }
                    TiColumnVector[] columnarVectors = new TiRowColumnVector[dataTypes.length];
                    for (int i = 0; i < dataTypes.length; ++i) {
                        columnarVectors[i] = new TiRowColumnVector(dataTypes[i], i, rows, count);
                    }
                    return new TiChunk(columnarVectors);
                }
                if (this.encodeType == EncodeType.TypeChunk) {
                    int i;
                    int count;
                    int size;
                    TiColumnVector[] columnarVectors = new TiColumnVector[dataTypes.length];
                    ArrayList childColumnVectors = new ArrayList();
                    for (int i2 = 0; i2 < dataTypes.length; ++i2) {
                        childColumnVectors.add(new ArrayList());
                    }
                    for (count = 0; count < numOfRows && this.hasNext(); count += ((TiChunkColumnVector)((List)childColumnVectors.get(0)).get(size - 1)).numOfRows()) {
                        for (i = 0; i < dataTypes.length; ++i) {
                            ((List)childColumnVectors.get(i)).add(dataTypes[i].decodeChunkColumn(this.dataInput));
                        }
                        size = ((List)childColumnVectors.get(0)).size();
                        this.dataInput = new CodecDataInput(new byte[0]);
                    }
                    for (i = 0; i < dataTypes.length; ++i) {
                        columnarVectors[i] = new BatchedTiChunkColumnVector((List)childColumnVectors.get(i), count);
                    }
                    return new TiChunk(columnarVectors);
                }
                long colCount = Codec.IntegerCodec.readUVarLong(this.dataInput);
                long numOfRows2 = Codec.IntegerCodec.readUVarLong(this.dataInput);
                TiColumnVector[] columnVectors = new TiColumnVector[(int)colCount];
                int columnIdx = 0;
                while ((long)columnIdx < colCount) {
                    long length = Codec.IntegerCodec.readUVarLong(this.dataInput);
                    int i = 0;
                    while ((long)i < length) {
                        this.dataInput.readByte();
                        ++i;
                    }
                    length = Codec.IntegerCodec.readUVarLong(this.dataInput);
                    byte[] utf8Bytes = new byte[(int)length];
                    int i3 = 0;
                    while ((long)i3 < length) {
                        utf8Bytes[i3] = this.dataInput.readByte();
                        ++i3;
                    }
                    String typeName = new String(utf8Bytes, StandardCharsets.UTF_8);
                    CHType type = CHTypeMapping.parseType(typeName);
                    columnVectors[columnIdx] = type.decode(this.dataInput, (int)numOfRows2);
                    ++columnIdx;
                }
                this.dataInput = new CodecDataInput(new byte[0]);
                return new TiChunk(columnVectors);
            }
        };
    }

    public static CoprocessorIterator<Handle> getHandleIterator(TiDAGRequest req, List<RangeSplitter.RegionTask> regionTasks, TiSession session) {
        TiDAGRequest dagRequest = req.copy();
        dagRequest.setEncodeType(EncodeType.TypeDefault);
        DAGRequest request = dagRequest.buildDAGGetIndexData();
        return new DAGIterator<Handle>(request, regionTasks, session, SchemaInfer.create(dagRequest.getResultTypes()), dagRequest.getPushDownType(), dagRequest.getStoreType(), dagRequest.getStartTs().getVersion()){

            @Override
            public Handle next() {
                Row row = this.rowReader.readRow(this.handleTypes);
                Object[] data = new Object[this.handleTypes.length];
                for (int i = 0; i < this.handleTypes.length; ++i) {
                    data[i] = row.get(i, this.handleTypes[i]);
                }
                if (this.handleTypes.length == 1 && this.handleTypes[0] == IntegerType.BIGINT) {
                    return new IntHandle((Long)data[0]);
                }
                return CommonHandle.newCommonHandle(this.handleTypes, data);
            }
        };
    }

    abstract void submitTasks();

    boolean tryAdvanceChunkIndex() {
        if (this.chunkList == null || this.chunkIndex >= this.chunkList.size() - 1) {
            return false;
        }
        ++this.chunkIndex;
        return true;
    }

    void createDataInputReader() {
        Objects.requireNonNull(this.chunkList, "Chunk list should not be null.");
        if (0 > this.chunkIndex || this.chunkIndex >= this.chunkList.size()) {
            throw new IllegalArgumentException();
        }
        this.dataInput = new CodecDataInput(this.chunkList.get(this.chunkIndex).getRowsData());
        this.rowReader = RowReaderFactory.createRowReader(this.dataInput);
    }
}

