/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.predicates;

import com.pingcap.com.google.common.annotations.VisibleForTesting;
import com.pingcap.com.google.common.base.Preconditions;
import com.pingcap.com.google.common.collect.BoundType;
import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.com.google.common.collect.Range;
import com.pingcap.com.google.common.primitives.UnsignedLong;
import com.pingcap.tidb.tipb.EncodeType;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.PartitionPruner;
import com.pingcap.tikv.expression.visitor.IndexMatcher;
import com.pingcap.tikv.key.IndexScanKeyRangeBuilder;
import com.pingcap.tikv.key.IntHandle;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.key.RowKey;
import com.pingcap.tikv.key.TypedKey;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.meta.TiIndexColumn;
import com.pingcap.tikv.meta.TiIndexInfo;
import com.pingcap.tikv.meta.TiPartitionDef;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.meta.TiTimestamp;
import com.pingcap.tikv.predicates.IndexRange;
import com.pingcap.tikv.predicates.PredicateUtils;
import com.pingcap.tikv.predicates.ScanSpec;
import com.pingcap.tikv.predicates.SelectivityCalculator;
import com.pingcap.tikv.region.TiStoreType;
import com.pingcap.tikv.statistics.IndexStatistics;
import com.pingcap.tikv.statistics.TableStatistics;
import com.pingcap.tikv.types.IntegerType;
import com.pingcap.tikv.types.MySQLType;
import com.pingcap.tikv.util.KeyRangeUtils;
import com.pingcap.tikv.util.Pair;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Coprocessor;

public class TiKVScanAnalyzer {
    private static final double INDEX_SCAN_COST_FACTOR = 1.2;
    private static final double TABLE_SCAN_COST_FACTOR = 1.0;
    private static final double DOUBLE_READ_COST_FACTOR = 3.0;
    private static final long TABLE_PREFIX_SIZE = 8L;
    private static final long INDEX_PREFIX_SIZE = 8L;
    private static final BigDecimal MAX_SIGNED_LONG = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal MIN_UNSIGNED_LONG_BEYOND_SIGNED_LONG = MAX_SIGNED_LONG.add(new BigDecimal(1));
    private static final BigDecimal MAX_UNSIGNED_LONG = new BigDecimal(UnsignedLong.fromLongBits(-1L).bigIntegerValue());
    private static final BigDecimal BEYOND_UNSIGNED_LONG = MAX_UNSIGNED_LONG.add(new BigDecimal(1));

    @VisibleForTesting
    public static ScanSpec extractConditions(List<Expression> conditions, TiTableInfo table, TiIndexInfo index) {
        ScanSpec.Builder specBuilder = new ScanSpec.Builder(table, index);
        if (index != null) {
            HashSet<Expression> visited = new HashSet<Expression>();
            block0: for (int i = 0; i < index.getIndexColumns().size(); ++i) {
                TiIndexColumn col = index.getIndexColumns().get(i);
                IndexMatcher eqMatcher = IndexMatcher.equalOnlyMatcher(col);
                boolean found = false;
                for (Expression cond : conditions) {
                    if (visited.contains(cond) || !eqMatcher.match(cond)) continue;
                    specBuilder.addPointPredicate(col, cond);
                    if (col.isPrefixIndex()) {
                        specBuilder.addResidualPredicate(cond);
                        break block0;
                    }
                    visited.add(cond);
                    found = true;
                    break;
                }
                if (found) continue;
                IndexMatcher matcher = IndexMatcher.matcher(col);
                for (Expression cond : conditions) {
                    if (visited.contains(cond) || !matcher.match(cond)) continue;
                    specBuilder.addRangePredicate(col, cond);
                    if (!col.isPrefixIndex()) continue;
                    specBuilder.addResidualPredicate(cond);
                    break block0;
                }
                break;
            }
        }
        specBuilder.addAllPredicates(conditions);
        return specBuilder.build();
    }

    public TiDAGRequest buildTiDAGReq(List<TiColumnInfo> columnList, List<Expression> conditions, TiTableInfo table, TiTimestamp ts, TiDAGRequest dagRequest) {
        return this.buildTiDAGReq(true, false, true, false, columnList, conditions, table, null, ts, dagRequest);
    }

    public TiDAGRequest buildTiDAGReq(boolean allowIndexScan, boolean useIndexScanFirst, boolean canUseTiKV, boolean canUseTiFlash, List<TiColumnInfo> columnList, List<Expression> conditions, TiTableInfo table, TableStatistics tableStatistics, TiTimestamp ts, TiDAGRequest dagRequest) {
        TiKVScanPlan minPlan = null;
        if (canUseTiKV) {
            minPlan = this.buildTableScan(conditions, table, tableStatistics);
        }
        if (canUseTiFlash) {
            TiKVScanPlan plan = this.buildTiFlashScan(columnList, conditions, table, tableStatistics);
            if (minPlan == null || plan.getCost() < minPlan.getCost()) {
                minPlan = plan;
            }
        } else if (canUseTiKV && allowIndexScan) {
            minPlan.getFilters().forEach(dagRequest::addDowngradeFilter);
            if (!table.isPartitionEnabled()) {
                TiKVScanPlan minIndexPlan = null;
                double minIndexCost = Double.MAX_VALUE;
                for (TiIndexInfo index : table.getIndices()) {
                    TiKVScanPlan plan;
                    if (table.isCommonHandle() && table.getPrimaryKey().equals(index) || !this.supportIndexScan(index, table) || !((plan = this.buildIndexScan(columnList, conditions, index, table, tableStatistics, false)).getCost() < minIndexCost)) continue;
                    minIndexPlan = plan;
                    minIndexCost = plan.getCost();
                }
                if (minIndexPlan != null && (minIndexCost < minPlan.getCost() || useIndexScanFirst)) {
                    minPlan = minIndexPlan;
                }
            }
        }
        if (minPlan == null) {
            throw new TiClientInternalException("No valid plan found for table '" + table.getName() + "'");
        }
        TiStoreType minPlanStoreType = minPlan.getStoreType();
        if (minPlanStoreType == TiStoreType.TiKV && dagRequest.getEncodeType() == EncodeType.TypeCHBlock) {
            dagRequest.setEncodeType(EncodeType.TypeChunk);
        }
        dagRequest.setStoreType(minPlanStoreType);
        dagRequest.addRanges(minPlan.getKeyRanges(), minPlan.getRangeFilters());
        dagRequest.setPrunedParts(minPlan.getPrunedParts());
        dagRequest.addFilters(new ArrayList<Expression>(minPlan.getFilters()));
        if (minPlan.isIndexScan()) {
            dagRequest.setIndexInfo(minPlan.getIndex());
            dagRequest.setIsDoubleRead(minPlan.isDoubleRead());
        }
        dagRequest.setTableInfo(table);
        dagRequest.setStartTs(ts);
        dagRequest.setEstimatedCount(minPlan.getEstimatedRowCount());
        return dagRequest;
    }

    private TiKVScanPlan buildTableScan(List<Expression> conditions, TiTableInfo table, TableStatistics tableStatistics) {
        TiIndexInfo pkIndex = TiIndexInfo.generateFakePrimaryKeyIndex(table);
        return this.buildIndexScan(table.getColumns(), conditions, pkIndex, table, tableStatistics, false);
    }

    private TiKVScanPlan buildTiFlashScan(List<TiColumnInfo> columnList, List<Expression> conditions, TiTableInfo table, TableStatistics tableStatistics) {
        TiIndexInfo pkIndex = TiIndexInfo.generateFakePrimaryKeyIndex(table);
        return this.buildIndexScan(columnList, conditions, pkIndex, table, tableStatistics, true);
    }

    TiKVScanPlan buildIndexScan(List<TiColumnInfo> columnList, List<Expression> conditions, TiIndexInfo index, TiTableInfo table, TableStatistics tableStatistics, boolean useTiFlash) {
        Objects.requireNonNull(table, "Table cannot be null to encoding keyRange");
        Objects.requireNonNull(conditions, "conditions cannot be null to encoding keyRange");
        TiKVScanPlan.Builder planBuilder = TiKVScanPlan.Builder.newBuilder(table.getName());
        ScanSpec result = TiKVScanAnalyzer.extractConditions(conditions, table, index);
        double cost = SelectivityCalculator.calcPseudoSelectivity(result);
        planBuilder.setCost(cost);
        List<IndexRange> irs = PredicateUtils.expressionToIndexRanges(result.getPointPredicates(), result.getRangePredicate(), table, index);
        List<TiPartitionDef> prunedParts = null;
        if (table.getPartitionInfo() != null) {
            prunedParts = PartitionPruner.prune(table, conditions);
        }
        planBuilder.setFilters(result.getResidualPredicates()).setPrunedParts(prunedParts);
        long tableColSize = table.getEstimatedRowSizeInByte() + 8L;
        if (index == null || index.isFakePrimaryKey()) {
            planBuilder.setDoubleRead(false).setKeyRanges(this.buildTableScanKeyRange(table, irs, prunedParts), result.getPointPredicates(), result.getRangePredicate());
            if (useTiFlash) {
                long colSize = columnList.stream().mapToLong(TiColumnInfo::getSize).sum() + 8L;
                return planBuilder.setStoreType(TiStoreType.TiFlash).calculateCostAndEstimateCount(tableStatistics, colSize).build();
            }
            return planBuilder.calculateCostAndEstimateCount(tableStatistics, tableColSize).build();
        }
        assert (!useTiFlash);
        long indexSize = index.getIndexColumnSize() + 8L + 8L;
        return planBuilder.setIndex(index).setDoubleRead(!this.isCoveringIndex(columnList, index, table.isPkHandle())).calculateCostAndEstimateCount(tableStatistics, conditions, irs, indexSize, tableColSize).setKeyRanges(this.buildIndexScanKeyRange(table, index, irs, prunedParts), result.getPointPredicates(), result.getRangePredicate()).build();
    }

    private ScanRange buildTableScanSignedKeyRangePerId(long id, IndexRange ir) {
        Key signedEndKey;
        Key signedStartKey;
        if (ir.hasAccessKey()) {
            Preconditions.checkArgument(!ir.hasRange(), "Table scan must have one and only one access condition / point");
            Key key = ir.getAccessKey();
            Preconditions.checkArgument(key instanceof TypedKey, "Table scan key range must be typed key");
            TypedKey typedKey = (TypedKey)key;
            signedStartKey = RowKey.toRowKey(id, typedKey);
            signedEndKey = ((Key)signedStartKey).next();
        } else if (ir.hasRange()) {
            Preconditions.checkArgument(!ir.hasAccessKey(), "Table scan must have one and only one access condition / point");
            Range<TypedKey> r = ir.getRange();
            if (!r.hasLowerBound()) {
                signedStartKey = RowKey.createMin(id);
            } else {
                signedStartKey = RowKey.toRowKey(id, r.lowerEndpoint());
                if (r.lowerBoundType().equals((Object)BoundType.OPEN)) {
                    signedStartKey = ((Key)signedStartKey).next();
                }
            }
            if (!r.hasUpperBound()) {
                signedEndKey = RowKey.createBeyondMax(id);
            } else {
                signedEndKey = RowKey.toRowKey(id, r.upperEndpoint());
                if (r.upperBoundType().equals((Object)BoundType.CLOSED)) {
                    signedEndKey = signedEndKey.next();
                }
            }
        } else {
            throw new TiClientInternalException("Empty access conditions");
        }
        return new ScanRange(signedStartKey, signedEndKey, null, null);
    }

    private ScanRange buildTableScanUnsignedKeyRangePerId(long id, IndexRange ir) {
        if (ir.hasAccessKey()) {
            Preconditions.checkArgument(!ir.hasRange(), "Table scan must have one and only one access condition / point");
            Key key = ir.getAccessKey();
            Preconditions.checkArgument(key instanceof TypedKey, "Table scan key range must be typed key");
            BigDecimal value = (BigDecimal)((TypedKey)key).getValue();
            if (value.compareTo(MAX_SIGNED_LONG) > 0) {
                RowKey unsignedStartClosedKey = RowKey.toRowKey(id, new IntHandle(value.longValue()));
                Key unsignedEndOpenKey = unsignedStartClosedKey.nextPrefix();
                return new ScanRange(null, null, unsignedStartClosedKey, unsignedEndOpenKey);
            }
            RowKey signedStartClosedKey = RowKey.toRowKey(id, new IntHandle(value.longValue()));
            Key signedEndOpenKey = signedStartClosedKey.nextPrefix();
            return new ScanRange(signedStartClosedKey, signedEndOpenKey, null, null);
        }
        if (ir.hasRange()) {
            BigDecimal endOpenKey;
            BigDecimal startClosedKey;
            Range<TypedKey> r = ir.getRange();
            if (r.hasLowerBound()) {
                BigDecimal startKey = (BigDecimal)r.lowerEndpoint().getValue();
                startClosedKey = r.lowerBoundType().equals((Object)BoundType.CLOSED) ? startKey : (startKey.equals(MAX_UNSIGNED_LONG) ? BEYOND_UNSIGNED_LONG : startKey.add(BigDecimal.ONE));
            } else {
                startClosedKey = new BigDecimal(0);
            }
            boolean startClosedKeyBeyondUint64 = startClosedKey.equals(BEYOND_UNSIGNED_LONG);
            if (startClosedKeyBeyondUint64) {
                throw new IllegalArgumentException("Invalid range, startKey has exceeded MAX_UNSIGNED_LONG");
            }
            if (r.hasUpperBound()) {
                BigDecimal endKey = (BigDecimal)r.upperEndpoint().getValue();
                endOpenKey = r.upperBoundType().equals((Object)BoundType.OPEN) ? endKey : (endKey.equals(MAX_UNSIGNED_LONG) ? BEYOND_UNSIGNED_LONG : endKey.add(BigDecimal.ONE));
            } else {
                endOpenKey = BEYOND_UNSIGNED_LONG;
            }
            boolean endOpenKeyBeyondUint64 = Objects.equals(endOpenKey, BEYOND_UNSIGNED_LONG);
            if (endOpenKey.compareTo(MIN_UNSIGNED_LONG_BEYOND_SIGNED_LONG) <= 0) {
                Key signedEndOpenKey = endOpenKey.equals(MIN_UNSIGNED_LONG_BEYOND_SIGNED_LONG) ? RowKey.toRowKey(id, new IntHandle(Long.MAX_VALUE)).nextPrefix() : RowKey.toRowKey(id, new IntHandle(endOpenKey.longValue()));
                return new ScanRange(RowKey.toRowKey(id, new IntHandle(startClosedKey.longValue())), signedEndOpenKey, null, null);
            }
            if (startClosedKey.compareTo(MAX_SIGNED_LONG) > 0) {
                RowKey unsignedStartClosedKey = RowKey.toRowKey(id, new IntHandle(startClosedKey.longValue()));
                return new ScanRange(null, null, unsignedStartClosedKey, endOpenKeyBeyondUint64 ? RowKey.toRowKey(id, new IntHandle(MAX_UNSIGNED_LONG.longValue())).nextPrefix() : RowKey.toRowKey(id, new IntHandle(endOpenKey.longValue())));
            }
            RowKey signedStartClosedKey = RowKey.toRowKey(id, new IntHandle(startClosedKey.longValue()));
            Key signedEndOpenKey = RowKey.toRowKey(id, new IntHandle(MAX_SIGNED_LONG.longValue())).nextPrefix();
            RowKey unsignedStartClosedKey = RowKey.toRowKey(id, new IntHandle(MIN_UNSIGNED_LONG_BEYOND_SIGNED_LONG.longValue()));
            Key unsignedEndOpenKey = endOpenKeyBeyondUint64 ? RowKey.toRowKey(id, new IntHandle(MAX_UNSIGNED_LONG.longValue())).nextPrefix() : RowKey.toRowKey(id, new IntHandle(endOpenKey.longValue()));
            return new ScanRange(signedStartClosedKey, signedEndOpenKey, unsignedStartClosedKey, unsignedEndOpenKey);
        }
        throw new TiClientInternalException("Empty access conditions");
    }

    private ScanRange buildTableScanKeyRangePerId(long id, IndexRange ir, IntegerType handleDataType) {
        if (handleDataType.isUnsignedLong()) {
            return this.buildTableScanUnsignedKeyRangePerId(id, ir);
        }
        return this.buildTableScanSignedKeyRangePerId(id, ir);
    }

    private Map<Long, List<Coprocessor.KeyRange>> buildTableScanKeyRangeWithIds(List<Long> ids, List<IndexRange> indexRanges, IntegerType handleDatatype) {
        HashMap<Long, List<Coprocessor.KeyRange>> idRanges = new HashMap<Long, List<Coprocessor.KeyRange>>(ids.size());
        for (Long id : ids) {
            ArrayList ranges = new ArrayList(indexRanges.size());
            indexRanges.forEach(ir -> {
                Pair<Key, Key> pair;
                ScanRange range = this.buildTableScanKeyRangePerId(id, (IndexRange)ir, handleDatatype);
                Optional<Pair<Key, Key>> signedKeyRange = range.signedKeyRange;
                Optional<Pair<Key, Key>> unsignedKeyRange = range.unSignedKeyRange;
                if (signedKeyRange.isPresent()) {
                    pair = signedKeyRange.get();
                    ranges.add(KeyRangeUtils.makeCoprocRange(((Key)pair.first).toByteString(), ((Key)pair.second).toByteString()));
                }
                if (unsignedKeyRange.isPresent()) {
                    pair = unsignedKeyRange.get();
                    ranges.add(KeyRangeUtils.makeCoprocRange(((Key)pair.first).toByteString(), ((Key)pair.second).toByteString()));
                }
            });
            idRanges.put(id, ranges);
        }
        return idRanges;
    }

    public Map<Long, List<Coprocessor.KeyRange>> buildTableScanKeyRange(TiTableInfo table, List<IndexRange> indexRanges, List<TiPartitionDef> prunedParts) {
        Objects.requireNonNull(table, "Table is null");
        Objects.requireNonNull(indexRanges, "indexRanges is null");
        IntegerType handleDatatype = table.isPkHandle() ? (IntegerType)table.getPKIsHandleColumn().getType() : IntegerType.ROW_ID_TYPE;
        if (table.isPartitionEnabled()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (TiPartitionDef pDef : prunedParts) {
                ids.add(pDef.getId());
            }
            return this.buildTableScanKeyRangeWithIds(ids, indexRanges, handleDatatype);
        }
        return this.buildTableScanKeyRangeWithIds(ImmutableList.of(Long.valueOf(table.getId())), indexRanges, handleDatatype);
    }

    @VisibleForTesting
    private Map<Long, List<Coprocessor.KeyRange>> buildIndexScanKeyRangeWithIds(List<Long> ids, TiIndexInfo index, List<IndexRange> indexRanges) {
        HashMap<Long, List<Coprocessor.KeyRange>> idRanges = new HashMap<Long, List<Coprocessor.KeyRange>>();
        for (long id : ids) {
            ArrayList<Coprocessor.KeyRange> ranges = new ArrayList<Coprocessor.KeyRange>(indexRanges.size());
            for (IndexRange ir : indexRanges) {
                IndexScanKeyRangeBuilder indexScanKeyRangeBuilder = new IndexScanKeyRangeBuilder(id, index, ir);
                ranges.add(indexScanKeyRangeBuilder.compute());
            }
            idRanges.put(id, ranges);
        }
        return idRanges;
    }

    @VisibleForTesting
    Map<Long, List<Coprocessor.KeyRange>> buildIndexScanKeyRange(TiTableInfo table, TiIndexInfo index, List<IndexRange> indexRanges, List<TiPartitionDef> prunedParts) {
        Objects.requireNonNull(table, "Table cannot be null to encoding keyRange");
        Objects.requireNonNull(index, "Index cannot be null to encoding keyRange");
        Objects.requireNonNull(indexRanges, "indexRanges cannot be null to encoding keyRange");
        if (table.isPartitionEnabled()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (TiPartitionDef pDef : prunedParts) {
                ids.add(pDef.getId());
            }
            return this.buildIndexScanKeyRangeWithIds(ids, index, indexRanges);
        }
        return this.buildIndexScanKeyRangeWithIds(ImmutableList.of(Long.valueOf(table.getId())), index, indexRanges);
    }

    boolean isCoveringIndex(List<TiColumnInfo> columns, TiIndexInfo indexColumns, boolean pkIsHandle) {
        if (columns.isEmpty()) {
            return false;
        }
        Map<String, TiIndexColumn> colInIndex = indexColumns.getIndexColumns().stream().collect(Collectors.toMap(TiIndexColumn::getName, col -> col));
        for (TiColumnInfo colInfo : columns) {
            if (pkIsHandle && colInfo.isPrimaryKey() || colInfo.getId() == -1L) continue;
            boolean colNotInIndex = false;
            if (colInIndex.containsKey(colInfo.getName())) {
                boolean isFullLength;
                TiIndexColumn indexCol = colInIndex.get(colInfo.getName());
                boolean bl = isFullLength = indexCol.isLengthUnspecified() || indexCol.getLength() == colInfo.getType().getLength();
                if (!colInfo.getName().equalsIgnoreCase(indexCol.getName()) || !isFullLength) {
                    colNotInIndex = true;
                }
            } else {
                colNotInIndex = true;
            }
            if (!colNotInIndex) continue;
            return false;
        }
        return true;
    }

    private boolean supportIndexScan(TiIndexInfo index, TiTableInfo table) {
        for (TiIndexColumn tiIndexColumn : index.getIndexColumns()) {
            TiColumnInfo tiColumnInfo = table.getColumn(tiIndexColumn.getName());
            if (tiColumnInfo.getType().getType() != MySQLType.TypeYear) continue;
            return false;
        }
        return true;
    }

    public static class ScanRange {
        Optional<Pair<Key, Key>> signedKeyRange = Optional.empty();
        Optional<Pair<Key, Key>> unSignedKeyRange = Optional.empty();

        public ScanRange(Key signedStartKey, Key signedEndKey, Key unsignedStartKey, Key unsignedEndKey) {
            if (signedStartKey != null && signedEndKey != null) {
                this.signedKeyRange = Optional.of(new Pair<Key, Key>(signedStartKey, signedEndKey));
            }
            if (unsignedStartKey != null && unsignedEndKey != null) {
                this.unSignedKeyRange = Optional.of(new Pair<Key, Key>(unsignedStartKey, unsignedEndKey));
            }
        }
    }

    public static class TiKVScanPlan {
        private final Map<Long, List<Coprocessor.KeyRange>> keyRanges;
        private final List<Expression> rangeFilters;
        private final Set<Expression> filters;
        private final double cost;
        private final TiIndexInfo index;
        private final boolean isDoubleRead;
        private final double estimatedRowCount;
        private final List<TiPartitionDef> prunedParts;
        private final TiStoreType storeType;

        private TiKVScanPlan(Map<Long, List<Coprocessor.KeyRange>> keyRanges, List<Expression> rangeFilters, Set<Expression> filters, TiIndexInfo index, double cost, boolean isDoubleRead, double estimatedRowCount, List<TiPartitionDef> partDefs, TiStoreType storeType) {
            this.filters = filters;
            this.rangeFilters = rangeFilters;
            this.keyRanges = keyRanges;
            this.cost = cost;
            this.index = index;
            this.isDoubleRead = isDoubleRead;
            this.estimatedRowCount = estimatedRowCount;
            this.prunedParts = partDefs;
            this.storeType = storeType;
        }

        public double getEstimatedRowCount() {
            return this.estimatedRowCount;
        }

        public Map<Long, List<Coprocessor.KeyRange>> getKeyRanges() {
            return this.keyRanges;
        }

        public List<Expression> getRangeFilters() {
            return this.rangeFilters;
        }

        public Set<Expression> getFilters() {
            return this.filters;
        }

        public double getCost() {
            return this.cost;
        }

        public boolean isIndexScan() {
            return this.index != null && !this.index.isFakePrimaryKey();
        }

        public TiIndexInfo getIndex() {
            return this.index;
        }

        public boolean isDoubleRead() {
            return this.isDoubleRead;
        }

        public List<TiPartitionDef> getPrunedParts() {
            return this.prunedParts;
        }

        public TiStoreType getStoreType() {
            return this.storeType;
        }

        public static class Builder {
            private final String tableName;
            private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
            private Map<Long, List<Coprocessor.KeyRange>> keyRanges;
            private List<Expression> rangeFilters;
            private Set<Expression> filters;
            private double cost;
            private TiIndexInfo index;
            private boolean isDoubleRead;
            private double estimatedRowCount = -1.0;
            private List<TiPartitionDef> prunedParts;
            private TiStoreType storeType = TiStoreType.TiKV;

            private Builder(String tableName) {
                this.tableName = tableName;
            }

            public static Builder newBuilder(String tableName) {
                return new Builder(tableName);
            }

            public Builder setKeyRanges(Map<Long, List<Coprocessor.KeyRange>> keyRanges, List<Expression> pointPredicate, Optional<Expression> rangePredicate) {
                this.keyRanges = keyRanges;
                if (this.rangeFilters == null) {
                    this.rangeFilters = new ArrayList<Expression>();
                }
                this.rangeFilters.addAll(pointPredicate);
                rangePredicate.ifPresent(expression -> this.rangeFilters.add((Expression)expression));
                return this;
            }

            public Builder setFilters(Set<Expression> filters) {
                this.filters = filters;
                return this;
            }

            public Builder setCost(double cost) {
                this.cost = cost;
                return this;
            }

            public Builder setIndex(TiIndexInfo index) {
                this.index = index;
                return this;
            }

            public Builder setDoubleRead(boolean doubleRead) {
                this.isDoubleRead = doubleRead;
                return this;
            }

            public Builder setEstimatedRowCount(double estimatedRowCount) {
                this.estimatedRowCount = estimatedRowCount;
                return this;
            }

            public Builder setPrunedParts(List<TiPartitionDef> prunedParts) {
                this.prunedParts = prunedParts;
                return this;
            }

            public Builder setStoreType(TiStoreType storeType) {
                this.storeType = storeType;
                return this;
            }

            public TiKVScanPlan build() {
                return new TiKVScanPlan(this.keyRanges, this.rangeFilters, this.filters, this.index, this.cost, this.isDoubleRead, this.estimatedRowCount, this.prunedParts, this.storeType);
            }

            private void debug(TiDAGRequest.ScanType scanType) {
                String desc;
                String plan;
                switch (scanType) {
                    case TABLE_READER: {
                        plan = "TableReader";
                        desc = this.storeType.toString();
                        break;
                    }
                    case INDEX_LOOKUP: {
                        plan = "IndexLookUp";
                        desc = this.index.getName();
                        break;
                    }
                    case INDEX_READER: {
                        plan = "IndexReader";
                        desc = this.index.getName();
                        break;
                    }
                    default: {
                        plan = "None";
                        desc = "";
                    }
                }
                this.logger.debug("[Table:" + this.tableName + "][" + plan + ":" + desc + "] cost=" + this.cost + " estimated row count=" + this.estimatedRowCount);
            }

            Builder calculateCostAndEstimateCount(TableStatistics tableStatistics, long tableColSize) {
                this.cost = 100.0;
                this.cost *= (double)tableColSize * 1.0;
                if (tableStatistics != null) {
                    this.estimatedRowCount = tableStatistics.getCount();
                }
                this.debug(TiDAGRequest.ScanType.TABLE_READER);
                return this;
            }

            Builder calculateCostAndEstimateCount(TableStatistics tableStatistics, List<Expression> conditions, List<IndexRange> irs, long indexSize, long tableColSize) {
                if (tableStatistics != null) {
                    double totalRowCount = tableStatistics.getCount();
                    IndexStatistics indexStatistics = tableStatistics.getIndexHistMap().get(this.index.getId());
                    if (indexStatistics != null) {
                        totalRowCount = indexStatistics.getHistogram().totalRowCount();
                    }
                    if (conditions.isEmpty()) {
                        this.cost = 100.0;
                        this.estimatedRowCount = totalRowCount;
                    } else if (indexStatistics != null) {
                        double idxRangeRowCnt = indexStatistics.getRowCount(irs);
                        this.cost = 100.0 * idxRangeRowCnt / totalRowCount;
                        this.estimatedRowCount = idxRangeRowCnt;
                    }
                    if (this.isDoubleRead) {
                        this.cost *= (double)tableColSize * 3.0 + (double)indexSize * 1.2;
                        this.debug(TiDAGRequest.ScanType.INDEX_LOOKUP);
                    } else {
                        this.cost *= (double)indexSize * 1.2;
                        this.debug(TiDAGRequest.ScanType.INDEX_READER);
                    }
                }
                return this;
            }
        }
    }
}

