/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.region;

import com.pingcap.com.google.common.base.Preconditions;
import com.pingcap.tikv.AbstractGRPCClient;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.region.RegionErrorReceiver;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.util.ChannelFactory;
import org.tikv.kvproto.Metapb;
import org.tikv.kvproto.TikvGrpc;
import shade.io.grpc.ManagedChannel;

public abstract class AbstractRegionStoreClient
extends AbstractGRPCClient<TikvGrpc.TikvBlockingStub, TikvGrpc.TikvStub>
implements RegionErrorReceiver {
    protected final RegionManager regionManager;
    protected TiRegion region;

    protected AbstractRegionStoreClient(TiConfiguration conf, TiRegion region, ChannelFactory channelFactory, TikvGrpc.TikvBlockingStub blockingStub, TikvGrpc.TikvStub asyncStub, RegionManager regionManager) {
        super(conf, channelFactory, blockingStub, asyncStub);
        Preconditions.checkNotNull(region, "Region is empty");
        Preconditions.checkNotNull(region.getLeader(), "Leader Peer is null");
        Preconditions.checkArgument(region.getLeader() != null, "Leader Peer is null");
        this.region = region;
        this.regionManager = regionManager;
    }

    @Override
    public TiRegion getRegion() {
        return this.region;
    }

    @Override
    protected TikvGrpc.TikvBlockingStub getBlockingStub() {
        return (TikvGrpc.TikvBlockingStub)((TikvGrpc.TikvBlockingStub)this.blockingStub).withDeadlineAfter(this.getConf().getTimeout(), this.getConf().getTimeoutUnit());
    }

    @Override
    protected TikvGrpc.TikvStub getAsyncStub() {
        return (TikvGrpc.TikvStub)((TikvGrpc.TikvStub)this.asyncStub).withDeadlineAfter(this.getConf().getTimeout(), this.getConf().getTimeoutUnit());
    }

    @Override
    public void close() throws GrpcException {
    }

    @Override
    public boolean onNotLeader(Metapb.Store newStore, TiRegion newRegion) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.region + ", new leader = " + newStore.getId());
        }
        if (!this.region.getRegionEpoch().equals(newRegion.getRegionEpoch())) {
            return false;
        }
        this.region = newRegion;
        String addressStr = this.regionManager.getStoreById(this.region.getLeader().getStoreId()).getAddress();
        ManagedChannel channel = this.channelFactory.getChannel(addressStr, this.regionManager.getPDClient().getHostMapping());
        this.blockingStub = TikvGrpc.newBlockingStub(channel);
        this.asyncStub = TikvGrpc.newStub(channel);
        return true;
    }

    @Override
    public void onStoreNotMatch(Metapb.Store store) {
        String addressStr = store.getAddress();
        ManagedChannel channel = this.channelFactory.getChannel(addressStr, this.regionManager.getPDClient().getHostMapping());
        this.blockingStub = TikvGrpc.newBlockingStub(channel);
        this.asyncStub = TikvGrpc.newStub(channel);
        if (this.logger.isDebugEnabled() && this.region.getLeader().getStoreId() != store.getId()) {
            this.logger.debug("store_not_match may occur? " + this.region + ", original store = " + store.getId() + " address = " + addressStr);
        }
    }
}

