/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.txn;

import com.pingcap.tikv.ReadOnlyPDClient;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.KeyException;
import com.pingcap.tikv.exception.RegionException;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.exception.TiKVException;
import com.pingcap.tikv.meta.TiTimestamp;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.RegionStoreClient;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.txn.type.ClientRPCResult;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ConcreteBackOffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.Metapb;
import shade.com.google.protobuf.ByteString;
import shade.io.grpc.StatusRuntimeException;

public class TxnKVClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TxnKVClient.class);
    private final RegionStoreClient.RegionStoreClientBuilder clientBuilder;
    private final TiConfiguration conf;
    private final RegionManager regionManager;
    private final ReadOnlyPDClient pdClient;

    public TxnKVClient(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder clientBuilder, ReadOnlyPDClient pdClient) {
        this.conf = conf;
        this.clientBuilder = clientBuilder;
        this.regionManager = clientBuilder.getRegionManager();
        this.pdClient = pdClient;
    }

    public TiConfiguration getConf() {
        return this.conf;
    }

    public RegionManager getRegionManager() {
        return this.regionManager;
    }

    public TiTimestamp getTimestamp() {
        ConcreteBackOffer bo = ConcreteBackOffer.newTsoBackOff();
        TiTimestamp timestamp = new TiTimestamp(0L, 0L);
        try {
            while (true) {
                try {
                    timestamp = this.pdClient.getTimestamp(bo);
                }
                catch (TiClientInternalException | TiKVException e) {
                    bo.doBackOff(BackOffFunction.BackOffFuncType.BoPDRPC, e);
                    continue;
                }
                break;
            }
        }
        catch (GrpcException e1) {
            LOG.error("Get tso from pd failed,", (Throwable)e1);
        }
        return timestamp;
    }

    public ClientRPCResult prewrite(BackOffer backOffer, List<Kvrpcpb.Mutation> mutations, ByteString primary, long lockTTL, long startTs, TiRegion tiRegion) {
        ClientRPCResult result = new ClientRPCResult(true, false, null);
        RegionStoreClient client = this.clientBuilder.build(tiRegion);
        try {
            client.prewrite(backOffer, primary, mutations, startTs, lockTTL);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setRetry(this.retryableException(e));
            result.setException(e);
        }
        return result;
    }

    public ClientRPCResult txnHeartBeat(BackOffer backOffer, ByteString primaryLock, long startTs, long ttl, TiRegion tiRegion, Metapb.Store store) {
        ClientRPCResult result = new ClientRPCResult(true, false, null);
        RegionStoreClient client = this.clientBuilder.build(tiRegion, store);
        try {
            client.txnHeartBeat(backOffer, primaryLock, startTs, ttl);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setRetry(this.retryableException(e));
            result.setException(e);
        }
        return result;
    }

    public ClientRPCResult commit(BackOffer backOffer, List<ByteString> keys, long startTs, long commitTs, TiRegion tiRegion) {
        ClientRPCResult result = new ClientRPCResult(true, false, null);
        RegionStoreClient client = this.clientBuilder.build(tiRegion);
        try {
            client.commit(backOffer, keys, startTs, commitTs);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setRetry(this.retryableException(e));
            result.setException(e);
        }
        return result;
    }

    private boolean retryableException(Exception e) {
        if (e instanceof TiClientInternalException || e instanceof RegionException || e instanceof StatusRuntimeException) {
            return true;
        }
        if (e instanceof KeyException) {
            Kvrpcpb.KeyError ke = ((KeyException)e).getKeyError();
            if (ke == null) {
                return true;
            }
            return ke.getAbort().isEmpty() && !ke.hasConflict() && !ke.hasAlreadyExist() && !ke.hasDeadlock() && !ke.hasCommitTsExpired() && !ke.hasTxnNotFound();
        }
        return false;
    }

    @Override
    public void close() throws Exception {
    }
}

