/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.types;

import com.pingcap.com.google.common.primitives.UnsignedLong;
import com.pingcap.tikv.ExtendedDateTime;
import com.pingcap.tikv.exception.ConvertNotSupportException;
import com.pingcap.tikv.exception.ConvertOverflowException;
import com.pingcap.tikv.exception.TypeException;
import com.pingcap.tikv.key.Handle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Converter {
    static final DateTimeFormatter UTC_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss").withZone(DateTimeZone.UTC);
    private static final DateTimeZone localTimeZone = DateTimeZone.getDefault();
    private static final DateTimeFormatter localDateTimeFormatter = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss").withZone(localTimeZone);
    private static final DateTimeFormatter localDateFormatter = DateTimeFormat.forPattern("yyyy-MM-dd").withZone(localTimeZone);

    public static Long safeConvertToSigned(Object value, Long lowerBound, Long upperBound) throws ConvertNotSupportException, ConvertOverflowException {
        Long result;
        if (value instanceof Boolean) {
            result = ((Boolean)value).booleanValue() ? Long.valueOf(1L) : Long.valueOf(0L);
        } else if (value instanceof Byte) {
            result = ((Byte)value).longValue();
        } else if (value instanceof Short) {
            result = ((Short)value).longValue();
        } else if (value instanceof Integer) {
            result = ((Integer)value).longValue();
        } else if (value instanceof Long) {
            result = (Long)value;
        } else if (value instanceof Float) {
            result = Converter.floatToLong((Float)value);
        } else if (value instanceof Double) {
            result = Converter.doubleToLong((Double)value);
        } else if (value instanceof String) {
            result = Converter.stringToLong((String)value);
        } else if (value instanceof BigDecimal) {
            result = ((BigDecimal)value).longValueExact();
        } else {
            throw new ConvertNotSupportException(value.getClass().getName(), "SIGNED");
        }
        if (result < lowerBound) {
            throw ConvertOverflowException.newLowerBoundException(result, lowerBound);
        }
        if (result > upperBound) {
            throw ConvertOverflowException.newUpperBoundException(result, upperBound);
        }
        return result;
    }

    public static Long safeConvertToUnsigned(Object value, Long upperBound) throws ConvertNotSupportException, ConvertOverflowException {
        Long result;
        if (value instanceof Boolean) {
            result = ((Boolean)value).booleanValue() ? Long.valueOf(1L) : Long.valueOf(0L);
        } else if (value instanceof Byte) {
            result = ((Byte)value).longValue();
        } else if (value instanceof Short) {
            result = ((Short)value).longValue();
        } else if (value instanceof Integer) {
            result = ((Integer)value).longValue();
        } else if (value instanceof Long) {
            result = (Long)value;
        } else if (value instanceof Float) {
            result = Converter.floatToLong((Float)value);
        } else if (value instanceof Double) {
            result = Converter.doubleToLong((Double)value);
        } else if (value instanceof String) {
            UnsignedLong unsignedLong = Converter.stringToUnsignedLong((String)value);
            result = unsignedLong.longValue();
        } else if (value instanceof BigDecimal) {
            result = ((BigDecimal)value).longValueExact();
        } else {
            throw new ConvertNotSupportException(value.getClass().getName(), "UNSIGNED");
        }
        long lowerBound = 0L;
        if (Long.compareUnsigned(result, lowerBound) < 0) {
            throw ConvertOverflowException.newLowerBoundException(result, lowerBound);
        }
        if (Long.compareUnsigned(result, upperBound) > 0) {
            throw ConvertOverflowException.newUpperBoundException(result, upperBound);
        }
        return result;
    }

    public static Long floatToLong(Float v) {
        return Math.round(v.floatValue());
    }

    public static Long doubleToLong(Double v) {
        return Math.round(v);
    }

    public static Long stringToLong(String v) {
        return Long.parseLong(v);
    }

    public static Double stringToDouble(String v) {
        return Double.parseDouble(v);
    }

    public static UnsignedLong stringToUnsignedLong(String v) {
        return UnsignedLong.valueOf(v);
    }

    public static long convertToLong(Object val) {
        Objects.requireNonNull(val, "val is null");
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (val instanceof String) {
            return Long.parseLong(val.toString());
        }
        if (val instanceof Handle) {
            return ((Handle)val).intValue();
        }
        throw new TypeException(String.format("Cannot cast %s to long", val.getClass().getSimpleName()));
    }

    public static double convertToDouble(Object val) {
        Objects.requireNonNull(val, "val is null");
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof String) {
            return Double.parseDouble(val.toString());
        }
        throw new TypeException(String.format("Cannot cast %s to double", val.getClass().getSimpleName()));
    }

    public static String convertToString(Object val) {
        Objects.requireNonNull(val, "val is null");
        return val.toString();
    }

    public static String convertToUTF8String(Object val) {
        Objects.requireNonNull(val, "val is null");
        if (val instanceof byte[]) {
            return new String((byte[])val, StandardCharsets.UTF_8);
        }
        if (val instanceof String) {
            return (String)val;
        }
        throw new TypeException(String.format("Cannot cast %s to bytes", val.getClass().getSimpleName()));
    }

    public static byte[] convertToBytes(Object val) {
        Objects.requireNonNull(val, "val is null");
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        if (val instanceof String) {
            return ((String)val).getBytes();
        }
        throw new TypeException(String.format("Cannot cast %s to bytes", val.getClass().getSimpleName()));
    }

    public static byte[] convertToBytes(Object val, int prefixLength) {
        Objects.requireNonNull(val, "val is null");
        if (val instanceof byte[]) {
            byte[] valByte = (byte[])val;
            return Arrays.copyOf(valByte, Math.min(valByte.length, prefixLength));
        }
        if (val instanceof String) {
            String valStr = (String)val;
            return Arrays.copyOf(((String)val).getBytes(), Math.min(valStr.length(), prefixLength));
        }
        throw new TypeException(String.format("Cannot cast %s to bytes", val.getClass().getSimpleName()));
    }

    public static byte[] convertUtf8ToBytes(Object val, int prefixLength) {
        Objects.requireNonNull(val, "val is null");
        if (val instanceof byte[]) {
            byte[] valByte = (byte[])val;
            return new String(valByte).substring(0, Math.min(valByte.length, prefixLength)).getBytes(StandardCharsets.UTF_8);
        }
        if (val instanceof String) {
            String valStr = (String)val;
            return valStr.substring(0, Math.min(valStr.length(), prefixLength)).getBytes(StandardCharsets.UTF_8);
        }
        throw new TypeException(String.format("Cannot cast %s to bytes", val.getClass().getSimpleName()));
    }

    public static DateTimeZone getLocalTimezone() {
        return localTimeZone;
    }

    static DateTime strToDateTime(String value, DateTimeFormatter formatter) {
        return DateTime.parse(value, formatter);
    }

    public static ExtendedDateTime convertToDateTime(Object val) {
        Objects.requireNonNull(val, "val is null");
        if (val instanceof DateTime) {
            return new ExtendedDateTime((DateTime)val);
        }
        if (val instanceof String) {
            try {
                String dateTime = (String)val;
                return new ExtendedDateTime(Converter.strToDateTime(dateTime.startsWith("'") ? dateTime.substring(1, dateTime.length() - 1) : dateTime, localDateTimeFormatter));
            }
            catch (Exception e) {
                throw new TypeException(String.format("Error parsing string %s to datetime", val), e);
            }
        }
        if (val instanceof Long) {
            return new ExtendedDateTime(new DateTime((Long)val));
        }
        if (val instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)val;
            DateTime dateTime = DateTime.parse(timestamp.toLocalDateTime().toString());
            int nanos = timestamp.getNanos();
            return new ExtendedDateTime(dateTime, nanos / 1000 % 1000);
        }
        if (val instanceof Date) {
            return new ExtendedDateTime(Converter.strToDateTime(((Date)val).toLocalDate().toString(), localDateFormatter));
        }
        throw new TypeException("Can not cast Object to LocalDateTime ");
    }

    public static Date convertToDate(Object val) {
        Objects.requireNonNull(val, "val is null");
        if (val instanceof Date) {
            return (Date)val;
        }
        if (val instanceof String) {
            try {
                String date = (String)val;
                return new Date(Converter.strToDateTime(date.startsWith("'") ? date.substring(1, date.length() - 1) : date, localDateFormatter).toDate().getTime());
            }
            catch (Exception e) {
                throw new TypeException(String.format("Error parsing string %s to date", val), e);
            }
        }
        if (val instanceof Integer) {
            return new Date((Integer)val - 1970, 1, 1);
        }
        if (val instanceof Long) {
            return new Date((Long)val);
        }
        if (val instanceof Timestamp) {
            return new Date(((Timestamp)val).getTime());
        }
        if (val instanceof DateTime) {
            return new Date(((DateTime)val).getMillis());
        }
        throw new TypeException("Can not cast Object to LocalDate");
    }

    public static BigDecimal convertToBigDecimal(Object val) {
        Objects.requireNonNull(val, "val is null");
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof Double) {
            return BigDecimal.valueOf((Double)val);
        }
        if (val instanceof Float) {
            return BigDecimal.valueOf(((Float)val).floatValue());
        }
        if (val instanceof BigInteger) {
            return new BigDecimal((BigInteger)val);
        }
        if (val instanceof Number) {
            return new BigDecimal(((Number)val).longValue());
        }
        if (val instanceof String) {
            return new BigDecimal((String)val);
        }
        throw new TypeException("can not cast non Number type to Double");
    }

    public static String convertDurationToStr(long nanos, int decimal) {
        int sign = 1;
        if (nanos < 0L) {
            nanos = -nanos;
            sign = -1;
        }
        int hours = (int)(nanos / 3600000000000L);
        int minutes = (int)((nanos -= (long)hours * 3600000000000L) / 60000000000L);
        int seconds = (int)((nanos -= (long)minutes * 60000000000L) / 1000000000L);
        int frac = (int)((nanos -= (long)seconds * 1000000000L) / 1000L);
        StringBuilder sb = new StringBuilder();
        if (sign < 0) {
            sb.append('-');
        }
        sb.append(String.format("%02d:%02d:%02d", hours, minutes, seconds));
        if (decimal > 0) {
            sb.append('.');
            sb.append(String.format("%06d", frac), 0, decimal);
        }
        return sb.toString();
    }

    public static long convertStrToDuration(String value) {
        try {
            int frac;
            int second;
            String[] splitBySemiColon = value.split(":");
            if (splitBySemiColon.length != 3) {
                throw new IllegalArgumentException(String.format("%s is not a valid time type in mysql", value));
            }
            int sign = 1;
            int hour = Integer.parseInt(splitBySemiColon[0]);
            if (hour < 0) {
                sign = -1;
                hour -= hour;
            }
            int minute = Integer.parseInt(splitBySemiColon[1]);
            if (splitBySemiColon[2].contains(".")) {
                String[] splitByDot = splitBySemiColon[2].split("\\.");
                second = Integer.parseInt(splitByDot[0]);
                frac = Integer.parseInt(splitByDot[1]);
            } else {
                second = Integer.parseInt(splitBySemiColon[2]);
                frac = 0;
            }
            return ((long)hour * 3600000000000L + (long)minute * 60000000000L + (long)second * 1000000000L + (long)frac * 1000L) * (long)sign;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("%s is not a valid format. Either hh:mm:ss.mmm or hh:mm:ss is accepted.", value));
        }
    }
}

