/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.util;

import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ConcreteBackOffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shade.com.google.protobuf.ByteString;

public class Batch {
    private final BackOffer backOffer;
    private final TiRegion region;
    private final List<ByteString> keys;
    private final List<ByteString> values;
    private final Map<ByteString, ByteString> map;

    public Batch(BackOffer backOffer, TiRegion region, List<ByteString> keys) {
        this.backOffer = ConcreteBackOffer.create(backOffer);
        this.region = region;
        this.keys = keys;
        this.values = null;
        this.map = null;
    }

    public Batch(BackOffer backOffer, TiRegion region, List<ByteString> keys, List<ByteString> values) {
        this.backOffer = ConcreteBackOffer.create(backOffer);
        this.region = region;
        this.keys = keys;
        this.values = values;
        this.map = this.toMap(keys, values);
    }

    private Map<ByteString, ByteString> toMap(List<ByteString> keys, List<ByteString> values) {
        assert (keys.size() == values.size());
        HashMap<ByteString, ByteString> kvMap = new HashMap<ByteString, ByteString>();
        for (int i = 0; i < keys.size(); ++i) {
            kvMap.put(keys.get(i), values.get(i));
        }
        return kvMap;
    }

    public BackOffer getBackOffer() {
        return this.backOffer;
    }

    public TiRegion getRegion() {
        return this.region;
    }

    public List<ByteString> getKeys() {
        return this.keys;
    }

    public List<ByteString> getValues() {
        return this.values;
    }

    public Map<ByteString, ByteString> getMap() {
        return this.map;
    }
}

