/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.util;

import com.pingcap.com.google.common.io.ByteArrayDataInput;
import com.pingcap.com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import shade.com.google.gson.JsonArray;
import shade.com.google.gson.JsonElement;
import shade.com.google.gson.JsonNull;
import shade.com.google.gson.JsonObject;
import shade.com.google.gson.JsonPrimitive;

public class JsonUtils {
    private static final int KEY_ENTRY_LENGTH = 6;
    private static final int VALUE_ENTRY_SIZE = 5;
    private static final byte TYPE_CODE_OBJECT = 1;
    private static final byte TYPE_CODE_ARRAY = 3;
    private static final byte TYPE_CODE_LITERAL = 4;
    private static final byte TYPE_CODE_INT64 = 9;
    private static final byte TYPE_CODE_UINT64 = 10;
    private static final byte TYPE_CODE_FLOAT64 = 11;
    private static final byte TYPE_CODE_STRING = 12;
    private static final byte LITERAL_NIL = 0;
    private static final byte LITERAL_TRUE = 1;
    private static final byte LITERAL_FALSE = 2;
    private static final JsonPrimitive JSON_FALSE = new JsonPrimitive(false);
    private static final JsonPrimitive JSON_TRUE = new JsonPrimitive(true);

    public static JsonElement parseJson(DataInput di) {
        return JsonUtils.parseValue(JsonUtils.readByte(di), di);
    }

    private static JsonElement parseValue(byte type, DataInput di) {
        switch (type) {
            case 1: {
                return JsonUtils.parseObject(di);
            }
            case 3: {
                return JsonUtils.parseArray(di);
            }
            case 4: {
                return JsonUtils.parseLiteralJson(di);
            }
            case 9: {
                return new JsonPrimitive(JsonUtils.parseInt64(di));
            }
            case 10: {
                return new JsonPrimitive(JsonUtils.parseUint64(di));
            }
            case 11: {
                return new JsonPrimitive(JsonUtils.parseDouble(di));
            }
            case 12: {
                long length = JsonUtils.parseDataLength(di);
                return new JsonPrimitive(JsonUtils.parseString(di, length));
            }
        }
        throw new AssertionError((Object)("error type|type=" + type));
    }

    private static long parseUint64(DataInput cdi) {
        byte[] readBuffer = new byte[8];
        JsonUtils.readFully(cdi, readBuffer, 0, 8);
        return ((long)readBuffer[7] << 56) + ((long)(readBuffer[6] & 0xFF) << 48) + ((long)(readBuffer[5] & 0xFF) << 40) + ((long)(readBuffer[4] & 0xFF) << 32) + ((long)(readBuffer[3] & 0xFF) << 24) + (long)((readBuffer[2] & 0xFF) << 16) + (long)((readBuffer[1] & 0xFF) << 8) + (long)(readBuffer[0] & 0xFF);
    }

    private static void readFully(DataInput di, byte[] buffer) {
        try {
            di.readFully(buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void readFully(DataInput cdi, byte[] readBuffer, int off, int len) {
        try {
            cdi.readFully(readBuffer, off, len);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static long parseInt64(DataInput cdi) {
        byte[] readBuffer = new byte[8];
        JsonUtils.readFully(cdi, readBuffer);
        return JsonUtils.bytesToLong(readBuffer);
    }

    private static long parseUint32(DataInput cdi) {
        byte[] readBuffer = new byte[4];
        JsonUtils.readFully(cdi, readBuffer);
        return ((long)(readBuffer[3] & 0xFF) << 24) + (long)((readBuffer[2] & 0xFF) << 16) + (long)((readBuffer[1] & 0xFF) << 8) + (long)(readBuffer[0] & 0xFF);
    }

    private static long bytesToLong(byte[] readBuffer) {
        return ((long)readBuffer[7] << 56) + ((long)(readBuffer[6] & 0xFF) << 48) + ((long)(readBuffer[5] & 0xFF) << 40) + ((long)(readBuffer[4] & 0xFF) << 32) + ((long)(readBuffer[3] & 0xFF) << 24) + (long)((readBuffer[2] & 0xFF) << 16) + (long)((readBuffer[1] & 0xFF) << 8) + (long)(readBuffer[0] & 0xFF);
    }

    private static double parseDouble(DataInput cdi) {
        byte[] readBuffer = new byte[8];
        JsonUtils.readFully(cdi, readBuffer);
        return Double.longBitsToDouble(JsonUtils.bytesToLong(readBuffer));
    }

    private static int parseUint16(DataInput cdi) {
        byte[] readBuffer = new byte[2];
        JsonUtils.readFully(cdi, readBuffer);
        return ((readBuffer[1] & 0xFF) << 8) + (readBuffer[0] & 0xFF);
    }

    private static String parseString(DataInput di, long length) {
        byte[] buffer = new byte[Math.toIntExact(length)];
        JsonUtils.readFully(di, buffer);
        return new String(buffer, StandardCharsets.UTF_8);
    }

    private static long parseDataLength(DataInput di) {
        byte b;
        long x = 0L;
        int i = 0;
        int s = 0;
        while ((b = JsonUtils.readByte(di)) < 0) {
            if (i == 9) {
                throw new IllegalArgumentException("overflow: found >=9 leading bytes");
            }
            x |= (long)(b & 0x7F) << s;
            s += 7;
            ++i;
        }
        if (i == 9 && b > 1) {
            throw new IllegalArgumentException("overflow: 8 leading byte and last one > 1");
        }
        return x |= (long)b << s;
    }

    @Nullable
    private static Boolean parseLiteral(DataInput cdi) {
        byte type = JsonUtils.readByte(cdi);
        switch (type) {
            case 2: {
                return Boolean.FALSE;
            }
            case 0: {
                return null;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new AssertionError((Object)("unknown literal type|" + type));
    }

    private static byte readByte(DataInput cdi) {
        byte type;
        try {
            type = cdi.readByte();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return type;
    }

    private static JsonArray parseArray(DataInput di) {
        long elementCount = JsonUtils.parseUint32(di);
        long size = JsonUtils.parseUint32(di);
        byte[] buffer = new byte[Math.toIntExact(size - 8L)];
        JsonUtils.readFully(di, buffer);
        JsonArray jsonArray = new JsonArray();
        int i = 0;
        while ((long)i < elementCount) {
            JsonElement value = JsonUtils.parseValueEntry(buffer, 5 * i);
            jsonArray.add(value);
            ++i;
        }
        return jsonArray;
    }

    private static JsonObject parseObject(DataInput di) {
        long elementCount = JsonUtils.parseUint32(di);
        long size = JsonUtils.parseUint32(di);
        byte[] buffer = new byte[Math.toIntExact(size - 8L)];
        JsonUtils.readFully(di, buffer);
        JsonObject jsonObject = new JsonObject();
        int i = 0;
        while ((long)i < elementCount) {
            KeyEntry keyEntry = JsonUtils.parseKeyEntry(ByteStreams.newDataInput(buffer, i * 6));
            String key = JsonUtils.parseString(ByteStreams.newDataInput(buffer, Math.toIntExact(keyEntry.keyOffset - 8L)), keyEntry.keyLength);
            long valueEntryOffset = elementCount * 6L + (long)(i * 5);
            JsonElement value = JsonUtils.parseValueEntry(buffer, valueEntryOffset);
            jsonObject.add(key, value);
            ++i;
        }
        return jsonObject;
    }

    private static JsonElement parseValueEntry(byte[] buffer, long valueEntryOffset) {
        JsonElement value;
        byte valueType = buffer[Math.toIntExact(valueEntryOffset)];
        ByteArrayDataInput bs = ByteStreams.newDataInput(buffer, Math.toIntExact(valueEntryOffset + 1L));
        switch (valueType) {
            case 4: {
                value = JsonUtils.parseLiteralJson(bs);
                break;
            }
            default: {
                long valueOffset = JsonUtils.parseUint32(bs);
                value = JsonUtils.parseValue(valueType, ByteStreams.newDataInput(buffer, Math.toIntExact(valueOffset - 8L)));
            }
        }
        return value;
    }

    private static JsonElement parseLiteralJson(DataInput di) {
        Boolean bool = JsonUtils.parseLiteral(di);
        JsonElement value = bool == null ? JsonNull.INSTANCE : (bool != false ? JSON_TRUE : JSON_FALSE);
        return value;
    }

    private static KeyEntry parseKeyEntry(DataInput di) {
        return new KeyEntry(JsonUtils.parseUint32(di), JsonUtils.parseUint16(di));
    }

    static class KeyEntry {
        long keyOffset;
        int keyLength;

        KeyEntry(long keyOffset, int keyLength) {
            this.keyOffset = keyOffset;
            this.keyLength = keyLength;
        }
    }
}

