/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import com.pingcap.com.google.common.annotations.VisibleForTesting;
import com.pingcap.com.google.common.base.Preconditions;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.resolver.DirectUriResolver;
import io.etcd.jetcd.resolver.URIResolver;
import io.etcd.jetcd.resolver.URIResolverLoader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.io.grpc.Attributes;
import shade.io.grpc.EquivalentAddressGroup;
import shade.io.grpc.NameResolver;
import shade.io.grpc.Status;
import shade.io.grpc.internal.GrpcUtil;
import shade.io.grpc.internal.SharedResourceHolder;

public class SmartNameResolver
extends NameResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartNameResolver.class);
    private final Object lock = new Object();
    private final String authority;
    private final Collection<URI> uris;
    private final List<URIResolver> resolvers;
    private volatile boolean shutdown;
    private volatile boolean resolving;
    @GuardedBy(value="lock")
    private Executor executor;
    @GuardedBy(value="lock")
    private NameResolver.Listener listener;

    public SmartNameResolver(String authority, Collection<URI> uris, URIResolverLoader loader) {
        this.authority = authority;
        this.uris = uris;
        this.resolvers = new ArrayList<URIResolver>();
        this.resolvers.add(new DirectUriResolver());
        this.resolvers.addAll(loader.load());
        this.resolvers.sort(Comparator.comparingInt(r -> r.priority()));
    }

    @VisibleForTesting
    public List<URIResolver> getResolvers() {
        return Collections.unmodifiableList(this.resolvers);
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(NameResolver.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(this.listener == null, "already started");
            this.executor = SharedResourceHolder.get(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
            this.listener = Preconditions.checkNotNull(listener, "listener");
            this.resolve();
        }
    }

    @Override
    public final synchronized void refresh() {
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor = SharedResourceHolder.release(GrpcUtil.SHARED_CHANNEL_EXECUTOR, this.executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.executor.execute(this::doResolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResolve() {
        NameResolver.Listener savedListener;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.resolving = true;
            savedListener = this.listener;
        }
        try {
            ArrayList<EquivalentAddressGroup> groups = new ArrayList<EquivalentAddressGroup>();
            for (URI uri : this.uris) {
                this.resolvers.stream().filter(r -> r.supports(uri)).limit(1L).flatMap(r -> r.resolve(uri).stream()).map(EquivalentAddressGroup::new).forEach(groups::add);
            }
            if (groups.isEmpty()) {
                throw EtcdExceptionFactory.newEtcdException(ErrorCode.INVALID_ARGUMENT, "Unable to resolve endpoints " + this.uris);
            }
            savedListener.onAddresses(groups, Attributes.EMPTY);
        }
        catch (Exception e) {
            LOGGER.warn("Error wile getting list of servers", (Throwable)e);
            savedListener.onError(Status.NOT_FOUND);
        }
        finally {
            this.resolving = false;
        }
    }
}

