/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import com.pingcap.com.google.common.base.Preconditions;
import io.etcd.jetcd.resolver.SmartNameResolver;
import io.etcd.jetcd.resolver.URIResolverLoader;
import java.net.URI;
import java.util.Collection;
import javax.annotation.Nullable;
import shade.io.grpc.NameResolver;

public class SmartNameResolverFactory
extends NameResolver.Factory {
    private final String authority;
    private final Collection<URI> uris;
    private final URIResolverLoader loader;

    private SmartNameResolverFactory(String authority, Collection<URI> uris, URIResolverLoader loader) {
        Preconditions.checkNotNull(loader, "URIResolverLoader should not be null");
        Preconditions.checkNotNull(authority, "Authority should not be null");
        this.authority = authority;
        this.uris = uris;
        this.loader = loader;
    }

    @Override
    @Nullable
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if ("etcd".equals(targetUri.getScheme())) {
            return new SmartNameResolver(this.authority, this.uris, this.loader);
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return "etcd";
    }

    public static NameResolver.Factory forEndpoints(String authority, Collection<URI> endpoints, URIResolverLoader loader) {
        return new SmartNameResolverFactory(authority, endpoints, loader);
    }
}

