/*
 * Decompiled with CFR 0.152.
 */
package shade.io.grpc.services;

import com.pingcap.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import shade.io.grpc.CallOptions;
import shade.io.grpc.ClientInterceptor;
import shade.io.grpc.ServerInterceptor;
import shade.io.grpc.services.BinaryLogProvider;
import shade.io.grpc.services.BinaryLogSink;
import shade.io.grpc.services.BinlogHelper;
import shade.io.grpc.services.TempFileSink;

class BinaryLogProviderImpl
extends BinaryLogProvider {
    private static final AtomicLong counter = new AtomicLong(1L);
    private final BinlogHelper.Factory factory;
    private final BinaryLogSink sink;

    public BinaryLogProviderImpl() throws IOException {
        this(new TempFileSink(), System.getenv("GRPC_BINARY_LOG_CONFIG"));
    }

    @Deprecated
    public BinaryLogProviderImpl(BinaryLogSink sink) throws IOException {
        this(sink, System.getenv("GRPC_BINARY_LOG_CONFIG"));
    }

    public BinaryLogProviderImpl(BinaryLogSink sink, String configStr) throws IOException {
        this.sink = Preconditions.checkNotNull(sink);
        try {
            this.factory = new BinlogHelper.FactoryImpl(sink, configStr);
        }
        catch (RuntimeException e) {
            sink.close();
            throw new IOException("Can not initialize. The env variable GRPC_BINARY_LOG_CONFIG must be valid.", e);
        }
    }

    @Override
    @Nullable
    public ServerInterceptor getServerInterceptor(String fullMethodName) {
        BinlogHelper helperForMethod = this.factory.getLog(fullMethodName);
        if (helperForMethod == null) {
            return null;
        }
        return helperForMethod.getServerInterceptor(counter.getAndIncrement());
    }

    @Override
    @Nullable
    public ClientInterceptor getClientInterceptor(String fullMethodName, CallOptions callOptions) {
        BinlogHelper helperForMethod = this.factory.getLog(fullMethodName);
        if (helperForMethod == null) {
            return null;
        }
        return helperForMethod.getClientInterceptor(counter.getAndIncrement());
    }

    @Override
    public void close() throws IOException {
        this.sink.close();
    }
}

