/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.pingcap.tikv.Snapshot;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.TiFlashClient;
import com.pingcap.tikv.catalog.Catalog;
import com.pingcap.tikv.meta.Collation;
import com.pingcap.tikv.util.ConvertUpstreamUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.tikv.common.TiSession;
import org.tikv.common.event.CacheInvalidateEvent;
import org.tikv.common.meta.TiTimestamp;

public class ClientSession
implements AutoCloseable {
    private static final Map<String, ClientSession> sessionCachedMap = new HashMap<String, ClientSession>();
    private final TiConfiguration conf;
    private final TiSession tiKVSession;
    private volatile Catalog catalog;
    private Function<CacheInvalidateEvent, Void> cacheInvalidateCallback;
    private volatile boolean isClosed = false;
    private volatile TiTimestamp snapshotTimestamp;
    private volatile Catalog snapshotCatalog;
    private volatile Map<String, Boolean> storeStatusCache;
    private ScheduledExecutorService storeStatusCacheExecutor;

    public void injectCallBackFunc(Function<CacheInvalidateEvent, Void> callBackFunc) {
        this.checkIsClosed();
        this.cacheInvalidateCallback = callBackFunc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Catalog getCatalog() {
        Catalog res = this.catalog;
        if (res == null) {
            ClientSession clientSession = this;
            synchronized (clientSession) {
                if (this.catalog == null) {
                    this.catalog = new Catalog(this::createSnapshot, this.getConf().isShowRowId(), this.getConf().getDBPrefix(), this.getConf().getLoadTables());
                }
                res = this.catalog;
            }
        }
        return res;
    }

    private ClientSession(TiConfiguration config) {
        this.conf = config != null ? config : TiConfiguration.createDefault("127.0.0.1:2379");
        this.tiKVSession = TiSession.create(ConvertUpstreamUtils.convertTiConfiguration(this.getConf()));
        this.refreshNewCollationEnabled();
    }

    private void refreshNewCollationEnabled() {
        if (!this.conf.getNewCollationEnable().isPresent()) {
            if (ConvertUpstreamUtils.isTiKVVersionGreatEqualThanVersion(this.getTiKVSession().getPDClient(), "6.0.0")) {
                Collation.setNewCollationEnabled(true);
            } else {
                Collation.setNewCollationEnabled(false);
            }
        }
    }

    private void checkIsClosed() {
        if (this.isClosed) {
            throw new RuntimeException("this TiSession is closed!");
        }
    }

    public Snapshot createSnapshot() {
        this.checkIsClosed();
        return new Snapshot(this.tiKVSession.getTimestamp(), this);
    }

    public Snapshot createSnapshot(TiTimestamp ts) {
        this.checkIsClosed();
        return new Snapshot(ts, this);
    }

    public synchronized Catalog getOrCreateSnapShotCatalog(TiTimestamp ts) {
        this.checkIsClosed();
        this.snapshotTimestamp = ts;
        if (this.snapshotCatalog == null) {
            this.snapshotCatalog = new Catalog(this::createSnapshotWithSnapshotTimestamp, this.conf.isShowRowId(), this.conf.getDBPrefix(), this.conf.getLoadTables());
        }
        return this.snapshotCatalog;
    }

    public Snapshot createSnapshotWithSnapshotTimestamp() {
        this.checkIsClosed();
        return new Snapshot(this.snapshotTimestamp, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientSession getInstance(TiConfiguration config) {
        Map<String, ClientSession> map = sessionCachedMap;
        synchronized (map) {
            String key = config.getPdAddrsString();
            if (sessionCachedMap.containsKey(key)) {
                return sessionCachedMap.get(key);
            }
            ClientSession newSession = new ClientSession(config);
            sessionCachedMap.put(key, newSession);
            return newSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Boolean> getStoreStatusCache() {
        if (this.storeStatusCache == null) {
            ClientSession clientSession = this;
            synchronized (clientSession) {
                if (this.storeStatusCache == null) {
                    this.storeStatusCache = new ConcurrentHashMap<String, Boolean>();
                    this.storeStatusCacheExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("storeStatus-thread-%d").setDaemon(true).build());
                    this.storeStatusCacheExecutor.scheduleAtFixedRate(() -> this.storeStatusCache.replaceAll((k, v) -> TiFlashClient.isMppAlive(this.tiKVSession.getChannelFactory().getChannel((String)k, this.tiKVSession.getPDClient().getHostMapping()), this.conf.getHealthCheckTimeout())), 0L, this.conf.getHealthCheckPeriod(), TimeUnit.MILLISECONDS);
                }
            }
        }
        return this.storeStatusCache;
    }

    @Override
    public void close() throws Exception {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shutdown() throws Exception {
        if (this.tiKVSession != null) {
            this.tiKVSession.close();
        }
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.snapshotCatalog != null) {
                this.snapshotCatalog.close();
            }
            if (this.storeStatusCacheExecutor != null) {
                this.storeStatusCacheExecutor.shutdownNow();
            }
            Map<String, ClientSession> map = sessionCachedMap;
            synchronized (map) {
                sessionCachedMap.remove(this.conf.getPdAddrsString());
            }
        }
    }

    public TiConfiguration getConf() {
        return this.conf;
    }

    public TiSession getTiKVSession() {
        return this.tiKVSession;
    }

    public Function<CacheInvalidateEvent, Void> getCacheInvalidateCallback() {
        return this.cacheInvalidateCallback;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public TiTimestamp getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    public Catalog getSnapshotCatalog() {
        return this.snapshotCatalog;
    }

    public ScheduledExecutorService getStoreStatusCacheExecutor() {
        return this.storeStatusCacheExecutor;
    }
}

