/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.replica.Region;
import org.tikv.common.replica.ReplicaSelector;
import org.tikv.common.replica.Store;

public class ReplicaReadPolicy
implements ReplicaSelector {
    static final Logger LOG = LoggerFactory.getLogger(ReplicaReadPolicy.class);
    public static final ReplicaReadPolicy DEFAULT = ReplicaReadPolicy.create("leader", "", "", "");
    private final Map<String, String> labels;
    private final Set<String> whitelist;
    private final Set<String> blacklist;
    private final List<Role> roles;

    private ReplicaReadPolicy(Map<String, String> labels, Set<String> whitelist, Set<String> blacklist, List<Role> roles) {
        this.labels = labels;
        this.whitelist = whitelist;
        this.blacklist = blacklist;
        this.roles = roles;
    }

    @Override
    public List<Store> select(Region region) {
        Store leader = region.getLeader();
        Store[] stores = region.getStores();
        List followers = Arrays.stream(stores).filter(store -> store.isFollower() && this.accept((Store)store)).collect(Collectors.toList());
        List learners = Arrays.stream(stores).filter(store -> store.isLearner() && this.accept((Store)store)).collect(Collectors.toList());
        Collections.shuffle(followers);
        Collections.shuffle(learners);
        ArrayList<Store> candidates = new ArrayList<Store>(stores.length);
        block5: for (Role role : this.roles) {
            switch (role) {
                case LEADER: {
                    candidates.add(leader);
                    continue block5;
                }
                case FOLLOWER: {
                    candidates.addAll(followers);
                    continue block5;
                }
                case LEARNER: {
                    candidates.addAll(learners);
                    continue block5;
                }
            }
        }
        if (candidates.size() == 0) {
            throw new IllegalStateException("Can not get enough candidates");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Current candidates are: {}", candidates);
        }
        return candidates;
    }

    private static Map<String, String> extractLabels(String label) {
        Object[] labels = label.split(",");
        HashMap<String, String> map = new HashMap<String, String>(labels.length);
        for (String string : labels) {
            String value;
            String key;
            if (string.isEmpty()) continue;
            String[] pairs = string.trim().split("=");
            if (pairs.length != 2 || (key = pairs[0].trim()).isEmpty() || (value = pairs[1].trim()).isEmpty()) {
                throw new IllegalArgumentException("Invalid replica read labels: " + Arrays.toString(labels));
            }
            map.put(key, value);
        }
        return map;
    }

    private static Set<String> extractList(String list) {
        return Arrays.stream(list.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    public static ReplicaReadPolicy create(String role, String label, String whitelist, String blacklist) {
        Map<String, String> labels = ReplicaReadPolicy.extractLabels(label);
        Set<String> whitelists = ReplicaReadPolicy.extractList(whitelist);
        Set<String> blacklists = ReplicaReadPolicy.extractList(blacklist);
        List<Role> roles = Arrays.stream(role.split(",")).map(Role::fromString).collect(Collectors.toList());
        return new ReplicaReadPolicy(labels, whitelists, blacklists, roles);
    }

    private boolean inWhitelist(Store store) {
        if (this.whitelist.isEmpty()) {
            return false;
        }
        return this.whitelist.stream().anyMatch(a -> a.equals(store.getAddress()));
    }

    private boolean notInBlacklist(Store store) {
        if (this.blacklist.isEmpty()) {
            return true;
        }
        return this.blacklist.stream().noneMatch(a -> a.equals(store.getAddress()));
    }

    private boolean matchLabels(Store store) {
        if (this.labels.isEmpty()) {
            return true;
        }
        int matched = 0;
        for (Store.Label label : store.getLabels()) {
            if (!label.getValue().equals(this.labels.get(label.getKey()))) continue;
            ++matched;
        }
        return matched == this.labels.size();
    }

    protected boolean accept(Store store) {
        return (this.matchLabels(store) || this.inWhitelist(store)) && this.notInBlacklist(store);
    }

    static enum Role {
        LEADER,
        FOLLOWER,
        LEARNER;


        public static Role fromString(String role) {
            for (Role value : Role.values()) {
                if (!value.name().equalsIgnoreCase(role)) continue;
                return value;
            }
            throw new IllegalArgumentException("Available roles are: " + Arrays.toString((Object[])Role.values()));
        }
    }
}

