/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.tikv.ClientSession;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.columnar.TiChunk;
import com.pingcap.tikv.handle.Handle;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.operation.iterator.ConcreteScanIterator;
import com.pingcap.tikv.operation.iterator.CoprocessorIterator;
import com.pingcap.tikv.operation.iterator.IndexScanIterator;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.util.RangeSplitter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.tikv.common.BytePairWrapper;
import org.tikv.common.TiSession;
import org.tikv.common.meta.TiTimestamp;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.RangeSplitter;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.txn.KVClient;

public class Snapshot {
    private final TiTimestamp timestamp;
    private final ClientSession clientSession;

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public Snapshot(@Nonnull TiTimestamp timestamp, ClientSession clientSession) {
        this.timestamp = timestamp;
        this.clientSession = clientSession;
    }

    public TiSession getSession() {
        return this.clientSession.getTiKVSession();
    }

    public long getVersion() {
        return this.timestamp.getVersion();
    }

    public TiTimestamp getTimestamp() {
        return this.timestamp;
    }

    public byte[] get(byte[] key) {
        ByteString keyString = ByteString.copyFrom(key);
        ByteString value = this.get(keyString);
        return value.toByteArray();
    }

    public ByteString get(ByteString key) {
        try (KVClient client = new KVClient(this.getSession().getConf(), this.getSession().getRegionStoreClientBuilder(), this.getSession());){
            ByteString byteString = client.get(key, this.timestamp.getVersion());
            return byteString;
        }
    }

    public List<BytePairWrapper> batchGet(int backOffer, List<byte[]> keys) {
        ArrayList<ByteString> list = new ArrayList<ByteString>();
        for (byte[] key : keys) {
            list.add(ByteString.copyFrom(key));
        }
        try (KVClient client = new KVClient(this.getSession().getConf(), this.getSession().getRegionStoreClientBuilder(), this.getSession());){
            List<Kvrpcpb.KvPair> kvPairList = client.batchGet(ConcreteBackOffer.newCustomBackOff(backOffer), list, this.timestamp.getVersion());
            List<BytePairWrapper> list2 = kvPairList.stream().map(kvPair -> new BytePairWrapper(kvPair.getKey().toByteArray(), kvPair.getValue().toByteArray())).collect(Collectors.toList());
            return list2;
        }
    }

    public Iterator<TiChunk> tableReadChunk(TiDAGRequest dagRequest, List<RangeSplitter.RegionTask> tasks, int numOfRows) {
        if (dagRequest.isDoubleRead()) {
            throw new UnsupportedOperationException("double read case should first read handle in row-wise fashion");
        }
        return CoprocessorIterator.getTiChunkIterator(dagRequest, tasks, this.getClientSession(), numOfRows);
    }

    public Iterator<Row> tableReadRow(TiDAGRequest dagRequest, long physicalId) {
        return this.tableReadRow(dagRequest, RangeSplitter.newSplitter(this.getSession().getRegionManager()).splitRangeByRegion(dagRequest.getRangesByPhysicalId(physicalId), dagRequest.getStoreType()));
    }

    private Iterator<Row> tableReadRow(TiDAGRequest dagRequest, List<RangeSplitter.RegionTask> tasks) {
        if (dagRequest.isDoubleRead()) {
            CoprocessorIterator<Handle> iter = CoprocessorIterator.getHandleIterator(dagRequest, tasks, this.getClientSession());
            return new IndexScanIterator(this, dagRequest, iter);
        }
        return CoprocessorIterator.getRowIterator(dagRequest, tasks, this.getClientSession());
    }

    public Iterator<Handle> indexHandleRead(TiDAGRequest dagRequest, List<RangeSplitter.RegionTask> tasks) {
        return CoprocessorIterator.getHandleIterator(dagRequest, tasks, this.getClientSession());
    }

    public Iterator<Kvrpcpb.KvPair> scanPrefix(ByteString prefix) {
        ByteString nextPrefix = Key.toRawKey(prefix).nextPrefix().toByteString();
        return new ConcreteScanIterator(this.clientSession.getConf(), this.getSession().getRegionStoreClientBuilder(), prefix, nextPrefix, this.timestamp.getVersion());
    }

    public TiConfiguration getConf() {
        return this.clientSession.getConf();
    }
}

