/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.AbstractGRPCClient;
import org.tikv.common.PDClient;
import org.tikv.common.TiConfiguration;
import org.tikv.common.region.TiStore;
import org.tikv.common.util.ChannelFactory;
import org.tikv.kvproto.Mpp;
import org.tikv.kvproto.TikvGrpc;
import org.tikv.shade.io.grpc.ManagedChannel;
import org.tikv.shade.io.grpc.stub.ClientCalls;

public class TiFlashClient
extends AbstractGRPCClient<TikvGrpc.TikvBlockingStub, TikvGrpc.TikvFutureStub> {
    private static final Logger logger = LoggerFactory.getLogger(TiFlashClient.class);
    protected final PDClient pdClient;
    protected TiStore store;

    public TiFlashClient(TiConfiguration conf, TiStore store, ChannelFactory channelFactory, PDClient pdClient) {
        super(conf, channelFactory);
        this.pdClient = pdClient;
        this.store = store;
        String addressStr = store.getStore().getAddress();
        ManagedChannel channel = channelFactory.getChannel(addressStr, pdClient.getHostMapping());
        this.blockingStub = TikvGrpc.newBlockingStub(channel);
        this.asyncStub = TikvGrpc.newFutureStub(channel);
    }

    @Override
    protected TikvGrpc.TikvBlockingStub getBlockingStub() {
        return (TikvGrpc.TikvBlockingStub)((TikvGrpc.TikvBlockingStub)this.blockingStub).withDeadlineAfter(this.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected TikvGrpc.TikvFutureStub getAsyncStub() {
        return (TikvGrpc.TikvFutureStub)((TikvGrpc.TikvFutureStub)this.asyncStub).withDeadlineAfter(this.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws Exception {
    }

    public static boolean isMppAlive(ManagedChannel channel, int timeout) {
        TikvGrpc.TikvBlockingStub stub = (TikvGrpc.TikvBlockingStub)TikvGrpc.newBlockingStub(channel).withDeadlineAfter(timeout, TimeUnit.MILLISECONDS);
        Supplier<Mpp.IsAliveRequest> factory = () -> Mpp.IsAliveRequest.newBuilder().build();
        try {
            Mpp.IsAliveResponse resp = ClientCalls.blockingUnaryCall(stub.getChannel(), TikvGrpc.getIsAliveMethod(), stub.getCallOptions(), factory.get());
            return resp != null && resp.getAvailable();
        }
        catch (Exception e) {
            logger.warn("Call mpp isAlive fail with Exception", (Throwable)e);
            return false;
        }
    }
}

