/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.allocator;

import com.pingcap.tikv.ClientSession;
import com.pingcap.tikv.Snapshot;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.codec.MetaCodec;
import com.pingcap.tikv.meta.TiTableInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.BytePairWrapper;
import org.tikv.common.TiSession;
import org.tikv.common.exception.AllocateRowIDOverflowException;
import org.tikv.common.exception.TiBatchWriteException;
import org.tikv.common.meta.TiTimestamp;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.shade.com.google.common.primitives.UnsignedLongs;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.txn.TwoPhaseCommitter;

public final class RowIDAllocator
implements Serializable {
    private final long shardBits;
    private final boolean isUnsigned;
    private final long dbId;
    private final TiConfiguration conf;
    private final long step;
    private long end;
    private final long autoRandomPartition;
    private final RowIDAllocatorType allocatorType;
    private final long RowIDAllocatorTTL = 10000L;
    private static final Logger LOG = LoggerFactory.getLogger(RowIDAllocator.class);

    private RowIDAllocator(long shardBits, boolean isUnsigned, long dbId, long step, TiConfiguration conf, TiTimestamp timestamp, RowIDAllocatorType allocatorType) {
        this.shardBits = shardBits;
        this.isUnsigned = isUnsigned;
        this.dbId = dbId;
        this.step = step;
        this.conf = conf;
        this.autoRandomPartition = new Random(timestamp.getVersion()).nextLong();
        this.allocatorType = allocatorType;
    }

    public long getAutoIncId(long index) {
        return index + this.getStart();
    }

    public long getShardRowId(long index) {
        return RowIDAllocator.getShardRowId(this.shardBits, index, index + this.getStart(), this.isUnsigned);
    }

    public long getAutoRandomId(long index) {
        return RowIDAllocator.getShardRowId(this.shardBits, this.autoRandomPartition, index + this.getStart(), this.isUnsigned);
    }

    static long getShardRowId(long shardBits, long partitionIndex, long rowID, boolean isUnsigned) {
        if (shardBits <= 0L || shardBits >= 16L) {
            return rowID;
        }
        int signBitLength = isUnsigned ? 0 : 1;
        long partition = partitionIndex & (1L << (int)shardBits) - 1L;
        return rowID | partition << (int)(64L - shardBits - (long)signBitLength);
    }

    public static RowIDAllocator createRowIDAllocator(long dbId, TiTableInfo tableInfo, TiConfiguration conf, long step, TiTimestamp timestamp, RowIDAllocatorType allocatorType) {
        long shardBits = 0L;
        boolean isUnsigned = false;
        switch (allocatorType) {
            case AUTO_INCREMENT: {
                isUnsigned = tableInfo.isAutoIncColUnsigned();
                break;
            }
            case AUTO_RANDOM: {
                isUnsigned = tableInfo.isAutoRandomColUnsigned();
                shardBits = tableInfo.getAutoRandomBits();
                break;
            }
            case IMPLICIT_ROWID: {
                shardBits = tableInfo.getMaxShardRowIDBits();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported RowIDAllocatorType: " + (Object)((Object)allocatorType));
            }
        }
        return RowIDAllocator.create(dbId, tableInfo, conf, timestamp, isUnsigned, shardBits, step, allocatorType);
    }

    public static RowIDAllocator create(long dbId, TiTableInfo table, TiConfiguration conf, TiTimestamp timestamp, boolean unsigned, long shardBits, long step, RowIDAllocatorType allocatorType) {
        ConcreteBackOffer backOffer = ConcreteBackOffer.newCustomBackOff(40000);
        while (true) {
            try {
                return RowIDAllocator.doCreate(dbId, table, conf, timestamp, unsigned, shardBits, step, allocatorType);
            }
            catch (IllegalArgumentException | AllocateRowIDOverflowException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("error during allocating row id", (Throwable)e);
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoServerBusy, e);
                continue;
            }
            break;
        }
    }

    private static RowIDAllocator doCreate(long dbId, TiTableInfo table, TiConfiguration conf, TiTimestamp timestamp, boolean unsigned, long shardBits, long step, RowIDAllocatorType allocatorType) {
        RowIDAllocator allocator = new RowIDAllocator(shardBits, unsigned, dbId, step, conf, timestamp, allocatorType);
        if (unsigned) {
            allocator.initUnsigned(ClientSession.getInstance(conf).createSnapshot(), table.getId(), shardBits);
        } else {
            allocator.initSigned(ClientSession.getInstance(conf).createSnapshot(), table.getId(), shardBits);
        }
        return allocator;
    }

    public long getStart() {
        return this.end - this.step;
    }

    public long getEnd() {
        return this.end;
    }

    private void set(@Nonnull List<BytePairWrapper> pairs, @Nonnull TiTimestamp timestamp) {
        Iterator<BytePairWrapper> iterator = pairs.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        TiSession session = ClientSession.getInstance(this.conf).getTiKVSession();
        TwoPhaseCommitter twoPhaseCommitter = new TwoPhaseCommitter(session, timestamp.getVersion(), 10000L);
        BytePairWrapper primaryPair = iterator.next();
        twoPhaseCommitter.prewritePrimaryKey(ConcreteBackOffer.newCustomBackOff(20000), primaryPair.getKey(), primaryPair.getValue());
        if (iterator.hasNext()) {
            twoPhaseCommitter.prewriteSecondaryKeys(primaryPair.getKey(), iterator, 20000);
        }
        twoPhaseCommitter.commitPrimaryKey(ConcreteBackOffer.newCustomBackOff(10000), primaryPair.getKey(), session.getTimestamp().getVersion());
        try {
            twoPhaseCommitter.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Optional<BytePairWrapper> getMetaToUpdate(ByteString key, byte[] oldVal, Snapshot snapshot) {
        CodecDataOutput cdo = new CodecDataOutput();
        ByteString metaKey = MetaCodec.encodeHashMetaKey(cdo, key.toByteArray());
        long fieldCount = 0L;
        ByteString metaVal = snapshot.get(metaKey);
        if (!metaVal.isEmpty()) {
            try {
                fieldCount = Codec.IntegerCodec.readULong(new CodecDataInput(metaVal.toByteArray()));
            }
            catch (Exception ignored) {
                LOG.warn("metaDecode failed, field is ignored." + KeyUtils.formatBytesUTF8(metaVal));
            }
        }
        if (oldVal == null || oldVal.length == 0) {
            cdo.reset();
            cdo.writeLong(++fieldCount);
            return Optional.of(new BytePairWrapper(metaKey.toByteArray(), cdo.toBytes()));
        }
        return Optional.empty();
    }

    private long updateHash(ByteString key, ByteString field, Function<byte[], byte[]> calculateNewVal, Snapshot snapshot) {
        CodecDataOutput cdo = new CodecDataOutput();
        MetaCodec.encodeHashDataKey(cdo, key.toByteArray(), field.toByteArray());
        ByteString dataKey = cdo.toByteString();
        byte[] oldVal = snapshot.get(dataKey.toByteArray());
        byte[] newVal = calculateNewVal.apply(oldVal);
        if (Arrays.equals(newVal, oldVal)) {
            return 0L;
        }
        ArrayList<BytePairWrapper> pairs = new ArrayList<BytePairWrapper>(2);
        pairs.add(new BytePairWrapper(dataKey.toByteArray(), newVal));
        this.getMetaToUpdate(key, oldVal, snapshot).ifPresent(pairs::add);
        this.set(pairs, snapshot.getTimestamp());
        return Long.parseLong(new String(newVal));
    }

    private static boolean isDBExisted(long dbId, Snapshot snapshot) {
        ByteString dbKey = MetaCodec.encodeDatabaseID(dbId);
        ByteString json = MetaCodec.hashGet(MetaCodec.KEY_DBs, dbKey, snapshot);
        return json != null && !json.isEmpty();
    }

    private static boolean isTableExisted(long dbId, long tableId, Snapshot snapshot) {
        ByteString tableKey;
        ByteString dbKey = MetaCodec.encodeDatabaseID(dbId);
        return !MetaCodec.hashGet(dbKey, tableKey = MetaCodec.tableKey(tableId), snapshot).isEmpty();
    }

    public static boolean shardRowBitsOverflow(long base, long step, long shardRowBits, boolean reservedSignBit) {
        long signBit = reservedSignBit ? 1L : 0L;
        long mask = (1L << (int)shardRowBits) - 1L << (int)(64L - shardRowBits - signBit);
        if (reservedSignBit) {
            return (base + step & mask) > 0L;
        }
        return Long.compareUnsigned(base + step & mask, 0L) > 0;
    }

    public long updateAllocateId(long dbId, long tableId, long step, Snapshot snapshot, long shard, boolean hasSignedBit) {
        if (RowIDAllocator.isDBExisted(dbId, snapshot) && RowIDAllocator.isTableExisted(dbId, tableId, snapshot)) {
            ByteString idField = RowIDAllocator.getIdField(tableId, this.allocatorType);
            return this.updateHash(MetaCodec.encodeDatabaseID(dbId), idField, oldVal -> {
                long base = 0L;
                if (oldVal != null && ((byte[])oldVal).length != 0) {
                    base = Long.parseLong(new String((byte[])oldVal));
                }
                if (shard >= 1L && RowIDAllocator.shardRowBitsOverflow(base, step, shard, hasSignedBit)) {
                    throw new AllocateRowIDOverflowException(base, step, shard);
                }
                return String.valueOf(base += step).getBytes();
            }, snapshot);
        }
        throw new IllegalArgumentException("table or database is not existed");
    }

    public static ByteString getIdField(long tableId, RowIDAllocatorType allocatorType) {
        switch (allocatorType) {
            case AUTO_INCREMENT: 
            case IMPLICIT_ROWID: {
                return MetaCodec.autoTableIDKey(tableId);
            }
            case AUTO_RANDOM: {
                return MetaCodec.autoRandomTableIDKey(tableId);
            }
        }
        throw new IllegalArgumentException("Unsupported RowIDAllocatorType: " + (Object)((Object)allocatorType));
    }

    public static long getAllocateId(long dbId, long tableId, Snapshot snapshot, RowIDAllocatorType allocatorType) {
        if (RowIDAllocator.isDBExisted(dbId, snapshot) && RowIDAllocator.isTableExisted(dbId, tableId, snapshot)) {
            ByteString idField;
            ByteString dbKey = MetaCodec.encodeDatabaseID(dbId);
            ByteString val = MetaCodec.hashGet(dbKey, idField = RowIDAllocator.getIdField(tableId, allocatorType), snapshot);
            if (val.isEmpty()) {
                return 0L;
            }
            return Long.parseLong(val.toStringUtf8());
        }
        throw new IllegalArgumentException("table or database is not existed");
    }

    private void initSigned(Snapshot snapshot, long tableId, long shard) {
        long newStart = RowIDAllocator.getAllocateId(this.dbId, tableId, snapshot, this.allocatorType);
        long tmpStep = Math.min(Long.MAX_VALUE - newStart, this.step);
        if (tmpStep != this.step) {
            throw new TiBatchWriteException("cannot allocate ids for this write");
        }
        if (newStart == Long.MAX_VALUE) {
            throw new TiBatchWriteException("cannot allocate more ids since it ");
        }
        this.end = this.updateAllocateId(this.dbId, tableId, tmpStep, snapshot, shard, true);
    }

    private void initUnsigned(Snapshot snapshot, long tableId, long shard) {
        long newStart = RowIDAllocator.getAllocateId(this.dbId, tableId, snapshot, this.allocatorType);
        long tmpStep = UnsignedLongs.min(-1L - newStart, this.step);
        if (tmpStep != this.step) {
            throw new TiBatchWriteException("cannot allocate ids for this write");
        }
        if (UnsignedLongs.compare(newStart, -1L) == 0) {
            throw new TiBatchWriteException("cannot allocate more ids since the start reaches unsigned long's max value ");
        }
        this.end = this.updateAllocateId(this.dbId, tableId, tmpStep, snapshot, shard, false);
    }

    public static enum RowIDAllocatorType {
        AUTO_INCREMENT,
        AUTO_RANDOM,
        IMPLICIT_ROWID;

    }
}

