/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.codec;

import com.pingcap.tikv.key.Key;
import org.tikv.kvproto.Coprocessor;
import org.tikv.shade.com.google.common.primitives.UnsignedBytes;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.shade.com.google.protobuf.TextFormat;

public class KeyUtils {
    public static Key getEncodedKey(ByteString key) {
        if (key.isEmpty()) {
            return Key.toRawKey(key, true);
        }
        return Key.toRawKey(key);
    }

    public static String formatBytes(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int unsignedByte = UnsignedBytes.toInt(bytes[i]);
            sb.append(unsignedByte);
            if (i == bytes.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String formatBytes(ByteString bytes) {
        if (bytes == null) {
            return "null";
        }
        return KeyUtils.formatBytes(bytes.toByteArray());
    }

    public static String formatBytes(Coprocessor.KeyRange keyRange) {
        return "([" + KeyUtils.formatBytes(keyRange.getStart()) + "], [" + KeyUtils.formatBytes(keyRange.getEnd()) + "])";
    }

    public static String formatBytesUTF8(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        return TextFormat.escapeBytes(bytes);
    }

    public static String formatBytesUTF8(ByteString bytes) {
        if (bytes == null) {
            return "null";
        }
        return KeyUtils.formatBytesUTF8(bytes.toByteArray());
    }

    public static String formatBytesUTF8(Coprocessor.KeyRange keyRange) {
        return "([" + KeyUtils.formatBytesUTF8(keyRange.getStart()) + "], [" + KeyUtils.formatBytesUTF8(keyRange.getEnd()) + "])";
    }

    public static boolean hasPrefix(ByteString str, ByteString prefix) {
        if (prefix.size() > str.size()) {
            return false;
        }
        for (int i = 0; i < prefix.size(); ++i) {
            if (str.byteAt(i) == prefix.byteAt(i)) continue;
            return false;
        }
        return true;
    }
}

