/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.codec;

import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataInputLittleEndian;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.codec.ExtendedDateTime;
import com.pingcap.tikv.types.Converter;
import com.pingcap.tikv.types.DataType;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTimeZone;
import org.tikv.common.exception.CodecException;
import org.tikv.common.util.JsonUtils;

public class RowDecoderV2 {
    private static final long SIGN_MASK = Long.MIN_VALUE;

    public static Object decodeCol(byte[] colData, DataType tp) {
        switch (tp.getType()) {
            case TypeLonglong: 
            case TypeLong: 
            case TypeInt24: 
            case TypeShort: 
            case TypeTiny: {
                return RowDecoderV2.decodeInt(colData);
            }
            case TypeFloat: {
                return Float.valueOf(RowDecoderV2.decodeFloat(colData));
            }
            case TypeDouble: {
                return RowDecoderV2.decodeDouble(colData);
            }
            case TypeString: 
            case TypeVarString: 
            case TypeVarchar: {
                return new String(colData, StandardCharsets.UTF_8);
            }
            case TypeBlob: 
            case TypeTinyBlob: 
            case TypeMediumBlob: 
            case TypeLongBlob: {
                return colData;
            }
            case TypeNewDecimal: {
                return RowDecoderV2.decodeDecimal(colData);
            }
            case TypeBit: {
                int byteSize = (int)(tp.getLength() + 7L >>> 3);
                return RowDecoderV2.decodeBit(RowDecoderV2.decodeInt(colData), byteSize);
            }
            case TypeDate: {
                return new Date(RowDecoderV2.decodeTimestamp(colData, Converter.getLocalTimezone()).getTime());
            }
            case TypeDatetime: {
                return RowDecoderV2.decodeTimestamp(colData, Converter.getLocalTimezone());
            }
            case TypeTimestamp: {
                return RowDecoderV2.decodeTimestamp(colData, DateTimeZone.UTC);
            }
            case TypeDuration: 
            case TypeYear: {
                return RowDecoderV2.decodeInt(colData);
            }
            case TypeEnum: {
                return RowDecoderV2.decodeEnum(colData, tp.getElems());
            }
            case TypeSet: {
                return RowDecoderV2.decodeSet(colData, tp.getElems());
            }
            case TypeJSON: {
                return RowDecoderV2.decodeJson(colData);
            }
            case TypeNull: {
                return null;
            }
            case TypeDecimal: 
            case TypeGeometry: 
            case TypeNewDate: {
                throw new CodecException("type should not appear in colData");
            }
        }
        throw new CodecException("invalid data type " + tp.getType().name());
    }

    private static long decodeInt(byte[] val) {
        switch (val.length) {
            case 1: {
                return val[0];
            }
            case 2: {
                return new CodecDataInputLittleEndian(val).readShort();
            }
            case 4: {
                return new CodecDataInputLittleEndian(val).readInt();
            }
        }
        return new CodecDataInputLittleEndian(val).readLong();
    }

    private static float decodeFloat(byte[] val) {
        return (float)RowDecoderV2.decodeDouble(val);
    }

    private static double decodeDouble(byte[] val) {
        CodecDataInput cdi = new CodecDataInput(val);
        if (val.length < 8) {
            throw new CodecException("insufficient bytes to decode value");
        }
        long u = cdi.readLong();
        u = (u & Long.MIN_VALUE) < 0L ? (u &= Long.MAX_VALUE) : (u ^= 0xFFFFFFFFFFFFFFFFL);
        return Double.longBitsToDouble(u);
    }

    private static BigDecimal decodeDecimal(byte[] val) {
        return Codec.DecimalCodec.readDecimal(new CodecDataInputLittleEndian(val));
    }

    private static byte[] trimLeadingZeroBytes(byte[] bytes) {
        int pos;
        if (bytes.length == 0) {
            return bytes;
        }
        int posMax = bytes.length - 1;
        for (pos = 0; pos < posMax && bytes[pos] == 0; ++pos) {
        }
        return Arrays.copyOfRange(bytes, pos, bytes.length);
    }

    private static byte[] decodeBit(long val, int byteSize) {
        if (byteSize != -1 && (byteSize < 1 || byteSize > 8)) {
            throw new CodecException("Invalid byteSize " + byteSize);
        }
        CodecDataOutput cdo = new CodecDataOutput();
        cdo.writeLong(val);
        if (byteSize != -1) {
            return RowDecoderV2.trimLeadingZeroBytes(cdo.toBytes());
        }
        return Arrays.copyOfRange(cdo.toBytes(), 8 - byteSize, 8);
    }

    private static Timestamp decodeTimestamp(byte[] val, DateTimeZone tz) {
        ExtendedDateTime extendedDateTime = Codec.DateTimeCodec.fromPackedLong(new CodecDataInputLittleEndian(val).readLong(), tz);
        if (extendedDateTime == null) {
            return Codec.DateTimeCodec.createExtendedDateTime(tz, 1, 1, 1, 0, 0, 0, 0).toTimeStamp();
        }
        return extendedDateTime.toTimeStamp();
    }

    private static String decodeEnum(byte[] val, List<String> elems) {
        int idx = (int)RowDecoderV2.decodeInt(val) - 1;
        return Codec.EnumCodec.readEnumFromIndex(idx, elems);
    }

    private static String decodeSet(byte[] val, List<String> elems) {
        long number = RowDecoderV2.decodeInt(val);
        return Codec.SetCodec.readSetFromLong(number, elems);
    }

    private static String decodeJson(byte[] val) {
        return JsonUtils.parseJson(new CodecDataInput(val)).toString();
    }
}

