/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.codec;

import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.codec.RowEncoderV2;
import com.pingcap.tikv.codec.RowV2;
import com.pingcap.tikv.codec.TableCodecV1;
import com.pingcap.tikv.codec.TableCodecV2;
import com.pingcap.tikv.handle.CommonHandle;
import com.pingcap.tikv.handle.Handle;
import com.pingcap.tikv.handle.IntHandle;
import com.pingcap.tikv.meta.Collation;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiIndexColumn;
import com.pingcap.tikv.meta.TiIndexInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.types.BytesType;
import com.pingcap.tikv.types.Converter;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.MySQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tikv.common.exception.CodecException;

public class TableCodec {
    public static byte MaxOldEncodeValueLen = (byte)9;
    public static byte IndexVersionFlag = (byte)125;
    public static byte PartitionIDFlag = (byte)126;
    public static byte CommonHandleFlag = (byte)127;
    public static byte RestoreDataFlag = (byte)RowV2.CODEC_VER;

    public static byte[] encodeRow(List<TiColumnInfo> columnInfos, Object[] values, boolean isPkHandle, boolean encodeWithNewRowFormat) throws IllegalAccessException {
        if (columnInfos.size() != values.length) {
            throw new IllegalAccessException(String.format("encodeRow error: data and columnID count not match %d vs %d", columnInfos.size(), values.length));
        }
        if (encodeWithNewRowFormat) {
            return TableCodecV2.encodeRow(columnInfos, values, isPkHandle);
        }
        return TableCodecV1.encodeRow(columnInfos, values, isPkHandle);
    }

    public static Row decodeRow(byte[] value, Handle handle, TiTableInfo tableInfo) {
        if (value.length == 0) {
            throw new CodecException("Decode fails: value length is zero");
        }
        if ((value[0] & 0xFF) == RowV2.CODEC_VER) {
            return TableCodecV2.decodeRow(value, handle, tableInfo);
        }
        return TableCodecV1.decodeRow(value, handle, tableInfo);
    }

    public static Handle decodeHandle(byte[] value, boolean isCommonHandle) {
        if (isCommonHandle) {
            return new CommonHandle(value);
        }
        return new IntHandle(new CodecDataInput(value).readLong());
    }

    public static byte[] genIndexValue(Row row, Handle handle, int commonHandleVersion, boolean distinct, TiIndexInfo tiIndexInfo, TiTableInfo tiTableInfo) {
        if (!handle.isInt() && commonHandleVersion == 1) {
            return TableCodec.genIndexValueForCommonHandleVersion1(row, handle, distinct, tiIndexInfo, tiTableInfo);
        }
        return TableCodec.genIndexValueForClusterIndexVersion0(row, handle, distinct, tiIndexInfo, tiTableInfo);
    }

    private static void genRestoreData(Row row, CodecDataOutput cdo, TiIndexInfo tiIndexInfo, TiTableInfo tiTableInfo) {
        ArrayList<TiColumnInfo> columnInfoList = new ArrayList<TiColumnInfo>();
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (TiIndexInfo index : tiTableInfo.getIndices()) {
            for (TiIndexColumn tiIndexColumn : index.getIndexColumns()) {
                Object value;
                TiColumnInfo indexColumnInfo = tiTableInfo.getColumn(tiIndexColumn.getOffset());
                DataType indexType = indexColumnInfo.getType();
                int prefixLength = (int)tiIndexColumn.getLength();
                if (!TableCodec.needRestoreData(indexType).booleanValue() || (value = row.get(indexColumnInfo.getOffset(), indexColumnInfo.getType())) == null || Collation.isBinCollation(indexType.getCollationCode())) continue;
                if (DataType.isLengthUnSpecified(prefixLength)) {
                    valueList.add(value);
                } else if (indexType instanceof BytesType) {
                    if (indexType.getCharset().equalsIgnoreCase("utf8") || indexType.getCharset().equalsIgnoreCase("utf8mb4")) {
                        value = Converter.convertUtf8ToBytes(value, prefixLength);
                        valueList.add(value);
                    } else {
                        value = Converter.convertToBytes(value, prefixLength);
                        valueList.add(value);
                    }
                }
                columnInfoList.add(indexColumnInfo);
            }
        }
        if (valueList.size() > 0) {
            cdo.write(new RowEncoderV2().encode(columnInfoList, valueList));
        }
    }

    private static byte[] genIndexValueForClusterIndexVersion0(Row row, Handle handle, boolean distinct, TiIndexInfo tiIndexInfo, TiTableInfo tiTableInfo) {
        CodecDataOutput cdo = new CodecDataOutput();
        cdo.writeByte(0);
        int tailLen = 0;
        Boolean newEncode = false;
        if (!handle.isInt() && distinct) {
            TableCodec.encodeCommonHandle(cdo, handle);
            newEncode = true;
        }
        if (TableCodec.tableNeedRestoreData(tiTableInfo, tiIndexInfo).booleanValue()) {
            ArrayList<TiColumnInfo> columnInfoList = new ArrayList<TiColumnInfo>();
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (TiIndexColumn tiIndexColumn : tiIndexInfo.getIndexColumns()) {
                TiColumnInfo indexColumnInfo = tiTableInfo.getColumn(tiIndexColumn.getOffset());
                Object value = row.get(indexColumnInfo.getOffset(), indexColumnInfo.getType());
                valueList.add(value);
                columnInfoList.add(indexColumnInfo);
            }
            if (valueList.size() > 0) {
                cdo.write(new RowEncoderV2().encode(columnInfoList, valueList));
            }
        }
        if (cdo.size() > 1) {
            newEncode = true;
        }
        if (newEncode.booleanValue()) {
            if (handle.isInt() && distinct) {
                tailLen += 8;
                TableCodec.encodeHandleInUniqueIndexValue(cdo, handle);
            } else if (cdo.size() < 10) {
                int paddingLen = 10 - cdo.size();
                tailLen += paddingLen;
                cdo.write(new byte[paddingLen]);
            }
            byte[] value = cdo.toBytes();
            value[0] = (byte)tailLen;
            return value;
        }
        if (distinct) {
            CodecDataOutput valueCdo = new CodecDataOutput();
            valueCdo.writeLong(handle.intValue());
            return valueCdo.toBytes();
        }
        return new byte[]{48};
    }

    private static Boolean needRestoreData(DataType type) {
        if (Collation.isNewCollationEnabled().booleanValue() && TableCodec.isNonBinaryStr(type).booleanValue() && (!Collation.isBinCollation(type.getCollationCode()) || TableCodec.isTypeVarChar(type).booleanValue())) {
            return true;
        }
        return false;
    }

    private static Boolean tableNeedRestoreData(TiTableInfo tiTableInfo, TiIndexInfo tiIndexInfo) {
        for (TiIndexColumn tiIndexColumn : tiIndexInfo.getIndexColumns()) {
            TiColumnInfo indexColumnInfo = tiTableInfo.getColumn(tiIndexColumn.getOffset());
            if (!TableCodec.needRestoreData(indexColumnInfo.getType()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static Boolean isNonBinaryStr(DataType type) {
        if (type.getCollationCode() != Collation.translate("binary") && TableCodec.isString(type)) {
            return true;
        }
        return false;
    }

    private static boolean isString(DataType type) {
        return TableCodec.isTypeChar(type) != false || TableCodec.isTypeVarChar(type) != false || TableCodec.isTypeBlob(type) != false;
    }

    private static Boolean isTypeChar(DataType type) {
        return type.getType() == MySQLType.TypeVarchar || type.getType() == MySQLType.TypeString;
    }

    private static Boolean isTypeBlob(DataType type) {
        return type.getType() == MySQLType.TypeBlob || type.getType() == MySQLType.TypeTinyBlob || type.getType() == MySQLType.TypeMediumBlob || type.getType() == MySQLType.TypeLongBlob;
    }

    private static Boolean isTypeVarChar(DataType type) {
        return type.getType() == MySQLType.TypeVarchar || type.getType() == MySQLType.TypeVarString;
    }

    private static byte[] genIndexValueForCommonHandleVersion1(Row row, Handle handle, boolean distinct, TiIndexInfo tiIndexInfo, TiTableInfo tiTableInfo) {
        CodecDataOutput cdo = new CodecDataOutput();
        cdo.writeByte(0);
        cdo.writeByte(IndexVersionFlag);
        cdo.writeByte(1);
        if (distinct) {
            TableCodec.encodeCommonHandle(cdo, handle);
        }
        TableCodec.genRestoreData(row, cdo, tiIndexInfo, tiTableInfo);
        return cdo.toBytes();
    }

    private static void encodeCommonHandle(CodecDataOutput cdo, Handle handle) {
        cdo.write(CommonHandleFlag);
        byte[] encoded = handle.encoded();
        int hLen = encoded.length;
        cdo.writeShort(hLen);
        cdo.write(encoded);
    }

    private static void encodeHandleInUniqueIndexValue(CodecDataOutput cdo, Handle handle) {
        if (handle.isInt()) {
            cdo.writeLong(handle.intValue());
        }
    }

    public static Handle decodeHandleInUniqueIndexValue(byte[] value, boolean isCommonHandle) {
        if (!isCommonHandle) {
            if (value.length <= MaxOldEncodeValueLen) {
                return new IntHandle(new CodecDataInput(value).readLong());
            }
            byte tailLen = value[0];
            byte[] encode = Arrays.copyOfRange(value, value.length - tailLen, value.length);
            return new IntHandle(new CodecDataInput(encode).readLong());
        }
        CodecDataInput codecDataInput = new CodecDataInput(value);
        if (TableCodec.getIndexVersion(value) == 1) {
            IndexValueSegments segments = TableCodec.splitIndexValueForCommonHandleVersion1(codecDataInput);
            return new CommonHandle(segments.commonHandle);
        }
        int handleLen = (value[2] << 8) + value[3];
        byte[] encode = Arrays.copyOfRange(value, 4, handleLen + 4);
        return new CommonHandle(encode);
    }

    private static int getIndexVersion(byte[] value) {
        byte tailLen = value[0];
        if ((tailLen == 0 || tailLen == 1) && value[1] == IndexVersionFlag) {
            return value[2];
        }
        return 0;
    }

    public static IndexValueSegments splitIndexValueForCommonHandleVersion1(CodecDataInput codecDataInput) {
        byte tailLen = codecDataInput.readByte();
        codecDataInput.readByte();
        codecDataInput.readByte();
        IndexValueSegments segments = new IndexValueSegments();
        if (codecDataInput.available() > 0 && codecDataInput.peekByte() == CommonHandleFlag) {
            codecDataInput.readByte();
            short handleLen = codecDataInput.readShort();
            segments.commonHandle = new byte[handleLen];
            codecDataInput.readFully(segments.commonHandle, 0, handleLen);
        }
        if (codecDataInput.available() > 0 && codecDataInput.peekByte() == PartitionIDFlag) {
            codecDataInput.readByte();
            segments.partitionID = new byte[9];
            codecDataInput.readFully(segments.partitionID, 0, 9);
        }
        if (codecDataInput.available() > 0 && codecDataInput.peekByte() == RestoreDataFlag) {
            codecDataInput.readByte();
            segments.restoredValues = new byte[codecDataInput.available() - tailLen];
            codecDataInput.readFully(segments.restoredValues, 0, codecDataInput.available() - tailLen);
        }
        return segments;
    }

    public static class IndexValueSegments {
        byte[] commonHandle;
        byte[] partitionID;
        byte[] restoredValues;
        byte[] intHandle;
    }
}

