/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.codec;

import com.pingcap.tikv.codec.RowDecoderV2;
import com.pingcap.tikv.codec.RowEncoderV2;
import com.pingcap.tikv.codec.RowV2;
import com.pingcap.tikv.handle.Handle;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiIndexColumn;
import com.pingcap.tikv.meta.TiIndexInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.row.ObjectRowImpl;
import com.pingcap.tikv.row.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableCodecV2 {
    protected static byte[] encodeRow(List<TiColumnInfo> columnInfos, Object[] values, boolean isPkHandle) {
        RowEncoderV2 encoder = new RowEncoderV2();
        ArrayList<TiColumnInfo> columnInfoList = new ArrayList<TiColumnInfo>();
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (int i = 0; i < columnInfos.size(); ++i) {
            TiColumnInfo col = columnInfos.get(i);
            if (col.isPrimaryKey() && isPkHandle) continue;
            columnInfoList.add(col);
            valueList.add(values[i]);
        }
        return encoder.encode(columnInfoList, valueList);
    }

    protected static Row decodeRow(byte[] value, Handle handle, TiTableInfo tableInfo) {
        if (handle == null && tableInfo.isPkHandle()) {
            throw new IllegalArgumentException("when pk is handle, handle cannot be null");
        }
        int colSize = tableInfo.getColumns().size();
        HashMap<Long, Object> decodedDataMap = new HashMap<Long, Object>(colSize);
        RowV2 rowV2 = RowV2.createNew(value);
        TiIndexInfo pk = tableInfo.getPrimaryKey();
        if (pk != null) {
            ArrayList cols = new ArrayList();
            for (TiIndexColumn indexColumn : pk.getIndexColumns()) {
                TiColumnInfo col = tableInfo.getColumn(indexColumn.getOffset());
                cols.add(col);
            }
            if (tableInfo.isPkHandle()) {
                assert (cols.size() == 1);
                decodedDataMap.put(((TiColumnInfo)cols.get(0)).getId(), handle.data()[0]);
            }
            if (tableInfo.isCommonHandle()) {
                for (int i = 0; i < cols.size(); ++i) {
                    decodedDataMap.put(((TiColumnInfo)cols.get(i)).getId(), handle.data()[i]);
                }
            }
        }
        for (TiColumnInfo col : tableInfo.getColumns()) {
            if (decodedDataMap.containsKey(col.getId())) continue;
            if (col.isPrimaryKey() && tableInfo.isPkHandle()) {
                decodedDataMap.put(col.getId(), handle);
                continue;
            }
            RowV2.ColIDSearchResult searchResult = rowV2.findColID(col.getId());
            if (searchResult.isNull || searchResult.notFound) continue;
            assert (searchResult.idx != -1);
            byte[] colData = rowV2.getData(searchResult.idx);
            Object d = RowDecoderV2.decodeCol(colData, col.getType());
            decodedDataMap.put(col.getId(), d);
        }
        Object[] res = new Object[colSize];
        for (int i = 0; i < colSize; ++i) {
            TiColumnInfo col = tableInfo.getColumn(i);
            res[i] = decodedDataMap.get(col.getId());
        }
        return ObjectRowImpl.create(res);
    }
}

