/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.columnar;

import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.MyDecimal;
import com.pingcap.tikv.columnar.TiColumnVector;
import com.pingcap.tikv.columnar.TiCoreTime;
import com.pingcap.tikv.types.AbstractDateTimeType;
import com.pingcap.tikv.types.BitType;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.DateTimeType;
import com.pingcap.tikv.types.DateType;
import com.pingcap.tikv.types.EnumType;
import com.pingcap.tikv.types.IntegerType;
import com.pingcap.tikv.types.JsonType;
import com.pingcap.tikv.types.TimeType;
import com.pingcap.tikv.types.TimestampType;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.tikv.common.util.JsonUtils;
import org.tikv.shade.com.google.common.primitives.UnsignedLong;

public class TiChunkColumnVector
extends TiColumnVector {
    private final int fixLength;
    private final int numOfNulls;
    private final byte[] nullBitMaps;
    private final long[] offsets;
    private final ByteBuffer data;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.S");

    public TiChunkColumnVector(DataType dataType, int fixLength, int numOfRows, int numOfNulls, byte[] nullBitMaps, long[] offsets, ByteBuffer data) {
        super(dataType, numOfRows);
        this.fixLength = fixLength;
        this.numOfNulls = numOfNulls;
        this.nullBitMaps = nullBitMaps;
        this.data = data;
        this.offsets = offsets;
    }

    public final String typeName() {
        return this.dataType().getType().name();
    }

    public void free() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNull() {
        return this.numOfNulls > 0;
    }

    @Override
    public int numNulls() {
        return this.numOfNulls;
    }

    @Override
    public boolean isNullAt(int rowId) {
        int nullByte = this.nullBitMaps[rowId / 8] & 0xFF;
        return (nullByte & 1 << (rowId & 7)) == 0;
    }

    @Override
    public boolean getBoolean(int rowId) {
        long value = this.getLong(rowId);
        return value == 1L;
    }

    @Override
    public byte getByte(int rowId) {
        return this.data.get();
    }

    @Override
    public short getShort(int rowId) {
        return this.data.getShort();
    }

    @Override
    public int getInt(int rowId) {
        return (int)this.getLong(rowId);
    }

    private boolean isDataTimeOrTimestamp() {
        return this.type instanceof DateTimeType || this.type instanceof TimestampType;
    }

    private long getTime(int rowId) {
        int startPos = rowId * this.fixLength;
        long time = this.data.getLong(startPos);
        TiCoreTime coreTime = new TiCoreTime(time);
        int year = coreTime.getYear();
        int month = coreTime.getMonth();
        int day = coreTime.getDay();
        int hour = coreTime.getHour();
        int minute = coreTime.getMinute();
        int second = coreTime.getSecond();
        int microsecond = coreTime.getMicroSecond();
        int nanosecond = coreTime.getNanoSecond();
        if (time == 0L) {
            year = 1;
            month = 1;
            day = 1;
        }
        if (this.type instanceof DateType) {
            LocalDate date = new LocalDate(year, month, day);
            return ((DateType)this.type).getDays(date);
        }
        if (this.type instanceof DateTimeType || this.type instanceof TimestampType) {
            LocalDateTime dateTime = LocalDateTime.of(year, month, day, hour, minute, second, microsecond * 1000);
            ZonedDateTime zonedDateTime = ZonedDateTime.of(dateTime, ZoneOffset.systemDefault());
            return zonedDateTime.toEpochSecond() * 1000000L + (long)microsecond;
        }
        throw new UnsupportedOperationException("data, datetime, timestamp are already handled.");
    }

    private long getLongFromBinary(int rowId) {
        byte[] bytes = this.getBinary(rowId);
        if (bytes.length == 0) {
            return 0L;
        }
        long result = 0L;
        for (byte b : bytes) {
            result = result << 8 | (long)(b & 0xFF);
        }
        return result;
    }

    @Override
    public long getLong(int rowId) {
        if (this.type instanceof IntegerType) {
            if (this.type instanceof BitType) {
                return this.getLongFromBinary(rowId);
            }
            return this.data.getLong(rowId * this.fixLength);
        }
        if (this.type instanceof AbstractDateTimeType) {
            return this.getTime(rowId);
        }
        if (this.type instanceof TimeType) {
            return this.data.getLong(rowId * this.fixLength);
        }
        throw new UnsupportedOperationException("only IntegerType and Time related are supported.");
    }

    @Override
    public float getFloat(int rowId) {
        return this.data.getFloat(rowId * this.fixLength);
    }

    @Override
    public double getDouble(int rowId) {
        return this.data.getDouble(rowId * this.fixLength);
    }

    private MyDecimal getMyDecimal(int rowId) {
        int startPos = rowId * this.fixLength;
        byte digitsInt = this.data.get(startPos);
        byte digitsFrac = this.data.get(startPos + 1);
        byte resultFrac = this.data.get(startPos + 2);
        boolean negative = this.data.get(startPos + 3) == 1;
        int[] wordBuf = new int[9];
        for (int i = 0; i < 9; ++i) {
            wordBuf[i] = this.data.getInt(startPos + 4 + i * 4);
        }
        return new MyDecimal(digitsInt, digitsFrac, negative, wordBuf);
    }

    @Override
    public BigDecimal getDecimal(int rowId, int precision, int scale) {
        if (this.type instanceof IntegerType) {
            return new BigDecimal(UnsignedLong.fromLongBits(this.getLong(rowId)).bigIntegerValue());
        }
        MyDecimal decimal = this.getMyDecimal(rowId);
        return decimal.toBigDecimal();
    }

    private String getEnumString(int rowId) {
        int start = (int)this.offsets[rowId];
        long end = this.offsets[rowId + 1];
        return new String(this.getRawBinary(start + 8, end));
    }

    private String getJsonString(int rowId) {
        long start = this.offsets[rowId];
        long end = this.offsets[rowId + 1];
        return JsonUtils.parseJson(new CodecDataInput(this.getRawBinary(start, end))).toString();
    }

    @Override
    public String getUTF8String(int rowId) {
        if (this.type instanceof EnumType) {
            return this.getEnumString(rowId);
        }
        if (this.type instanceof JsonType) {
            return this.getJsonString(rowId);
        }
        return new String(this.getBinary(rowId));
    }

    private byte[] getRawBinary(long start, long end) {
        byte[] buffer = new byte[(int)(end - start)];
        int i = 0;
        while ((long)i < end - start) {
            buffer[i] = this.data.get((int)(start + (long)i));
            ++i;
        }
        return buffer;
    }

    @Override
    public byte[] getBinary(int rowId) {
        int start = (int)this.offsets[rowId];
        long end = this.offsets[rowId + 1];
        return this.getRawBinary(start, end);
    }

    @Override
    protected TiColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("TiChunkColumnVector does not support this operation");
    }
}

