/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.tikv.expression.ComparisonBinaryExpression;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.LogicalBinaryExpression;
import com.pingcap.tikv.expression.RangeColumnPartitionPruner;
import com.pingcap.tikv.expression.RangePartitionPruner;
import com.pingcap.tikv.meta.TiPartitionDef;
import com.pingcap.tikv.meta.TiPartitionInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.parser.TiParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PartitionPruner {
    public static List<Expression> extractLogicalOrComparisonExpr(List<Expression> filters) {
        ArrayList<Expression> filteredFilters = new ArrayList<Expression>();
        for (Expression expr : filters) {
            if (!(expr instanceof LogicalBinaryExpression) && !(expr instanceof ComparisonBinaryExpression)) continue;
            filteredFilters.add(expr);
        }
        return filteredFilters;
    }

    public static List<TiPartitionDef> prune(TiTableInfo tableInfo, List<Expression> filters) {
        TiPartitionInfo.PartitionType type = tableInfo.getPartitionInfo().getType();
        if (!tableInfo.isPartitionEnabled()) {
            return tableInfo.getPartitionInfo().getDefs();
        }
        boolean isRangeColPartitioning = Objects.requireNonNull(tableInfo.getPartitionInfo().getColumns()).size() > 0;
        switch (type) {
            case RangePartition: {
                if (!isRangeColPartitioning) {
                    RangePartitionPruner pruner = new RangePartitionPruner(tableInfo);
                    return pruner.prune(filters);
                }
                if (tableInfo.getPartitionInfo().getColumns().size() > 1) {
                    return tableInfo.getPartitionInfo().getDefs();
                }
                for (int i = 0; i < tableInfo.getPartitionInfo().getDefs().size(); ++i) {
                    TiPartitionDef pDef = tableInfo.getPartitionInfo().getDefs().get(i);
                    if (!pDef.getLessThan().get(0).contains("\"")) continue;
                    return tableInfo.getPartitionInfo().getDefs();
                }
                RangeColumnPartitionPruner pruner = new RangeColumnPartitionPruner(tableInfo);
                return pruner.prune(filters);
            }
            case ListPartition: 
            case HashPartition: {
                return tableInfo.getPartitionInfo().getDefs();
            }
        }
        throw new UnsupportedOperationException("cannot prune under invalid partition table");
    }

    public static void generateRangeExprs(TiPartitionInfo partInfo, List<Expression> partExprs, TiParser parser, String partExprStr, int lessThanIdx) {
        for (int i = 0; i < partInfo.getDefs().size(); ++i) {
            TiPartitionDef pDef = partInfo.getDefs().get(i);
            String current = PartitionPruner.wrapValue(pDef.getLessThan().get(lessThanIdx));
            String leftHand = current.equals("MAXVALUE") ? "true" : String.format("%s < %s", PartitionPruner.wrapColumnName(partExprStr), current);
            if (i == 0) {
                partExprs.add(parser.parseExpression(leftHand));
                continue;
            }
            String previous = PartitionPruner.wrapValue(partInfo.getDefs().get(i - 1).getLessThan().get(lessThanIdx));
            String and = String.format("%s >= %s and %s", PartitionPruner.wrapColumnName(partExprStr), previous, leftHand);
            partExprs.add(parser.parseExpression(and));
        }
    }

    private static String wrapColumnName(String columnName) {
        if (columnName.startsWith("`") && columnName.endsWith("`")) {
            return columnName;
        }
        if (columnName.contains("(") && columnName.contains(")")) {
            return columnName;
        }
        return String.format("`%s`", columnName);
    }

    private static String wrapValue(String value) {
        if (value.startsWith("'") && value.endsWith("'")) {
            String newValue = String.format("\"%s\"", value.substring(1, value.length() - 1));
            StringBuilder valueWithoutEscape = new StringBuilder();
            for (int i = 0; i < newValue.length(); ++i) {
                if (newValue.charAt(i) != '\'') {
                    valueWithoutEscape.append(newValue.charAt(i));
                    continue;
                }
                if (i + 1 < newValue.length()) {
                    valueWithoutEscape.append(newValue.charAt(i + 1));
                }
                ++i;
            }
            return valueWithoutEscape.toString();
        }
        return value;
    }
}

