/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.Constant;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.Visitor;
import com.pingcap.tikv.key.TypedKey;
import com.pingcap.tikv.types.IntegerType;
import java.util.List;
import java.util.Objects;
import org.tikv.shade.com.google.common.collect.ImmutableList;

public class StringRegExpression
extends Expression {
    private final Expression left;
    private final Expression right;
    private final Expression reg;
    private final Type regType;
    private transient TypedKey key;

    public StringRegExpression(Type type, Expression left, Expression right, Expression reg) {
        super(IntegerType.BOOLEAN);
        this.resolved = true;
        this.left = Objects.requireNonNull(left, "left expression is null");
        this.right = Objects.requireNonNull(right, "right expression is null");
        this.regType = Objects.requireNonNull(type, "type is null");
        this.reg = Objects.requireNonNull(reg, "reg string is null");
    }

    public static StringRegExpression startsWith(Expression left, Expression right) {
        Constant reg = Constant.create(((Constant)right).getValue() + "%", right.getDataType());
        return new StringRegExpression(Type.STARTS_WITH, left, right, reg);
    }

    public static StringRegExpression contains(Expression left, Expression right) {
        Constant reg = Constant.create("%" + ((Constant)right).getValue() + "%", right.getDataType());
        return new StringRegExpression(Type.CONTAINS, left, right, reg);
    }

    public static StringRegExpression endsWith(Expression left, Expression right) {
        Constant reg = Constant.create("%" + ((Constant)right).getValue(), right.getDataType());
        return new StringRegExpression(Type.ENDS_WITH, left, right, reg);
    }

    public static StringRegExpression like(Expression left, Expression right) {
        return new StringRegExpression(Type.LIKE, left, right, right);
    }

    public ColumnRef getColumnRef() {
        return (ColumnRef)this.getLeft();
    }

    public Constant getValue() {
        return (Constant)this.getRight();
    }

    public TypedKey getTypedLiteral() {
        return this.getTypedLiteral(-1);
    }

    public TypedKey getTypedLiteral(int prefixLength) {
        if (this.key == null) {
            this.key = TypedKey.toTypedKey(this.getValue().getValue(), this.getColumnRef().getDataType(), prefixLength);
        }
        return this.key;
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of(this.left, this.reg, Constant.create(0, IntegerType.BIGINT));
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public Type getRegType() {
        return this.regType;
    }

    public Expression getReg() {
        return this.reg;
    }

    public String toString() {
        return String.format("[%s %s %s reg: %s]", new Object[]{this.getLeft(), this.getRegType(), this.getRight(), this.getReg()});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringRegExpression)) {
            return false;
        }
        StringRegExpression that = (StringRegExpression)other;
        return this.regType == that.regType && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && Objects.equals(this.reg, that.reg);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.regType, this.left, this.right, this.reg});
    }

    @Override
    public void setNewCollation() {
        this.dataType.setCollation(this.left.dataType.getCollationCode());
    }

    public static enum Type {
        STARTS_WITH,
        CONTAINS,
        ENDS_WITH,
        LIKE;

    }
}

