/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression.visitor;

import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.ComparisonBinaryExpression;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.LogicalBinaryExpression;
import com.pingcap.tikv.expression.StringRegExpression;
import com.pingcap.tikv.expression.visitor.DefaultVisitor;
import com.pingcap.tikv.meta.TiIndexColumn;
import java.util.Objects;

public class IndexMatcher
extends DefaultVisitor<Boolean, Void> {
    private final boolean matchEqualTestOnly;
    private final TiIndexColumn indexColumn;

    private IndexMatcher(TiIndexColumn indexColumn, boolean matchEqualTestOnly) {
        this.matchEqualTestOnly = matchEqualTestOnly;
        this.indexColumn = Objects.requireNonNull(indexColumn, "index column is null");
    }

    public static IndexMatcher equalOnlyMatcher(TiIndexColumn indexColumn) {
        return new IndexMatcher(indexColumn, true);
    }

    public static IndexMatcher matcher(TiIndexColumn indexColumn) {
        return new IndexMatcher(indexColumn, false);
    }

    public boolean match(Expression expression) {
        return expression.accept(this, null);
    }

    @Override
    protected Boolean process(Expression node, Void context) {
        return false;
    }

    @Override
    protected Boolean visit(ColumnRef node, Void context) {
        String indexColumnName = this.indexColumn.getName();
        return node.matchName(indexColumnName);
    }

    @Override
    protected Boolean visit(ComparisonBinaryExpression node, Void context) {
        switch (node.getComparisonType()) {
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case NOT_EQUAL: {
                if (this.matchEqualTestOnly) {
                    return false;
                }
            }
            case EQUAL: {
                ComparisonBinaryExpression.NormalizedPredicate predicate = node.normalize();
                if (predicate == null) {
                    return false;
                }
                return predicate.getColumnRef().accept(this, context);
            }
        }
        return false;
    }

    @Override
    protected Boolean visit(StringRegExpression node, Void context) {
        switch (node.getRegType()) {
            case STARTS_WITH: {
                if (this.matchEqualTestOnly) {
                    return false;
                }
                return node.getLeft().accept(this, context);
            }
        }
        return false;
    }

    @Override
    protected Boolean visit(LogicalBinaryExpression node, Void context) {
        switch (node.getCompType()) {
            case AND: {
                if (this.matchEqualTestOnly) {
                    return false;
                }
            }
            case OR: 
            case XOR: {
                return node.getLeft().accept(this, context) != false && node.getRight().accept(this, context) != false;
            }
        }
        return false;
    }
}

