/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression.visitor;

import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.ComparisonBinaryExpression;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.visitor.DefaultVisitor;
import com.pingcap.tikv.meta.TiTableInfo;
import java.util.List;
import java.util.Objects;

public class MetaResolver
extends DefaultVisitor<Void, Expression> {
    private final TiTableInfo table;

    public MetaResolver(TiTableInfo table) {
        this.table = table;
    }

    public static void resolve(Expression expression, TiTableInfo table) {
        MetaResolver resolver = new MetaResolver(table);
        resolver.resolve(expression);
    }

    public static void resolve(List<? extends Expression> expressions, TiTableInfo table) {
        MetaResolver resolver = new MetaResolver(table);
        resolver.resolve(expressions);
    }

    public void resolve(List<? extends Expression> expressions) {
        expressions.forEach(expression -> expression.accept(this, null));
    }

    public void resolve(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        expression.accept(this, null);
    }

    @Override
    protected Void visit(ComparisonBinaryExpression node, Expression parent) {
        ComparisonBinaryExpression.NormalizedPredicate predicate = node.normalize();
        if (predicate != null) {
            this.visit(predicate.getColumnRef(), (Expression)node);
            if (predicate.getValue().getDataType() == null || !predicate.getValue().getDataType().isSameCatalog(predicate.getColumnRef().getDataType())) {
                predicate.getValue().setDataType(predicate.getColumnRef().getDataType());
            }
        }
        return null;
    }

    @Override
    protected Void visit(ColumnRef node, Expression parent) {
        node.resolve(this.table);
        return null;
    }
}

