/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression.visitor;

import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.ComparisonBinaryExpression;
import com.pingcap.tikv.expression.Constant;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.visitor.RangeSetBuilder;
import com.pingcap.tikv.key.TypedKey;
import java.util.Set;
import org.tikv.shade.com.google.common.collect.RangeSet;
import org.tikv.shade.com.google.common.collect.TreeRangeSet;

public class PrunedPartitionBuilder
extends RangeSetBuilder<TypedKey> {
    private final Set<ColumnRef> partExprColRefs;

    public PrunedPartitionBuilder(Set<ColumnRef> partExprColRefs) {
        this.partExprColRefs = partExprColRefs;
    }

    @Override
    protected RangeSet<TypedKey> process(Expression node, Void context) {
        PrunedPartitionBuilder.throwOnError(node);
        return null;
    }

    @Override
    protected RangeSet<TypedKey> visit(Constant node, Void context) {
        TreeRangeSet<TypedKey> ranges = TreeRangeSet.create();
        if (node.getValue() instanceof Number) {
            long val = ((Number)node.getValue()).longValue();
            if (val == 1L) {
                return ranges.complement();
            }
            return ranges;
        }
        return ranges;
    }

    @Override
    protected RangeSet<TypedKey> visit(ComparisonBinaryExpression node, Void context) {
        ComparisonBinaryExpression.NormalizedPredicate predicate = node.normalize();
        if (predicate == null) {
            return TreeRangeSet.create().complement();
        }
        if (!this.partExprColRefs.contains(predicate.getColumnRef())) {
            return TreeRangeSet.create().complement();
        }
        TypedKey literal = predicate.getTypedLiteral(-1);
        return this.visitComparisonBinaryExpr(node, context, literal, false);
    }
}

