/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.handle;

import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.handle.Handle;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.MySQLType;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.tikv.common.exception.CodecException;
import org.tikv.common.util.FastByteComparisons;

public class CommonHandle
implements Handle {
    private final byte[] encoded;
    private final int[] colEndOffsets;
    private static final int MS_OF_ONE_DAY = 86400000;
    private static final int MIN_ENCODE_LEN = 9;

    public static CommonHandle newCommonHandle(DataType[] dataTypes, Object[] data) {
        long[] prefixLengthes = new long[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            prefixLengthes[i] = -1L;
        }
        return CommonHandle.newCommonHandle(dataTypes, data, prefixLengthes);
    }

    public static CommonHandle newCommonHandle(DataType[] dataTypes, Object[] data, long[] prefixLengthes) {
        CodecDataOutput cdo = new CodecDataOutput();
        for (int i = 0; i < data.length; ++i) {
            if (dataTypes[i].getType().equals((Object)MySQLType.TypeTimestamp)) {
                long milliseconds = data[i] instanceof Timestamp ? ((Timestamp)data[i]).getTime() : (Long)data[i] / 1000L;
                dataTypes[i].encode(cdo, DataType.EncodeType.KEY, milliseconds);
                continue;
            }
            if (dataTypes[i].getType().equals((Object)MySQLType.TypeDate)) {
                long days = data[i] instanceof Date ? (long)Days.daysBetween(new LocalDate(1970, 1, 1), new LocalDate(data[i])).getDays() : (Long)data[i];
                SimpleDateFormat utcFmt = new SimpleDateFormat("yyyy-MM-dd");
                utcFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
                dataTypes[i].encode(cdo, DataType.EncodeType.KEY, Date.valueOf(utcFmt.format(days * 86400000L)));
                continue;
            }
            if (prefixLengthes[i] > 0L && data[i] instanceof String) {
                String source;
                String dest = source = (String)data[i];
                if ((long)source.length() > prefixLengthes[i]) {
                    dest = source.substring(0, (int)prefixLengthes[i]);
                }
                dataTypes[i].encode(cdo, DataType.EncodeType.KEY, dest);
                continue;
            }
            dataTypes[i].encode(cdo, DataType.EncodeType.KEY, data[i]);
        }
        return new CommonHandle(cdo.toBytes());
    }

    public CommonHandle(byte[] encoded) {
        this.encoded = encoded.length < 9 ? Arrays.copyOf(encoded, 9) : encoded;
        int endOffset = 0;
        CodecDataInput cdi = new CodecDataInput(encoded);
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        while (!cdi.eof() && cdi.peekByte() != 0) {
            offsets.add(endOffset += cdi.cutOne());
        }
        this.colEndOffsets = offsets.stream().mapToInt(i -> i).toArray();
    }

    public CommonHandle(byte[] encoded, int[] colEndOffsets) {
        this.encoded = encoded.length < 9 ? Arrays.copyOf(encoded, 9) : encoded;
        this.colEndOffsets = colEndOffsets;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public long intValue() {
        throw new CodecException("not supported in CommonHandle");
    }

    @Override
    public Handle next() {
        return new CommonHandle(new Key(this.encoded).nextPrefix().getBytes(), this.colEndOffsets);
    }

    public boolean equals(Object other) {
        if (other instanceof CommonHandle) {
            return Arrays.equals(this.encoded, ((CommonHandle)other).encoded());
        }
        return false;
    }

    @Override
    public int compare(Handle h) {
        if (h.isInt()) {
            throw new RuntimeException("CommonHandle compares to IntHandle");
        }
        return FastByteComparisons.compareTo(this.encoded, h.encoded());
    }

    @Override
    public byte[] encoded() {
        return this.encoded;
    }

    @Override
    public byte[] encodedAsKey() {
        return this.encoded;
    }

    @Override
    public int len() {
        return this.encoded.length;
    }

    @Override
    public int numCols() {
        return this.colEndOffsets.length;
    }

    @Override
    public byte[] encodedCol(int idx) {
        int start = 0;
        int end = this.colEndOffsets[idx];
        if (idx > 0) {
            start = this.colEndOffsets[idx - 1];
        }
        return Arrays.copyOfRange(this.encoded, start, end + 1);
    }

    @Override
    public Object[] data() {
        int len = this.numCols();
        Object[] data = new Object[len];
        for (int i = 0; i < len; ++i) {
            byte[] col = this.encodedCol(i);
            data[i] = Codec.decodeOne(col);
        }
        return data;
    }

    public String toString() {
        Object[] data = this.data();
        return Arrays.stream(data).map(Object::toString).collect(Collectors.joining("},{", "{", "}"));
    }
}

