/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.key;

import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.key.Key;
import java.util.ArrayList;
import java.util.List;
import org.tikv.shade.com.google.common.base.Joiner;

public class CompoundKey
extends Key {
    private final List<Key> keys;

    protected CompoundKey(List<Key> keys, byte[] value) {
        super(value);
        this.keys = keys;
    }

    public static CompoundKey concat(Key lKey, Key rKey) {
        Builder builder = CompoundKey.newBuilder();
        builder.append(lKey).append(rKey);
        return builder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<Key> getKeys() {
        return this.keys;
    }

    @Override
    public String toString() {
        return String.format("[%s]", Joiner.on(",").useForNull("Null").join(this.keys));
    }

    public static class Builder {
        private final List<Key> keys = new ArrayList<Key>();

        public Builder append(Key key) {
            if (key instanceof CompoundKey) {
                CompoundKey compKey = (CompoundKey)key;
                for (Key child : compKey.getKeys()) {
                    this.append(child);
                }
            } else {
                this.keys.add(key);
            }
            return this;
        }

        public CompoundKey build() {
            int totalLen = 0;
            for (Key key : this.keys) {
                totalLen += key.getBytes().length;
            }
            CodecDataOutput cdo = new CodecDataOutput(totalLen);
            for (Key key : this.keys) {
                cdo.write(key.getBytes());
            }
            return new CompoundKey(this.keys, cdo.toBytes());
        }
    }
}

