/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.key;

import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.handle.Handle;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.key.TypedKey;
import com.pingcap.tikv.meta.TiIndexColumn;
import com.pingcap.tikv.meta.TiIndexInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.IntegerType;
import java.util.List;
import org.tikv.common.exception.TypeException;
import org.tikv.shade.com.google.common.base.Joiner;

public class IndexKey
extends Key {
    private static final byte[] IDX_PREFIX_SEP = new byte[]{95, 105};
    private final long tableId;
    private final long indexId;
    private final Key[] dataKeys;

    private IndexKey(long tableId, long indexId, Key[] dataKeys) {
        super(IndexKey.encode(tableId, indexId, dataKeys));
        this.tableId = tableId;
        this.indexId = indexId;
        this.dataKeys = dataKeys;
    }

    public static IndexKey toIndexKey(long tableId, long indexId, Key ... dataKeys) {
        return new IndexKey(tableId, indexId, dataKeys);
    }

    public static EncodeIndexDataResult genIndexKey(long physicalID, Row row, TiIndexInfo indexInfo, Handle handle, TiTableInfo tableInfo) {
        boolean distinct = false;
        List<TiIndexColumn> indexColumns = indexInfo.getIndexColumns();
        if (indexInfo.isUnique() && !IndexKey.containNullInUniqueIndexValue(row, tableInfo, indexColumns)) {
            distinct = true;
        }
        CodecDataOutput keyCdo = new CodecDataOutput();
        keyCdo.write(IndexKey.toIndexKey(physicalID, indexInfo.getId(), new Key[0]).getBytes());
        for (TiIndexColumn col : indexColumns) {
            DataType colTp = tableInfo.getColumn(col.getOffset()).getType();
            TypedKey key = TypedKey.toTypedKey(row.get(col.getOffset(), colTp), colTp, (int)col.getLength());
            keyCdo.write(key.getBytes());
        }
        if (!distinct) {
            if (handle.isInt()) {
                keyCdo.write(TypedKey.toTypedKey(handle, IntegerType.BIGINT).getBytes());
            } else {
                keyCdo.write(handle.encodedAsKey());
            }
        }
        return new EncodeIndexDataResult(keyCdo.toBytes(), distinct);
    }

    private static boolean containNullInUniqueIndexValue(Row row, TiTableInfo tableInfo, List<TiIndexColumn> indexColumns) {
        for (TiIndexColumn col : indexColumns) {
            DataType colTp = tableInfo.getColumn(col.getOffset()).getType();
            if (row.get(col.getOffset(), colTp) != null) continue;
            return true;
        }
        return false;
    }

    private static byte[] encode(long tableId, long indexId, Key[] dataKeys) {
        CodecDataOutput cdo = new CodecDataOutput();
        cdo.write(TBL_PREFIX);
        Codec.IntegerCodec.writeLong(cdo, tableId);
        cdo.write(IDX_PREFIX_SEP);
        Codec.IntegerCodec.writeLong(cdo, indexId);
        for (Key key : dataKeys) {
            if (key == null) {
                throw new TypeException("key cannot be null");
            }
            cdo.write(key.getBytes());
        }
        return cdo.toBytes();
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public Key[] getDataKeys() {
        return this.dataKeys;
    }

    @Override
    public String toString() {
        return String.format("[%s]", Joiner.on(",").useForNull("null").join(this.dataKeys));
    }

    public static class EncodeIndexDataResult {
        public byte[] indexKey;
        public boolean distinct;

        public EncodeIndexDataResult(byte[] indexKey, boolean distinct) {
            this.indexKey = indexKey;
            this.distinct = distinct;
        }
    }
}

