/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.key;

import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.util.LogDesensitization;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.tikv.common.util.FastByteComparisons;
import org.tikv.shade.com.google.common.primitives.Bytes;
import org.tikv.shade.com.google.protobuf.ByteString;

public class Key
implements Comparable<Key> {
    public static final Key EMPTY = Key.createEmpty();
    public static final Key NULL = Key.createNull();
    public static final Key MIN = Key.createTypelessMin();
    public static final Key MAX = Key.createTypelessMax();
    protected static final byte[] TBL_PREFIX = new byte[]{116};
    protected final byte[] value;
    protected final int infFlag;

    private Key(byte[] value, boolean negative) {
        this.value = Objects.requireNonNull(value, "value is null");
        this.infFlag = (value.length == 0 ? 1 : 0) * (negative ? -1 : 1);
    }

    public Key(byte[] value) {
        this(value, false);
    }

    public static Key toRawKey(ByteString bytes, boolean negative) {
        return new Key(bytes.toByteArray(), negative);
    }

    public static Key toRawKey(ByteString bytes) {
        return new Key(bytes.toByteArray());
    }

    public static Key toRawKey(byte[] bytes, boolean negative) {
        return new Key(bytes, negative);
    }

    public static Key toRawKey(byte[] bytes) {
        return new Key(bytes);
    }

    private static Key createNull() {
        CodecDataOutput cdo = new CodecDataOutput();
        DataType.encodeNull(cdo);
        return new Key(cdo.toBytes()){

            @Override
            public String toString() {
                return "null";
            }
        };
    }

    private static Key createEmpty() {
        return new Key(new byte[0]){

            @Override
            public Key next() {
                return this;
            }

            @Override
            public String toString() {
                return "EMPTY";
            }
        };
    }

    private static Key createTypelessMin() {
        CodecDataOutput cdo = new CodecDataOutput();
        DataType.encodeIndex(cdo);
        return new Key(cdo.toBytes()){

            @Override
            public String toString() {
                return "MIN";
            }
        };
    }

    private static Key createTypelessMax() {
        CodecDataOutput cdo = new CodecDataOutput();
        DataType.encodeMaxValue(cdo);
        return new Key(cdo.toBytes()){

            @Override
            public String toString() {
                return "MAX";
            }
        };
    }

    static byte[] prefixNext(byte[] value) {
        int i;
        byte[] newVal = Arrays.copyOf(value, value.length);
        for (i = newVal.length - 1; i >= 0; --i) {
            int n = i;
            newVal[n] = (byte)(newVal[n] + 1);
            if (newVal[i] != 0) break;
        }
        if (i == -1) {
            return Arrays.copyOf(value, value.length + 1);
        }
        return newVal;
    }

    public Key next() {
        return Key.toRawKey(Arrays.copyOf(this.value, this.value.length + 1));
    }

    public Key nextPrefix() {
        return Key.toRawKey(Key.prefixNext(this.value));
    }

    @Override
    public int compareTo(@Nonnull Key other) {
        if ((this.infFlag | other.infFlag) != 0) {
            return this.infFlag - other.infFlag;
        }
        return FastByteComparisons.compareTo(this.value, other.value);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Key) {
            return this.compareTo((Key)other) == 0;
        }
        return false;
    }

    public Key append(Key other) {
        if (other == null) {
            return this;
        }
        return Key.toRawKey(Bytes.concat(this.getBytes(), other.getBytes()));
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public byte[] getBytes() {
        return this.value;
    }

    public ByteString toByteString() {
        return ByteString.copyFrom(this.value);
    }

    public int getInfFlag() {
        return this.infFlag;
    }

    public String toString() {
        if (this.infFlag < 0) {
            return "-INF";
        }
        if (this.infFlag > 0) {
            return "+INF";
        }
        return String.format("{%s}", LogDesensitization.hide(KeyUtils.formatBytes(this.value)));
    }
}

