/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.key;

import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.handle.CommonHandle;
import com.pingcap.tikv.handle.Handle;
import com.pingcap.tikv.handle.IntHandle;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.key.TypedKey;
import java.io.Serializable;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.exception.TiExpressionException;

public class RowKey
extends Key
implements Serializable {
    private static final byte[] REC_PREFIX_SEP = new byte[]{95, 114};
    private static final int INT_HANDLE_SIZE = 19;
    private static final int HANDLE_PREFIX_SIZE = 11;
    private final long tableId;
    private final Handle handle;
    private final boolean maxHandleFlag;

    private RowKey(long tableId, Handle handle) {
        super(RowKey.encode(tableId, handle));
        this.tableId = tableId;
        this.handle = handle;
        this.maxHandleFlag = false;
    }

    private RowKey(long tableId) {
        super(RowKey.encodeBeyondMaxHandle(tableId));
        this.tableId = tableId;
        this.handle = new IntHandle(Long.MAX_VALUE);
        this.maxHandleFlag = true;
    }

    public static RowKey toRowKey(long tableId, Handle handle) {
        return new RowKey(tableId, handle);
    }

    public static RowKey toRowKey(long tableId, TypedKey handle) {
        Object obj = handle.getValue();
        if (obj instanceof Long) {
            return RowKey.toRowKey(tableId, new IntHandle((Long)obj));
        }
        throw new TiExpressionException("Cannot encode row key with non-long type");
    }

    public static RowKey createMin(long tableId) {
        return RowKey.toRowKey(tableId, new IntHandle(Long.MIN_VALUE));
    }

    public static RowKey createBeyondMax(long tableId) {
        return new RowKey(tableId);
    }

    public static RowKey decode(byte[] value) {
        Handle handle;
        CodecDataInput cdi = new CodecDataInput(value);
        cdi.readByte();
        long tableId = Codec.IntegerCodec.readLong(cdi);
        cdi.readByte();
        cdi.readByte();
        if (value.length == 19) {
            handle = new IntHandle(Codec.IntegerCodec.readLong(cdi));
        } else {
            byte[] buffer = new byte[value.length - 11];
            cdi.readFully(buffer);
            handle = new CommonHandle(buffer);
        }
        return RowKey.toRowKey(tableId, handle);
    }

    public static byte[] encode(long tableId, Handle handle) {
        return RowKey.encode(tableId, handle.encoded());
    }

    public static byte[] encode(long tableId, byte[] key) {
        CodecDataOutput cdo = new CodecDataOutput();
        RowKey.encodePrefix(cdo, tableId);
        cdo.write(key);
        return cdo.toBytes();
    }

    private static byte[] encodeBeyondMaxHandle(long tableId) {
        return RowKey.prefixNext(RowKey.encode(tableId, new IntHandle(Long.MAX_VALUE)));
    }

    private static void encodePrefix(CodecDataOutput cdo, long tableId) {
        cdo.write(TBL_PREFIX);
        Codec.IntegerCodec.writeLong(cdo, tableId);
        cdo.write(REC_PREFIX_SEP);
    }

    @Override
    public RowKey next() {
        Handle handle = this.getHandle();
        boolean maxHandleFlag = this.getMaxHandleFlag();
        if (maxHandleFlag) {
            throw new TiClientInternalException("Handle overflow for Long MAX");
        }
        if (handle.isInt() && handle.intValue() == Long.MAX_VALUE) {
            return RowKey.createBeyondMax(this.tableId);
        }
        return new RowKey(this.tableId, handle.next());
    }

    public long getTableId() {
        return this.tableId;
    }

    public Handle getHandle() {
        return this.handle;
    }

    private boolean getMaxHandleFlag() {
        return this.maxHandleFlag;
    }

    @Override
    public String toString() {
        return "handle:" + this.handle.toString();
    }

    public static class DecodeResult {
        public long handle;
        public Status status;

        public static enum Status {
            MIN,
            MAX,
            EQUAL,
            LESS,
            GREATER,
            UNKNOWN_INF;

        }
    }
}

