/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.meta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingcap.tidb.tipb.ColumnInfo;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.meta.CIStr;
import com.pingcap.tikv.meta.Collation;
import com.pingcap.tikv.meta.SchemaState;
import com.pingcap.tikv.meta.TiIndexColumn;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.DataTypeFactory;
import com.pingcap.tikv.types.IntegerType;
import com.pingcap.tikv.types.MySQLType;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.tikv.shade.com.google.common.annotations.VisibleForTesting;
import org.tikv.shade.com.google.protobuf.ByteString;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TiColumnInfo
implements Serializable {
    @VisibleForTesting
    private static final int PK_MASK = 2;
    private final long id;
    private final String name;
    private final int offset;
    private final DataType type;
    private final SchemaState schemaState;
    private final String comment;
    private final boolean isPrimaryKey;
    private final String defaultValue;
    private final String originDefaultValue;
    private final String defaultValueBit;
    private final long version;
    private final String generatedExprString;
    private final boolean hidden;

    @JsonCreator
    public TiColumnInfo(@JsonProperty(value="id") long id, @JsonProperty(value="name") CIStr name, @JsonProperty(value="offset") int offset, @JsonProperty(value="type") InternalTypeHolder type, @JsonProperty(value="state") int schemaState, @JsonProperty(value="origin_default") String originalDefaultValue, @JsonProperty(value="default") String defaultValue, @JsonProperty(value="default_bit") String defaultValueBit, @JsonProperty(value="comment") String comment, @JsonProperty(value="version") long version, @JsonProperty(value="generated_expr_string") String generatedExprString, @JsonProperty(value="hidden") boolean hidden) {
        this.id = id;
        this.name = Objects.requireNonNull(name, "column name is null").getL();
        this.offset = offset;
        this.type = DataTypeFactory.of(Objects.requireNonNull(type, "type is null"));
        this.schemaState = SchemaState.fromValue(schemaState);
        this.comment = comment;
        this.defaultValue = defaultValue;
        this.originDefaultValue = originalDefaultValue;
        this.defaultValueBit = defaultValueBit;
        this.isPrimaryKey = (type.getFlag() & 2) > 0;
        this.version = version;
        this.generatedExprString = generatedExprString;
        this.hidden = hidden;
    }

    public TiColumnInfo(long id, String name, int offset, DataType type, SchemaState schemaState, String originalDefaultValue, String defaultValue, String defaultValueBit, String comment, long version, String generatedExprString, boolean hidden) {
        this.id = id;
        this.name = Objects.requireNonNull(name, "column name is null").toLowerCase();
        this.offset = offset;
        this.type = Objects.requireNonNull(type, "data type is null");
        this.schemaState = schemaState;
        this.comment = comment;
        this.defaultValue = defaultValue;
        this.originDefaultValue = originalDefaultValue;
        this.defaultValueBit = defaultValueBit;
        this.isPrimaryKey = (type.getFlag() & 2) > 0;
        this.version = version;
        this.generatedExprString = generatedExprString;
        this.hidden = hidden;
    }

    @VisibleForTesting
    public TiColumnInfo(long id, String name, int offset, DataType type, boolean isPrimaryKey) {
        this.id = id;
        this.name = Objects.requireNonNull(name, "column name is null").toLowerCase();
        this.offset = offset;
        this.type = Objects.requireNonNull(type, "data type is null");
        this.schemaState = SchemaState.StatePublic;
        this.comment = "";
        this.isPrimaryKey = isPrimaryKey;
        this.originDefaultValue = "1";
        this.defaultValue = "";
        this.defaultValueBit = null;
        this.version = 1L;
        this.generatedExprString = "";
        this.hidden = false;
    }

    static TiColumnInfo getRowIdColumn(int offset) {
        return new TiColumnInfo(-1L, "_tidb_rowid", offset, IntegerType.ROW_ID_TYPE, true);
    }

    TiColumnInfo copyWithoutPrimaryKey() {
        InternalTypeHolder typeHolder = this.type.toTypeHolder();
        typeHolder.setFlag(this.type.getFlag() & 0xFFFFFFFD);
        DataType newType = DataTypeFactory.of(typeHolder);
        return new TiColumnInfo(this.id, this.name, this.offset, newType, this.schemaState, this.originDefaultValue, this.defaultValue, this.defaultValueBit, this.comment, this.version, this.generatedExprString, this.hidden);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean matchName(String name) {
        return this.name.equalsIgnoreCase(name) || String.format("`%s`", this.name).equalsIgnoreCase(name);
    }

    public int getOffset() {
        return this.offset;
    }

    public DataType getType() {
        return this.type;
    }

    public long getLength() {
        return this.getType().getLength();
    }

    public long getSize() {
        return this.getType().getSize();
    }

    SchemaState getSchemaState() {
        return this.schemaState;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultValueBit() {
        return this.defaultValueBit;
    }

    String getOriginDefaultValue() {
        if (this.getType().getType() == MySQLType.TypeBit && this.originDefaultValue != null && this.defaultValueBit != null) {
            return this.defaultValueBit;
        }
        return this.originDefaultValue;
    }

    private ByteString getOriginDefaultValueAsByteString() {
        CodecDataOutput cdo = new CodecDataOutput();
        this.type.encode(cdo, DataType.EncodeType.VALUE, this.type.getOriginDefaultValue(this.getOriginDefaultValue(), this.version));
        return cdo.toByteString();
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isAutoIncrement() {
        return this.type.isAutoIncrement();
    }

    TiIndexColumn toUnSpecifiedLenIndexColumn() {
        return new TiIndexColumn(CIStr.newCIStr(this.getName()), this.getOffset(), -1L);
    }

    TiIndexColumn toIndexColumn() {
        return new TiIndexColumn(CIStr.newCIStr(this.getName()), this.getOffset(), this.getType().getLength());
    }

    ColumnInfo toOldProto(TiTableInfo tableInfo) {
        return ColumnInfo.newBuilder().setColumnId(this.id).setTp(this.type.getTypeCode()).setCollation(this.type.getCollationCode()).setColumnLen((int)this.type.getLength()).setDecimal(this.type.getDecimal()).setFlag(this.type.getFlag()).setDefaultVal(this.getOriginDefaultValueAsByteString()).setPkHandle(tableInfo.isPkHandle() && this.isPrimaryKey()).addAllElems(this.type.getElems()).build();
    }

    ColumnInfo toProto(TiTableInfo tableInfo) {
        return ColumnInfo.newBuilder().setColumnId(this.id).setTp(this.type.getTypeCode()).setCollation(Collation.rewriteNewCollationIDIfNeeded(this.type.getCollationCode())).setColumnLen((int)this.type.getLength()).setDecimal(this.type.getDecimal()).setFlag(this.type.getFlag()).setDefaultVal(this.getOriginDefaultValueAsByteString()).setPkHandle(tableInfo.isPkHandle() && this.isPrimaryKey()).addAllElems(this.type.getElems()).build();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TiColumnInfo)) {
            return false;
        }
        TiColumnInfo col = (TiColumnInfo)other;
        return Objects.equals(this.id, col.id) && Objects.equals(this.name, col.name) && Objects.equals(this.type, col.type) && Objects.equals((Object)this.schemaState, (Object)col.schemaState) && this.isPrimaryKey == col.isPrimaryKey && Objects.equals(this.defaultValue, col.defaultValue) && Objects.equals(this.originDefaultValue, col.originDefaultValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.type, this.schemaState, this.isPrimaryKey, this.defaultValue, this.originDefaultValue});
    }

    public String getGeneratedExprString() {
        return this.generatedExprString;
    }

    public boolean isGeneratedColumn() {
        return this.generatedExprString != null && !this.generatedExprString.isEmpty();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InternalTypeHolder {
        private int tp;
        private int flag;
        private long flen;
        private int decimal;
        private String charset;
        private String collate;
        private List<String> elems;

        @JsonCreator
        public InternalTypeHolder(@JsonProperty(value="Tp") int tp, @JsonProperty(value="Flag") int flag, @JsonProperty(value="Flen") long flen, @JsonProperty(value="Decimal") int decimal, @JsonProperty(value="Charset") String charset, @JsonProperty(value="Collate") String collate, @JsonProperty(value="Elems") List<String> elems) {
            this.tp = tp;
            this.flag = flag;
            this.flen = flen;
            this.decimal = decimal;
            this.charset = charset;
            this.collate = collate;
            this.elems = elems;
        }

        public int getTp() {
            return this.tp;
        }

        public void setTp(int tp) {
            this.tp = tp;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setFlag(int flag) {
            this.flag = flag;
        }

        public long getFlen() {
            return this.flen;
        }

        public void setFlen(long flen) {
            this.flen = flen;
        }

        public int getDecimal() {
            return this.decimal;
        }

        public void setDecimal(int decimal) {
            this.decimal = decimal;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String getCollate() {
            return this.collate;
        }

        public void setCollate(String collate) {
            this.collate = collate;
        }

        public List<String> getElems() {
            return this.elems;
        }

        public void setElems(List<String> elems) {
            this.elems = elems;
        }

        static interface Builder<E extends DataType> {
            public E build(InternalTypeHolder var1);
        }
    }
}

