/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.meta;

import com.pingcap.tidb.tipb.Aggregation;
import com.pingcap.tidb.tipb.ByItem;
import com.pingcap.tidb.tipb.ColumnInfo;
import com.pingcap.tidb.tipb.DAGRequest;
import com.pingcap.tidb.tipb.EncodeType;
import com.pingcap.tidb.tipb.ExecType;
import com.pingcap.tidb.tipb.Executor;
import com.pingcap.tidb.tipb.IndexScan;
import com.pingcap.tidb.tipb.Limit;
import com.pingcap.tidb.tipb.Selection;
import com.pingcap.tidb.tipb.TableScan;
import com.pingcap.tidb.tipb.TopN;
import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.expression.AggregateFunction;
import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.visitor.ProtoConverter;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiIndexColumn;
import com.pingcap.tikv.meta.TiIndexInfo;
import com.pingcap.tikv.meta.TiPartitionDef;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.predicates.IndexRange;
import com.pingcap.tikv.predicates.PredicateUtils;
import com.pingcap.tikv.predicates.TiKVScanAnalyzer;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.IntegerType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.tikv.common.exception.DAGRequestException;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.meta.TiTimestamp;
import org.tikv.common.region.TiStoreType;
import org.tikv.kvproto.Coprocessor;
import org.tikv.shade.com.google.common.annotations.VisibleForTesting;
import org.tikv.shade.com.google.common.base.Joiner;
import org.tikv.shade.com.google.common.base.Preconditions;
import org.tikv.shade.com.google.common.collect.ImmutableList;
import org.tikv.shade.com.google.common.collect.ImmutableMap;
import org.tikv.shade.com.google.common.collect.Range;

public class TiDAGRequest
implements Serializable {
    private static final Map<ExecType, Integer> EXEC_TYPE_PRIORITY_MAP = ImmutableMap.builder().put(ExecType.TypeTableScan, 0).put(ExecType.TypeIndexScan, 0).put(ExecType.TypeSelection, 1).put(ExecType.TypeAggregation, 2).put(ExecType.TypeTopN, 3).put(ExecType.TypeLimit, 4).build();
    private static final ColumnInfo handleColumn = ColumnInfo.newBuilder().setColumnId(-1L).setPkHandle(true).setTp(8).setColumnLen(20).setFlag(2).build();
    private final List<ColumnRef> fields = new ArrayList<ColumnRef>();
    private final List<Expression> filters = new ArrayList<Expression>();
    private final List<Expression> rangeFilters = new ArrayList<Expression>();
    private final List<com.pingcap.tikv.expression.ByItem> groupByItems = new ArrayList<com.pingcap.tikv.expression.ByItem>();
    private final List<com.pingcap.tikv.expression.ByItem> orderByItems = new ArrayList<com.pingcap.tikv.expression.ByItem>();
    private final List<AggregateFunction> aggregates = new ArrayList<AggregateFunction>();
    private final Map<Long, List<Coprocessor.KeyRange>> idToRanges = new HashMap<Long, List<Coprocessor.KeyRange>>();
    private final List<Expression> downgradeFilters = new ArrayList<Expression>();
    private final List<Expression> pushDownFilters = new ArrayList<Expression>();
    private final List<AggregateFunction> pushDownAggregates = new ArrayList<AggregateFunction>();
    private final List<com.pingcap.tikv.expression.ByItem> pushDownGroupBys = new ArrayList<com.pingcap.tikv.expression.ByItem>();
    private final List<com.pingcap.tikv.expression.ByItem> pushDownOrderBys = new ArrayList<com.pingcap.tikv.expression.ByItem>();
    private final PushDownType pushDownType;
    private TiTableInfo tableInfo;
    private List<TiPartitionDef> prunedParts;
    private TiStoreType storeType = TiStoreType.TiKV;
    private TiIndexInfo indexInfo;
    private List<Long> prunedPhysicalIds = new ArrayList<Long>();
    private final Map<Long, String> prunedPartNames = new HashMap<Long, String>();
    private long physicalId;
    private int pushDownLimits;
    private int limit;
    private int timeZoneOffset;
    private long flags;
    private TiTimestamp startTs;
    private Expression having;
    private boolean distinct;
    private boolean isDoubleRead;
    private EncodeType encodeType;
    private double estimatedCount = -1.0;
    private List<DataType> resultTypes = new ArrayList<DataType>();

    public TiDAGRequest(PushDownType pushDownType) {
        this.pushDownType = pushDownType;
        this.encodeType = EncodeType.TypeDefault;
    }

    private TiDAGRequest(PushDownType pushDownType, EncodeType encodeType) {
        this.pushDownType = pushDownType;
        this.encodeType = encodeType;
    }

    public TiDAGRequest(PushDownType pushDownType, EncodeType encodeType, int timeZoneOffset) {
        this(pushDownType, encodeType);
        this.timeZoneOffset = timeZoneOffset;
    }

    public TiDAGRequest(PushDownType pushDownType, int timeZoneOffset) {
        this(pushDownType, EncodeType.TypeDefault);
        this.timeZoneOffset = timeZoneOffset;
    }

    public List<TiPartitionDef> getPrunedParts() {
        return this.prunedParts;
    }

    private String getPrunedPartName(long id) {
        return this.prunedPartNames.getOrDefault(id, "unknown");
    }

    public void setPrunedParts(List<TiPartitionDef> prunedParts) {
        this.prunedParts = prunedParts;
        if (prunedParts != null) {
            ArrayList<Long> ids = new ArrayList<Long>();
            this.prunedPartNames.clear();
            for (TiPartitionDef pDef : prunedParts) {
                ids.add(pDef.getId());
                this.prunedPartNames.put(pDef.getId(), pDef.getName());
            }
            this.prunedPhysicalIds = ids;
        }
    }

    public List<Long> getPrunedPhysicalIds() {
        if (!this.tableInfo.isPartitionEnabled()) {
            this.prunedPhysicalIds = ImmutableList.of(Long.valueOf(this.tableInfo.getId()));
            return this.prunedPhysicalIds;
        }
        return this.prunedPhysicalIds;
    }

    public TiStoreType getStoreType() {
        return this.storeType;
    }

    public void setStoreType(TiStoreType storeType) {
        this.storeType = storeType;
    }

    public EncodeType getEncodeType() {
        return this.encodeType;
    }

    public void setEncodeType(EncodeType encodeType) {
        this.encodeType = encodeType;
    }

    public boolean isCommonHandle() {
        return this.tableInfo.isCommonHandle();
    }

    public DAGRequest buildDAGGetIndexData() {
        ArrayList<Integer> outputOffsets = new ArrayList<Integer>();
        DAGRequest.Builder dagRequestBuilder = DAGRequest.newBuilder();
        IndexScan.Builder indexScanBuilder = IndexScan.newBuilder();
        Executor.Builder indexScanExecutor = Executor.newBuilder();
        HashMap<String, Integer> colOffsetInFieldMap = new HashMap<String, Integer>();
        this.resultTypes = new ArrayList<DataType>();
        if (this.indexInfo == null) {
            throw new TiClientInternalException("Index is empty for index scan");
        }
        indexScanExecutor.setTp(ExecType.TypeIndexScan);
        if (this.isDoubleRead()) {
            this.addIndexLookUpIndexRangeScanExecutorCols(indexScanBuilder, outputOffsets, colOffsetInFieldMap);
        } else {
            this.addIndexReaderIndexRangeScanExecutorCols(indexScanBuilder, outputOffsets, colOffsetInFieldMap);
        }
        indexScanBuilder.setTableId(this.getPhysicalId()).setIndexId(this.indexInfo.getId());
        if (this.tableInfo.isCommonHandle()) {
            for (TiIndexColumn col : this.tableInfo.getPrimaryKey().getIndexColumns()) {
                indexScanBuilder.addPrimaryColumnIds(this.tableInfo.getColumn(col.getName()).getId());
            }
        }
        dagRequestBuilder.addExecutors(indexScanExecutor.setIdxScan(indexScanBuilder).build());
        this.addPushDownExecutorToRequest(dagRequestBuilder, this.isDoubleRead, outputOffsets, colOffsetInFieldMap);
        return this.buildRequest(dagRequestBuilder, outputOffsets);
    }

    private void addIndexLookUpIndexRangeScanExecutorCols(IndexScan.Builder indexScanBuilder, List<Integer> outputOffsets, Map<String, Integer> colOffsetInFieldMap) {
        this.addIndexColsToScanBuilder(indexScanBuilder, colOffsetInFieldMap);
        if (this.isCommonHandle()) {
            for (TiIndexColumn indexColumn : this.tableInfo.getPrimaryKey().getIndexColumns()) {
                TiColumnInfo columnInfo = this.tableInfo.getColumn(indexColumn.getName());
                ColumnInfo.Builder colBuild = ColumnInfo.newBuilder(columnInfo.toProto(this.tableInfo));
                colOffsetInFieldMap.put(columnInfo.getName(), indexScanBuilder.getColumnsCount());
                outputOffsets.add(indexScanBuilder.getColumnsCount());
                this.resultTypes.add(columnInfo.getType());
                indexScanBuilder.addColumns(colBuild);
            }
        } else if (this.tableInfo.isPkHandle()) {
            TiColumnInfo pk = this.tableInfo.getPKIsHandleColumn();
            ColumnInfo.Builder colBuild = ColumnInfo.newBuilder(pk.toProto(this.tableInfo));
            colBuild.setPkHandle(true);
            colOffsetInFieldMap.put(pk.getName(), indexScanBuilder.getColumnsCount());
            outputOffsets.add(indexScanBuilder.getColumnsCount());
            this.resultTypes.add(IntegerType.BIGINT);
            indexScanBuilder.addColumns(colBuild);
        } else {
            outputOffsets.add(indexScanBuilder.getColumnsCount());
            this.resultTypes.add(IntegerType.BIGINT);
            indexScanBuilder.addColumns(handleColumn);
        }
    }

    private void addIndexReaderIndexRangeScanExecutorCols(IndexScan.Builder indexScanBuilder, List<Integer> outputOffset, Map<String, Integer> colOffsetInFieldMap) {
        Set<Long> indexAndPrimaryColIDSet = this.getIndexAndPrimaryColIDSet();
        this.addIndexColsToScanBuilder(indexScanBuilder, colOffsetInFieldMap);
        for (ColumnRef columnRef : this.getFields()) {
            TiColumnInfo columnInfo = this.tableInfo.getColumn(columnRef.getName());
            if (indexAndPrimaryColIDSet.contains(columnInfo.getId())) {
                Integer pos = colOffsetInFieldMap.get(columnInfo.getName());
                if (pos != null) {
                    outputOffset.add(pos);
                    this.resultTypes.add(columnInfo.getType());
                    continue;
                }
                ColumnInfo.Builder colBuild = ColumnInfo.newBuilder(columnInfo.toProto(this.tableInfo));
                colOffsetInFieldMap.put(columnInfo.getName(), indexScanBuilder.getColumnsCount());
                outputOffset.add(indexScanBuilder.getColumnsCount());
                this.resultTypes.add(columnInfo.getType());
                indexScanBuilder.addColumns(colBuild);
                continue;
            }
            throw new DAGRequestException("columns other than primary key and index key exist in fields while index single read: " + columnInfo.getName());
        }
    }

    private void addIndexColsToScanBuilder(IndexScan.Builder indexScanBuilder, Map<String, Integer> colOffsetInFieldMap) {
        for (TiIndexColumn indexColumn : this.indexInfo.getIndexColumns()) {
            TiColumnInfo tableInfoColumn = this.tableInfo.getColumn(indexColumn.getName());
            ColumnInfo.Builder colBuild = ColumnInfo.newBuilder(tableInfoColumn.toProto(this.tableInfo));
            colOffsetInFieldMap.put(tableInfoColumn.getName(), indexScanBuilder.getColumnsCount());
            indexScanBuilder.addColumns(colBuild);
        }
    }

    public DAGRequest buildDAGGetTableData() {
        ArrayList<Integer> outputOffsets = new ArrayList<Integer>();
        DAGRequest.Builder dagRequestBuilder = DAGRequest.newBuilder();
        Executor.Builder tableScanExecutor = Executor.newBuilder();
        TableScan.Builder tblScanBuilder = TableScan.newBuilder();
        HashMap<String, Integer> colOffsetInFieldMap = new HashMap<String, Integer>();
        tableScanExecutor.setTp(ExecType.TypeTableScan);
        tblScanBuilder.setTableId(this.getPhysicalId());
        this.resultTypes = new ArrayList<DataType>();
        int lastOffset = 0;
        if (this.tableInfo.isCommonHandle()) {
            for (TiIndexColumn tiIndexColumn : this.tableInfo.getPrimaryKey().getIndexColumns()) {
                tblScanBuilder.addPrimaryColumnIds(this.tableInfo.getColumn(tiIndexColumn.getName()).getId());
            }
        }
        for (ColumnRef columnRef : this.getFields()) {
            if (!colOffsetInFieldMap.containsKey(columnRef.getName())) {
                TiColumnInfo columnInfo = this.tableInfo.getColumn(columnRef.getName());
                colOffsetInFieldMap.put(columnRef.getName(), lastOffset);
                ++lastOffset;
                tblScanBuilder.addColumns(columnInfo.toOldProto(this.tableInfo));
            }
            outputOffsets.add((Integer)colOffsetInFieldMap.get(columnRef.getName()));
            this.resultTypes.add(this.tableInfo.getColumn(columnRef.getName()).getType());
        }
        dagRequestBuilder.addExecutors(tableScanExecutor.setTblScan(tblScanBuilder));
        this.addPushDownExecutorToRequest(dagRequestBuilder, false, outputOffsets, colOffsetInFieldMap);
        return this.buildRequest(dagRequestBuilder, outputOffsets);
    }

    private DAGRequest buildRequest(DAGRequest.Builder dagRequestBuilder, List<Integer> outputOffsets) {
        Preconditions.checkNotNull(this.startTs, "startTs is null");
        Preconditions.checkArgument(this.startTs.getVersion() != 0L, "timestamp is 0");
        DAGRequest request = dagRequestBuilder.setTimeZoneOffset(this.timeZoneOffset).setFlags(this.flags).addAllOutputOffsets(outputOffsets).setEncodeType(this.encodeType).setStartTsFallback(this.startTs.getVersion()).build();
        this.validateRequest(request);
        return request;
    }

    private void addPushDownExecutorToRequest(DAGRequest.Builder dagRequestBuilder, boolean isCoverCheckCoverNeed, List<Integer> outputOffsets, Map<String, Integer> colOffsetInFieldMap) {
        Executor.Builder executorBuilder = Executor.newBuilder();
        if (!this.getFilters().isEmpty()) {
            if (!isCoverCheckCoverNeed || this.isFilterCoveredByIndex()) {
                this.pushDownFilters(dagRequestBuilder, executorBuilder, colOffsetInFieldMap);
            } else {
                return;
            }
        }
        if (!this.getGroupByItems().isEmpty() || !this.getAggregates().isEmpty()) {
            if (!isCoverCheckCoverNeed || this.isGroupByCoveredByIndex() && this.isAggregateCoveredByIndex()) {
                this.pushDownAggAndGroupBy(dagRequestBuilder, executorBuilder, outputOffsets, colOffsetInFieldMap);
            } else {
                return;
            }
        }
        if (!this.getOrderByItems().isEmpty()) {
            if (!isCoverCheckCoverNeed || this.isOrderByCoveredByIndex()) {
                this.pushDownOrderBy(dagRequestBuilder, executorBuilder, colOffsetInFieldMap);
            }
        } else if (this.getLimit() != 0 && !isCoverCheckCoverNeed) {
            this.pushDownLimit(dagRequestBuilder, executorBuilder);
        }
    }

    private Set<Long> getIndexAndPrimaryColIDSet() {
        HashSet<Long> indexAndPrimaryColIDSet = new HashSet<Long>();
        if (this.tableInfo.isCommonHandle()) {
            for (TiIndexColumn indexColumn : this.tableInfo.getPrimaryKey().getIndexColumns()) {
                indexAndPrimaryColIDSet.add(this.tableInfo.getColumn(indexColumn.getName()).getId());
            }
            indexAndPrimaryColIDSet.add(handleColumn.getColumnId());
        } else if (this.tableInfo.isPkHandle()) {
            indexAndPrimaryColIDSet.add(this.tableInfo.getPKIsHandleColumn().getId());
        } else {
            indexAndPrimaryColIDSet.add(handleColumn.getColumnId());
        }
        for (TiIndexColumn indexColumn : this.indexInfo.getIndexColumns()) {
            indexAndPrimaryColIDSet.add(this.tableInfo.getColumn(indexColumn.getName()).getId());
        }
        return indexAndPrimaryColIDSet;
    }

    private void pushDownFilters(DAGRequest.Builder dagRequestBuilder, Executor.Builder executorBuilder, Map<String, Integer> colOffsetInFieldMap) {
        Expression whereExpr = PredicateUtils.mergeCNFExpressions(this.getFilters());
        executorBuilder.setTp(ExecType.TypeSelection);
        dagRequestBuilder.addExecutors(executorBuilder.setSelection(Selection.newBuilder().addConditions(ProtoConverter.toProto(whereExpr, colOffsetInFieldMap))));
        executorBuilder.clear();
        this.addPushDownFilters();
    }

    private void pushDownLimit(DAGRequest.Builder dagRequestBuilder, Executor.Builder executorBuilder) {
        Limit.Builder limitBuilder = Limit.newBuilder();
        limitBuilder.setLimit(this.getLimit());
        executorBuilder.setTp(ExecType.TypeLimit);
        dagRequestBuilder.addExecutors(executorBuilder.setLimit(limitBuilder));
        executorBuilder.clear();
        this.addPushDownLimits();
    }

    private void pushDownOrderBy(DAGRequest.Builder dagRequestBuilder, Executor.Builder executorBuilder, Map<String, Integer> colOffsetInFieldMap) {
        TopN.Builder topNBuilder = TopN.newBuilder();
        this.getOrderByItems().forEach(tiByItem -> topNBuilder.addOrderBy(ByItem.newBuilder().setExpr(ProtoConverter.toProto(tiByItem.getExpr(), colOffsetInFieldMap)).setDesc(tiByItem.isDesc())));
        executorBuilder.setTp(ExecType.TypeTopN);
        topNBuilder.setLimit(this.getLimit());
        dagRequestBuilder.addExecutors(executorBuilder.setTopN(topNBuilder));
        executorBuilder.clear();
        this.addPushDownOrderBys();
    }

    private void pushDownAggAndGroupBy(DAGRequest.Builder dagRequestBuilder, Executor.Builder executorBuilder, List<Integer> outputOffsets, Map<String, Integer> colOffsetInFieldMap) {
        Aggregation.Builder aggregationBuilder = Aggregation.newBuilder();
        this.getAggregates().forEach(tiExpr -> aggregationBuilder.addAggFunc(ProtoConverter.toProto(tiExpr, colOffsetInFieldMap)));
        this.getGroupByItems().forEach(tiByItem -> aggregationBuilder.addGroupBy(ProtoConverter.toProto(tiByItem.getExpr(), colOffsetInFieldMap)));
        executorBuilder.setTp(ExecType.TypeAggregation);
        dagRequestBuilder.addExecutors(executorBuilder.setAggregation(aggregationBuilder));
        executorBuilder.clear();
        this.addPushDownGroupBys();
        this.addPushDownAggregates();
        outputOffsets.clear();
        this.resultTypes = new ArrayList<DataType>();
        for (int i = 0; i < this.getAggregates().size(); ++i) {
            outputOffsets.add(i);
            this.resultTypes.add(this.pushDownAggregates.get(i).getDataType());
        }
        int currentMaxOutputOffset = outputOffsets.get(outputOffsets.size() - 1) + 1;
        for (int i = 0; i < this.getGroupByItems().size(); ++i) {
            outputOffsets.add(currentMaxOutputOffset + i);
            this.resultTypes.add(this.groupByItems.get(i).getExpr().getDataType());
        }
    }

    private boolean isExpressionCoveredByIndex(Expression expr) {
        Set indexColumnRefSet = this.indexInfo.getIndexColumns().stream().filter(x -> !x.isPrefixIndex()).map(TiIndexColumn::getName).collect(Collectors.toSet());
        return PredicateUtils.extractColumnRefFromExpression(expr).stream().map(ColumnRef::getName).allMatch(indexColumnRefSet::contains);
    }

    private boolean isFilterCoveredByIndex() {
        if (this.filters.isEmpty()) {
            return false;
        }
        return this.filters.stream().allMatch(this::isExpressionCoveredByIndex);
    }

    private boolean isGroupByCoveredByIndex() {
        return this.isByItemCoveredByIndex(this.getGroupByItems());
    }

    private boolean isOrderByCoveredByIndex() {
        return this.isByItemCoveredByIndex(this.getOrderByItems());
    }

    private boolean isByItemCoveredByIndex(List<com.pingcap.tikv.expression.ByItem> byItems) {
        if (byItems.isEmpty()) {
            return false;
        }
        return byItems.stream().allMatch(x -> this.isExpressionCoveredByIndex(x.getExpr()));
    }

    private boolean isAggregateCoveredByIndex() {
        if (this.aggregates.isEmpty()) {
            return false;
        }
        return this.aggregates.stream().allMatch(this::isExpressionCoveredByIndex);
    }

    private void validateRequest(DAGRequest dagRequest) {
        Objects.requireNonNull(dagRequest);
        Objects.requireNonNull(dagRequest.getEncodeType());
        if (dagRequest.getExecutorsCount() < 1) {
            throw new DAGRequestException("Invalid executors count:" + dagRequest.getExecutorsCount());
        }
        ExecType formerType = dagRequest.getExecutors(0).getTp();
        if (formerType != ExecType.TypeTableScan && formerType != ExecType.TypeIndexScan) {
            throw new DAGRequestException("Invalid first executor type:" + formerType + ", must one of TypeTableScan or TypeIndexScan");
        }
        for (int i = 1; i < dagRequest.getExecutorsCount(); ++i) {
            ExecType currentType = dagRequest.getExecutors(i).getTp();
            if (EXEC_TYPE_PRIORITY_MAP.get(currentType) < EXEC_TYPE_PRIORITY_MAP.get(formerType)) {
                throw new DAGRequestException("Invalid executor priority.");
            }
            formerType = currentType;
        }
    }

    public TiTableInfo getTableInfo() {
        return this.tableInfo;
    }

    public TiDAGRequest setTableInfo(TiTableInfo tableInfo) {
        this.tableInfo = Objects.requireNonNull(tableInfo, "tableInfo is null");
        this.setPhysicalId(tableInfo.getId());
        return this;
    }

    public long getPhysicalId() {
        return this.physicalId;
    }

    public TiDAGRequest setPhysicalId(long id) {
        this.physicalId = id;
        return this;
    }

    public TiIndexInfo getIndexInfo() {
        return this.indexInfo;
    }

    public List<DataType> getResultTypes() {
        return this.resultTypes;
    }

    public TiDAGRequest setIndexInfo(TiIndexInfo indexInfo) {
        this.indexInfo = Objects.requireNonNull(indexInfo, "indexInfo is null");
        return this;
    }

    public void clearIndexInfo() {
        this.indexInfo = null;
        this.clearPushDownInfo();
    }

    public int getLimit() {
        return this.limit;
    }

    public TiDAGRequest setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    int getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    TiDAGRequest setTruncateMode(TruncateMode mode) {
        this.flags = Objects.requireNonNull(mode, "mode is null").mask(this.flags);
        return this;
    }

    @VisibleForTesting
    long getFlags() {
        return this.flags;
    }

    @VisibleForTesting
    public TiTimestamp getStartTs() {
        return this.startTs;
    }

    public TiDAGRequest setStartTs(@Nonnull TiTimestamp startTs) {
        this.startTs = startTs;
        return this;
    }

    public TiDAGRequest setHaving(Expression having) {
        this.having = Objects.requireNonNull(having, "having is null");
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public TiDAGRequest setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public TiDAGRequest addAggregate(AggregateFunction expr) {
        Objects.requireNonNull(expr, "aggregation expr is null");
        this.aggregates.add(expr);
        return this;
    }

    List<AggregateFunction> getAggregates() {
        return this.aggregates;
    }

    public TiDAGRequest addOrderByItem(com.pingcap.tikv.expression.ByItem byItem) {
        this.orderByItems.add(Objects.requireNonNull(byItem, "byItem is null"));
        return this;
    }

    List<com.pingcap.tikv.expression.ByItem> getOrderByItems() {
        return this.orderByItems;
    }

    public TiDAGRequest addGroupByItem(com.pingcap.tikv.expression.ByItem byItem) {
        this.groupByItems.add(Objects.requireNonNull(byItem, "byItem is null"));
        return this;
    }

    public List<com.pingcap.tikv.expression.ByItem> getGroupByItems() {
        return this.groupByItems;
    }

    public TiDAGRequest addRequiredColumn(ColumnRef column) {
        if (!column.isResolved()) {
            throw new UnsupportedOperationException(String.format("cannot add unresolved column %s to dag request", column.getName()));
        }
        this.fields.add(Objects.requireNonNull(column, "columnRef is null"));
        return this;
    }

    public List<ColumnRef> getFields() {
        return this.fields;
    }

    public TiDAGRequest addRanges(Map<Long, List<Coprocessor.KeyRange>> ranges, List<Expression> rangeFilters) {
        this.idToRanges.putAll(Objects.requireNonNull(ranges, "KeyRange is null"));
        this.rangeFilters.addAll(rangeFilters);
        return this;
    }

    private void resetRanges() {
        this.idToRanges.clear();
        this.rangeFilters.clear();
    }

    public void resetFilters(List<Expression> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
    }

    public List<Coprocessor.KeyRange> getRangesByPhysicalId(long physicalId) {
        return this.idToRanges.get(physicalId);
    }

    public Map<Long, List<Coprocessor.KeyRange>> getRangesMaps() {
        return this.idToRanges;
    }

    public TiDAGRequest addFilters(List<Expression> filters) {
        this.filters.addAll((Collection<Expression>)Objects.requireNonNull(filters, "filters expr is null"));
        return this;
    }

    public List<Expression> getFilters() {
        return this.filters;
    }

    public void addDowngradeFilter(Expression filter) {
        this.downgradeFilters.add(Objects.requireNonNull(filter, "downgrade filter is null"));
    }

    public List<Expression> getDowngradeFilters() {
        return this.downgradeFilters;
    }

    private void addPushDownFilters() {
        this.pushDownFilters.addAll(this.filters);
    }

    private List<Expression> getPushDownFilters() {
        return this.pushDownFilters;
    }

    private void addPushDownAggregates() {
        this.pushDownAggregates.addAll(this.aggregates);
    }

    public List<AggregateFunction> getPushDownAggregates() {
        return this.pushDownAggregates;
    }

    private void addPushDownGroupBys() {
        this.pushDownGroupBys.addAll(this.getGroupByItems());
    }

    public List<com.pingcap.tikv.expression.ByItem> getPushDownGroupBys() {
        return this.pushDownGroupBys;
    }

    private void addPushDownOrderBys() {
        this.pushDownOrderBys.addAll(this.getOrderByItems());
    }

    public List<com.pingcap.tikv.expression.ByItem> getPushDownOrderBys() {
        return this.pushDownOrderBys;
    }

    private void addPushDownLimits() {
        this.pushDownLimits = this.limit;
    }

    private int getPushDownLimits() {
        return this.pushDownLimits;
    }

    private void clearPushDownInfo() {
        this.resultTypes = new ArrayList<DataType>();
        this.pushDownFilters.clear();
        this.pushDownAggregates.clear();
        this.pushDownGroupBys.clear();
        this.pushDownOrderBys.clear();
        this.pushDownLimits = 0;
    }

    public boolean hasPushDownAggregate() {
        return !this.getPushDownAggregates().isEmpty();
    }

    public boolean hasPushDownGroupBy() {
        return !this.getPushDownGroupBys().isEmpty();
    }

    public boolean isDoubleRead() {
        return this.isDoubleRead;
    }

    public void setIsDoubleRead(boolean isDoubleRead) {
        this.isDoubleRead = isDoubleRead;
    }

    private boolean isIndexReader() {
        return this.hasIndex() && !this.isDoubleRead();
    }

    public boolean hasIndex() {
        return this.indexInfo != null;
    }

    public PushDownType getPushDownType() {
        return this.pushDownType;
    }

    public double getEstimatedCount() {
        return this.estimatedCount;
    }

    public void setEstimatedCount(double estimatedCount) {
        this.estimatedCount = estimatedCount;
    }

    public void init(boolean readHandle) {
        if (readHandle) {
            this.buildDAGGetIndexData();
        } else if (this.hasIndex() && !this.isDoubleRead()) {
            this.buildDAGGetIndexData();
        } else {
            this.buildDAGGetTableData();
        }
    }

    public ScanType getScanType() {
        if (this.hasIndex()) {
            if (this.isDoubleRead) {
                return ScanType.INDEX_LOOKUP;
            }
            return ScanType.INDEX_READER;
        }
        return ScanType.TABLE_READER;
    }

    public String toString() {
        return this.toStringInternal();
    }

    private String toStringInternal() {
        StringBuilder sb = new StringBuilder();
        if (this.tableInfo != null) {
            sb.append(String.format("[table: %s] ", this.tableInfo.getName()));
        }
        switch (this.getScanType()) {
            case INDEX_LOOKUP: {
                sb.append("IndexLookUp");
                break;
            }
            case INDEX_READER: {
                sb.append("IndexReader");
                break;
            }
            case TABLE_READER: {
                sb.append("TableReader");
            }
        }
        if (!this.getFields().isEmpty()) {
            sb.append(", Columns: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getFields());
        }
        sb.append(": { ");
        switch (this.getScanType()) {
            case INDEX_LOOKUP: {
                sb.append("{").append(this.stringIndexRangeScan()).append("}");
                sb.append("; {").append(this.stringTableRowIDScan()).append("}");
                break;
            }
            case INDEX_READER: {
                sb.append(this.stringIndexRangeScan());
                break;
            }
            case TABLE_READER: {
                sb.append(this.stringTableRangeScan());
            }
        }
        sb.append(" }");
        sb.append(", startTs: ").append(this.startTs.getVersion());
        return sb.toString();
    }

    private String stringIndexRangeScan() {
        StringBuilder sb = new StringBuilder();
        this.clearPushDownInfo();
        this.buildDAGGetIndexData();
        sb.append("IndexRangeScan");
        sb.append(String.format("(Index:%s(", this.indexInfo.getName()));
        List colNames = this.indexInfo.getIndexColumns().stream().map(TiIndexColumn::getName).collect(Collectors.toList());
        Joiner.on(",").skipNulls().appendTo(sb, (Iterable<?>)colNames);
        sb.append(")): {");
        sb.append(this.stringScanRange());
        sb.append(" }");
        sb.append(this.stringPushDownExpression());
        return sb.toString();
    }

    private String stringTableRowIDScan() {
        this.clearPushDownInfo();
        this.buildDAGGetTableData();
        return "TableRowIDScan" + this.stringPushDownExpression();
    }

    private String stringTableRangeScan() {
        StringBuilder sb = new StringBuilder();
        this.clearPushDownInfo();
        this.buildDAGGetTableData();
        sb.append("TableRangeScan");
        sb.append(": {");
        sb.append(this.stringScanRange());
        sb.append(" }");
        sb.append(this.stringPushDownExpression());
        return sb.toString();
    }

    private String stringScanRange() {
        StringBuilder keyRange = new StringBuilder();
        if (!this.getRangesMaps().isEmpty()) {
            keyRange.append(" RangeFilter: [");
            Joiner.on(", ").skipNulls().appendTo(keyRange, (Iterable<?>)this.getRangeFilter());
            keyRange.append("]");
            keyRange.append(", Range: [");
            if (this.tableInfo.isPartitionEnabled()) {
                this.getRangesMaps().forEach((key, value) -> {
                    for (Coprocessor.KeyRange v : value) {
                        keyRange.append(" partition: ").append(this.getPrunedPartName((long)key));
                        keyRange.append(KeyUtils.formatBytesUTF8(v));
                    }
                });
            } else {
                this.getRangesMaps().values().forEach(vList -> {
                    for (Coprocessor.KeyRange range : vList) {
                        keyRange.append(KeyUtils.formatBytesUTF8(range));
                    }
                });
            }
            keyRange.append("]");
        }
        return keyRange.toString();
    }

    private String stringPushDownExpression() {
        StringBuilder sb = new StringBuilder();
        if (!this.getPushDownFilters().isEmpty()) {
            sb.append(", Selection: [");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getPushDownFilters());
            sb.append("]");
        }
        if (!this.getPushDownAggregates().isEmpty()) {
            sb.append(", Aggregates: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getPushDownAggregates());
        }
        if (!this.getPushDownGroupBys().isEmpty()) {
            sb.append(", Group By: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getPushDownGroupBys());
        }
        if (!this.getPushDownOrderBys().isEmpty()) {
            sb.append(", Order By: ");
            Joiner.on(", ").skipNulls().appendTo(sb, (Iterable<?>)this.getPushDownOrderBys());
        }
        if (this.getPushDownLimits() != 0) {
            sb.append(String.format(", Limit: [%d]", this.getPushDownLimits()));
        }
        return sb.toString();
    }

    public List<Expression> getRangeFilter() {
        return this.rangeFilters;
    }

    public TiDAGRequest copy() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (TiDAGRequest)ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TiDAGRequest copyReqWithPhysicalId(long id) {
        TiDAGRequest req = this.copy();
        req.setPhysicalId(id);
        List<Coprocessor.KeyRange> currentIdRange = req.getRangesByPhysicalId(id);
        ArrayList<Expression> rangeFilters = new ArrayList<Expression>(req.getRangeFilter());
        req.resetRanges();
        HashMap<Long, List<Coprocessor.KeyRange>> rangeMap = new HashMap<Long, List<Coprocessor.KeyRange>>();
        rangeMap.put(id, currentIdRange);
        req.addRanges(rangeMap, rangeFilters);
        return req;
    }

    public static class Builder {
        private final List<String> requiredCols = new ArrayList<String>();
        private final List<Expression> filters = new ArrayList<Expression>();
        private final List<com.pingcap.tikv.expression.ByItem> orderBys = new ArrayList<com.pingcap.tikv.expression.ByItem>();
        private final Map<Long, List<Coprocessor.KeyRange>> ranges = new HashMap<Long, List<Coprocessor.KeyRange>>();
        private TiTableInfo tableInfo;
        private long physicalId;
        private int limit;
        private TiTimestamp startTs;

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setFullTableScan(TiTableInfo tableInfo) {
            Objects.requireNonNull(tableInfo);
            this.setTableInfo(tableInfo);
            TiKVScanAnalyzer tiKVScanAnalyzer = new TiKVScanAnalyzer();
            IndexRange range = new IndexRange(null, Range.all());
            ArrayList<IndexRange> indexRanges = new ArrayList<IndexRange>();
            indexRanges.add(range);
            ArrayList<TiPartitionDef> prunedParts = new ArrayList<TiPartitionDef>();
            if (tableInfo.isPartitionEnabled()) {
                prunedParts.addAll(tableInfo.getPartitionInfo().getDefs());
            }
            this.ranges.putAll(tiKVScanAnalyzer.buildTableScanKeyRange(tableInfo, indexRanges, prunedParts));
            return this;
        }

        public Builder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder setTableInfo(TiTableInfo tableInfo) {
            this.tableInfo = tableInfo;
            this.setPhysicalId(tableInfo.getId());
            return this;
        }

        public Builder setPhysicalId(long id) {
            this.physicalId = id;
            return this;
        }

        public Builder addRequiredCols(List<String> cols) {
            this.requiredCols.addAll(cols);
            return this;
        }

        public Builder addFilter(Expression filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder addOrderBy(com.pingcap.tikv.expression.ByItem item) {
            this.orderBys.add(item);
            return this;
        }

        public Builder setStartTs(@Nonnull TiTimestamp ts) {
            this.startTs = ts;
            return this;
        }

        public TiDAGRequest build(PushDownType pushDownType) {
            TiDAGRequest req = new TiDAGRequest(pushDownType);
            req.setTableInfo(this.tableInfo);
            req.setPhysicalId(this.physicalId);
            req.addRanges(this.ranges, req.rangeFilters);
            req.addFilters(this.filters);
            req.addPushDownFilters();
            if (!this.orderBys.isEmpty()) {
                this.orderBys.forEach(req::addOrderByItem);
            }
            if (this.limit != 0) {
                req.setLimit(this.limit);
            }
            this.requiredCols.forEach(c -> req.addRequiredColumn(ColumnRef.create(c, this.tableInfo.getColumn((String)c))));
            req.setStartTs(this.startTs);
            return req;
        }
    }

    public static enum ScanType {
        INDEX_LOOKUP,
        INDEX_READER,
        TABLE_READER;

    }

    public static enum PushDownType {
        STREAMING,
        NORMAL;

    }

    public static enum TruncateMode {
        IgnoreTruncation(1L),
        TruncationAsWarning(2L);

        private final long mask;

        private TruncateMode(long mask) {
            this.mask = mask;
        }

        public long mask(long flags) {
            return flags | this.mask;
        }
    }
}

