/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.meta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingcap.tikv.meta.CIStr;
import com.pingcap.tikv.meta.TiPartitionDef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.tikv.shade.com.google.common.annotations.VisibleForTesting;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TiPartitionInfo
implements Serializable {
    private final long type;
    private final String expr;
    private final List<String> columns;
    private final boolean enable;
    private final List<TiPartitionDef> defs;

    @JsonCreator
    @VisibleForTesting
    public TiPartitionInfo(@JsonProperty(value="type") long type, @JsonProperty(value="expr") String expr, @JsonProperty(value="columns") List<CIStr> columns, @JsonProperty(value="enable") boolean enable, @JsonProperty(value="definitions") List<TiPartitionDef> defs) {
        this.type = type;
        this.expr = expr;
        this.columns = new ArrayList<String>();
        if (columns != null) {
            for (CIStr col : columns) {
                this.columns.add(col.getL());
            }
        }
        this.enable = enable;
        this.defs = defs;
    }

    public static long partTypeToLong(PartitionType type) {
        switch (type) {
            case RangePartition: {
                return 1L;
            }
            case HashPartition: {
                return 2L;
            }
            case ListPartition: {
                return 3L;
            }
        }
        return -1L;
    }

    public PartitionType getType() {
        return this.toPartType((int)this.type);
    }

    private PartitionType toPartType(int tp) {
        switch (tp) {
            case 1: {
                return PartitionType.RangePartition;
            }
            case 2: {
                return PartitionType.HashPartition;
            }
            case 3: {
                return PartitionType.ListPartition;
            }
        }
        return PartitionType.InvalidPartition;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getExpr() {
        return this.expr;
    }

    public List<TiPartitionDef> getDefs() {
        return this.defs;
    }

    public static enum PartitionType {
        RangePartition,
        HashPartition,
        ListPartition,
        InvalidPartition;

    }
}

